/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.item.ItemInstance;

public class ContainerClickPacket
extends Packet {
    public int containerId;
    public int slotNum;
    public int buttonNum;
    public short uid;
    public ItemInstance item;

    public ContainerClickPacket() {
    }

    public ContainerClickPacket(int n, int n2, int n3, ItemInstance itemInstance, short s) {
        this.containerId = n;
        this.slotNum = n2;
        this.buttonNum = n3;
        this.item = itemInstance;
        this.uid = s;
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleContainerClick(this);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.containerId = dataInputStream.readByte();
        this.slotNum = dataInputStream.readShort();
        this.buttonNum = dataInputStream.readByte();
        this.uid = dataInputStream.readShort();
        short s = dataInputStream.readShort();
        if (s >= 0) {
            byte by = dataInputStream.readByte();
            short s2 = dataInputStream.readShort();
            this.item = new ItemInstance(s, (int)by, (int)s2);
        } else {
            this.item = null;
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.containerId);
        dataOutputStream.writeShort(this.slotNum);
        dataOutputStream.writeByte(this.buttonNum);
        dataOutputStream.writeShort(this.uid);
        if (this.item == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(this.item.id);
            dataOutputStream.writeByte(this.item.count);
            dataOutputStream.writeShort(this.item.getAuxValue());
        }
    }

    public int getEstimatedSize() {
        return 11;
    }
}

