/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class ContainerAckPacket
extends Packet {
    public int containerId;
    public short uid;
    public boolean accepted;

    public ContainerAckPacket() {
    }

    public ContainerAckPacket(int n, short s, boolean bl) {
        this.containerId = n;
        this.uid = s;
        this.accepted = bl;
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleContainerAck(this);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.containerId = dataInputStream.readByte();
        this.uid = dataInputStream.readShort();
        this.accepted = dataInputStream.readByte() != 0;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.containerId);
        dataOutputStream.writeShort(this.uid);
        dataOutputStream.writeByte(this.accepted ? 1 : 0);
    }

    public int getEstimatedSize() {
        return 4;
    }
}

