/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class ChunkVisibilityPacket
extends Packet {
    public int x;
    public int z;
    public boolean visible;

    public ChunkVisibilityPacket() {
        this.shouldDelay = false;
    }

    public ChunkVisibilityPacket(int n, int n2, boolean bl) {
        this.shouldDelay = false;
        this.x = n;
        this.z = n2;
        this.visible = bl;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.x = dataInputStream.readInt();
        this.z = dataInputStream.readInt();
        this.visible = dataInputStream.read() != 0;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.write(this.visible ? 1 : 0);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleChunkVisibility(this);
    }

    public int getEstimatedSize() {
        return 9;
    }
}

