/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkTilesUpdatePacket
extends Packet {
    public int xc;
    public int zc;
    public short[] positions;
    public byte[] blocks;
    public byte[] data;
    public int count;

    public ChunkTilesUpdatePacket() {
        this.shouldDelay = true;
    }

    public ChunkTilesUpdatePacket(int n, int n2, short[] sArray, int n3, Level level) {
        this.shouldDelay = true;
        this.xc = n;
        this.zc = n2;
        this.count = n3;
        this.positions = new short[n3];
        this.blocks = new byte[n3];
        this.data = new byte[n3];
        LevelChunk levelChunk = level.getChunk(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4 = sArray[i] >> 12 & 0xF;
            int n5 = sArray[i] >> 8 & 0xF;
            int n6 = sArray[i] & 0xFF;
            this.positions[i] = sArray[i];
            this.blocks[i] = (byte)levelChunk.getTile(n4, n6, n5);
            this.data[i] = (byte)levelChunk.getData(n4, n6, n5);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.xc = dataInputStream.readInt();
        this.zc = dataInputStream.readInt();
        this.count = dataInputStream.readShort() & 0xFFFF;
        this.positions = new short[this.count];
        this.blocks = new byte[this.count];
        this.data = new byte[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.positions[i] = dataInputStream.readShort();
        }
        dataInputStream.readFully(this.blocks);
        dataInputStream.readFully(this.data);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.xc);
        dataOutputStream.writeInt(this.zc);
        dataOutputStream.writeShort((short)this.count);
        for (int i = 0; i < this.count; ++i) {
            dataOutputStream.writeShort(this.positions[i]);
        }
        dataOutputStream.write(this.blocks);
        dataOutputStream.write(this.data);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleChunkTilesUpdate(this);
    }

    public int getEstimatedSize() {
        return 10 + this.count * 4;
    }
}

