/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.level.Level;

public class BlockRegionUpdatePacket
extends Packet {
    public int x;
    public int y;
    public int z;
    public int xs;
    public int ys;
    public int zs;
    public byte[] buffer;
    private int size;

    public BlockRegionUpdatePacket() {
        this.shouldDelay = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockRegionUpdatePacket(int n, int n2, int n3, int n4, int n5, int n6, Level level) {
        this.shouldDelay = true;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.xs = n4;
        this.ys = n5;
        this.zs = n6;
        byte[] byArray = level.getBlocksAndData(n, n2, n3, n4, n5, n6);
        Deflater deflater = new Deflater(1);
        try {
            deflater.setInput(byArray);
            deflater.finish();
            this.buffer = new byte[n4 * n5 * n6 * 5 / 2];
            this.size = deflater.deflate(this.buffer);
        }
        finally {
            deflater.end();
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readShort();
        this.z = dataInputStream.readInt();
        this.xs = dataInputStream.read() + 1;
        this.ys = dataInputStream.read() + 1;
        this.zs = dataInputStream.read() + 1;
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        this.buffer = new byte[this.xs * this.ys * this.zs * 5 / 2];
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        try {
            inflater.inflate(this.buffer);
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeShort(this.y);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.write(this.xs - 1);
        dataOutputStream.write(this.ys - 1);
        dataOutputStream.write(this.zs - 1);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.write(this.buffer, 0, this.size);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleBlockRegionUpdate(this);
    }

    public int getEstimatedSize() {
        return 17 + this.size;
    }
}

