/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;
import util.Mth;

public class AddPlayerPacket
extends Packet {
    public int id;
    public String name;
    public int x;
    public int y;
    public int z;
    public byte yRot;
    public byte xRot;
    public int carriedItem;

    public AddPlayerPacket() {
    }

    public AddPlayerPacket(Player player) {
        this.id = player.entityId;
        this.name = player.name;
        this.x = Mth.floor(player.x * 32.0);
        this.y = Mth.floor(player.y * 32.0);
        this.z = Mth.floor(player.z * 32.0);
        this.yRot = (byte)(player.yRot * 256.0f / 360.0f);
        this.xRot = (byte)(player.xRot * 256.0f / 360.0f);
        ItemInstance itemInstance = player.inventory.getSelected();
        this.carriedItem = itemInstance == null ? 0 : itemInstance.id;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.name = dataInputStream.readUTF();
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readInt();
        this.z = dataInputStream.readInt();
        this.yRot = dataInputStream.readByte();
        this.xRot = dataInputStream.readByte();
        this.carriedItem = dataInputStream.readShort();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.y);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.writeByte(this.yRot);
        dataOutputStream.writeByte(this.xRot);
        dataOutputStream.writeShort(this.carriedItem);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleAddPlayer(this);
    }

    public int getEstimatedSize() {
        return 28;
    }
}

