/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.Painting;

public class AddPaintingPacket
extends Packet {
    public int id;
    public int x;
    public int y;
    public int z;
    public int dir;
    public String motive;

    public AddPaintingPacket() {
    }

    public AddPaintingPacket(Painting painting) {
        this.id = painting.entityId;
        this.x = painting.xTile;
        this.y = painting.yTile;
        this.z = painting.zTile;
        this.dir = painting.dir;
        this.motive = painting.motive.name;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.motive = dataInputStream.readUTF();
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readInt();
        this.z = dataInputStream.readInt();
        this.dir = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeUTF(this.motive);
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.y);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.writeInt(this.dir);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleAddPainting(this);
    }

    public int getEstimatedSize() {
        return 24;
    }
}

