/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.EntityIO;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SynchedEntityData;
import util.Mth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMobPacket
extends Packet {
    public int id;
    public byte type;
    public int x;
    public int y;
    public int z;
    public byte yRot;
    public byte xRot;
    private SynchedEntityData entityData;
    private List<SynchedEntityData.DataItem> unpack;

    public AddMobPacket() {
    }

    public AddMobPacket(Mob mob) {
        this.id = mob.entityId;
        this.type = (byte)EntityIO.getId(mob);
        this.x = Mth.floor(mob.x * 32.0);
        this.y = Mth.floor(mob.y * 32.0);
        this.z = Mth.floor(mob.z * 32.0);
        this.yRot = (byte)(mob.yRot * 256.0f / 360.0f);
        this.xRot = (byte)(mob.xRot * 256.0f / 360.0f);
        this.entityData = mob.getEntityData();
    }

    @Override
    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.type = dataInputStream.readByte();
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readInt();
        this.z = dataInputStream.readInt();
        this.yRot = dataInputStream.readByte();
        this.xRot = dataInputStream.readByte();
        this.unpack = SynchedEntityData.unpack(dataInputStream);
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.y);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.writeByte(this.yRot);
        dataOutputStream.writeByte(this.xRot);
        this.entityData.packAll(dataOutputStream);
    }

    @Override
    public void handle(PacketListener packetListener) {
        packetListener.handleAddMob(this);
    }

    @Override
    public int getEstimatedSize() {
        return 20;
    }

    public List<SynchedEntityData.DataItem> getUnpackedData() {
        return this.unpack;
    }
}

