/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.item.ItemEntity;
import util.Mth;

public class AddItemEntityPacket
extends Packet {
    public int id;
    public int x;
    public int y;
    public int z;
    public byte xa;
    public byte ya;
    public byte za;
    public int itemId;
    public int itemCount;
    public int auxValue;

    public AddItemEntityPacket() {
    }

    public AddItemEntityPacket(ItemEntity itemEntity) {
        this.id = itemEntity.entityId;
        this.itemId = itemEntity.item.id;
        this.itemCount = itemEntity.item.count;
        this.auxValue = itemEntity.item.getAuxValue();
        this.x = Mth.floor(itemEntity.x * 32.0);
        this.y = Mth.floor(itemEntity.y * 32.0);
        this.z = Mth.floor(itemEntity.z * 32.0);
        this.xa = (byte)(itemEntity.xd * 128.0);
        this.ya = (byte)(itemEntity.yd * 128.0);
        this.za = (byte)(itemEntity.zd * 128.0);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.itemId = dataInputStream.readShort();
        this.itemCount = dataInputStream.readByte();
        this.auxValue = dataInputStream.readShort();
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readInt();
        this.z = dataInputStream.readInt();
        this.xa = dataInputStream.readByte();
        this.ya = dataInputStream.readByte();
        this.za = dataInputStream.readByte();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeShort(this.itemId);
        dataOutputStream.writeByte(this.itemCount);
        dataOutputStream.writeShort(this.auxValue);
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.y);
        dataOutputStream.writeInt(this.z);
        dataOutputStream.writeByte(this.xa);
        dataOutputStream.writeByte(this.ya);
        dataOutputStream.writeByte(this.za);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleAddItemEntity(this);
    }

    public int getEstimatedSize() {
        return 24;
    }
}

