/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;
import net.minecraft.world.entity.Entity;
import util.Mth;

public class AddEntityPacket
extends Packet {
    public static final int BOAT = 1;
    public static final int MINECART_RIDEABLE = 10;
    public static final int MINECART_CHEST = 11;
    public static final int MINECART_FURNACE = 12;
    public static final int PRIMED_TNT = 50;
    public static final int ARROW = 60;
    public static final int SNOWBALL = 61;
    public static final int EGG = 62;
    public static final int FISH_HOOK = 90;
    public static final int FALLING_SAND = 70;
    public static final int FALLING_GRAVEL = 71;
    public int id;
    public int x;
    public int y;
    public int z;
    public int type;

    public AddEntityPacket() {
    }

    public AddEntityPacket(Entity entity, int n) {
        this.id = entity.entityId;
        this.x = Mth.floor(entity.x * 32.0);
        this.y = Mth.floor(entity.y * 32.0);
        this.z = Mth.floor(entity.z * 32.0);
        this.type = n;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.type = dataInputStream.readByte();
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readInt();
        this.z = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.y);
        dataOutputStream.writeInt(this.z);
    }

    public void handle(PacketListener packetListener) {
        packetListener.handleAddEntity(this);
    }

    public int getEstimatedSize() {
        return 17;
    }
}

