/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.PacketListener;

public class Connection {
    public static final Object threadCounterLock = new Object();
    public static int readThreads;
    public static int writeThreads;
    private Object writeLock = new Object();
    private static final int MAX_TICKS_WITHOUT_INPUT = 1200;
    public static final int IPTOS_LOWCOST = 2;
    public static final int IPTOS_RELIABILITY = 4;
    public static final int IPTOS_THROUGHPUT = 8;
    public static final int IPTOS_LOWDELAY = 16;
    private Socket socket;
    private final SocketAddress address;
    private DataInputStream dis;
    private DataOutputStream dos;
    private boolean running = true;
    private List<Packet> incoming = Collections.synchronizedList(new ArrayList());
    private List<Packet> outgoing = Collections.synchronizedList(new ArrayList());
    private List<Packet> outgoing_slow = Collections.synchronizedList(new ArrayList());
    private PacketListener packetListener;
    private boolean quitting = false;
    private Thread writeThread;
    private Thread readThread;
    private boolean disconnected = false;
    private String disconnectReason = "";
    private Object[] disconnectReasonObjects;
    private int noInputTicks = 0;
    private int estimatedRemaining = 0;
    public int fakeLag = 0;
    private int slowWriteDelay = 0;

    public Connection(Socket socket, String string, PacketListener packetListener) throws IOException {
        this.socket = socket;
        this.address = socket.getRemoteSocketAddress();
        this.packetListener = packetListener;
        socket.setTrafficClass(24);
        this.dis = new DataInputStream(socket.getInputStream());
        this.dos = new DataOutputStream(socket.getOutputStream());
        this.readThread = new Thread(string + " read thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = threadCounterLock;
                synchronized (object) {
                    ++readThreads;
                }
                try {
                    while (Connection.this.running && !Connection.this.quitting) {
                        Connection.this.readTick();
                    }
                }
                finally {
                    object = threadCounterLock;
                    synchronized (object) {
                        --readThreads;
                    }
                }
            }
        };
        this.writeThread = new Thread(string + " write thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = threadCounterLock;
                synchronized (object) {
                    ++writeThreads;
                }
                try {
                    while (Connection.this.running) {
                        Connection.this.writeTick();
                    }
                }
                finally {
                    object = threadCounterLock;
                    synchronized (object) {
                        --writeThreads;
                    }
                }
            }
        };
        this.readThread.start();
        this.writeThread.start();
    }

    public void setListener(PacketListener packetListener) {
        this.packetListener = packetListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet) {
        if (this.quitting) {
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.estimatedRemaining += packet.getEstimatedSize() + 1;
            if (packet.shouldDelay) {
                this.outgoing_slow.add(packet);
            } else {
                this.outgoing.add(packet);
            }
        }
    }

    public void queueSend(Packet packet) {
        if (this.quitting) {
            return;
        }
        this.outgoing_slow.add(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTick() {
        block12: {
            try {
                Packet packet;
                Object object;
                boolean bl = true;
                if (!(this.outgoing.isEmpty() || this.fakeLag != 0 && System.currentTimeMillis() - this.outgoing.get((int)0).createTime < (long)this.fakeLag)) {
                    bl = false;
                    object = this.writeLock;
                    synchronized (object) {
                        packet = this.outgoing.remove(0);
                        this.estimatedRemaining -= packet.getEstimatedSize() + 1;
                    }
                    Packet.writePacket(packet, this.dos);
                }
                if (!(!bl && this.slowWriteDelay-- > 0 || this.outgoing_slow.isEmpty() || this.fakeLag != 0 && System.currentTimeMillis() - this.outgoing_slow.get((int)0).createTime < (long)this.fakeLag)) {
                    bl = false;
                    object = this.writeLock;
                    synchronized (object) {
                        packet = this.outgoing_slow.remove(0);
                        this.estimatedRemaining -= packet.getEstimatedSize() + 1;
                    }
                    Packet.writePacket(packet, this.dos);
                    this.slowWriteDelay = 50;
                }
                if (bl) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                if (this.disconnected) break block12;
                this.handleException(exception);
            }
        }
    }

    private void readTick() {
        block4: {
            try {
                Packet packet = Packet.readPacket(this.dis);
                if (packet != null) {
                    this.incoming.add(packet);
                } else {
                    this.close("disconnect.endOfStream", new Object[0]);
                }
            }
            catch (Exception exception) {
                if (this.disconnected) break block4;
                this.handleException(exception);
            }
        }
    }

    private void handleException(Exception exception) {
        exception.printStackTrace();
        this.close("disconnect.genericReason", "Internal exception: " + exception.toString());
    }

    public void close(String string, Object ... objectArray) {
        if (!this.running) {
            return;
        }
        this.disconnected = true;
        this.disconnectReason = string;
        this.disconnectReasonObjects = objectArray;
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                    if (Connection.this.readThread.isAlive()) {
                        try {
                            Connection.this.readThread.stop();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (Connection.this.writeThread.isAlive()) {
                        try {
                            Connection.this.writeThread.stop();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }.start();
        this.running = false;
        try {
            this.dis.close();
            this.dis = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.dos.close();
            this.dos = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void tick() {
        if (this.estimatedRemaining > 0x100000) {
            this.close("disconnect.overflow", new Object[0]);
        }
        if (this.incoming.isEmpty()) {
            if (this.noInputTicks++ == 1200) {
                this.close("disconnect.timeout", new Object[0]);
            }
        } else {
            this.noInputTicks = 0;
        }
        int n = 100;
        while (!this.incoming.isEmpty() && n-- >= 0) {
            Packet packet = this.incoming.remove(0);
            packet.handle(this.packetListener);
        }
        if (this.disconnected && this.incoming.isEmpty()) {
            this.packetListener.onDisconnect(this.disconnectReason, this.disconnectReasonObjects);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.address;
    }

    public void sendAndQuit() {
        this.quitting = true;
        this.readThread.interrupt();
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                    if (Connection.this.running) {
                        Connection.this.writeThread.interrupt();
                        Connection.this.close("disconnect.closed", new Object[0]);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    public int countDelayedPackets() {
        return this.outgoing_slow.size();
    }
}

