/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.isom;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.isom.Zone;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class ZoneRenderer {
    private static final int IMG_WIDTH = 32;
    private static final int IMG_HEIGHT = 160;
    private float[] texCols = new float[768];
    private int[] pixels = new int[5120];
    private int[] zBuf = new int[5120];
    private int[] waterBuf = new int[5120];
    private int[] waterBr = new int[5120];
    private int[] yBuf = new int[34];
    private int[] textures = new int[768];

    public ZoneRenderer() {
        try {
            BufferedImage img = ImageIO.read(ZoneRenderer.class.getResource("/terrain.png"));
            int[] cols = new int[65536];
            img.getRGB(0, 0, 256, 256, cols, 0, 256);
            int i = 0;
            while (i < 256) {
                int r = 0;
                int g = 0;
                int b = 0;
                int xo = i % 16 * 16;
                int yo = i / 16 * 16;
                int count = 0;
                int y = 0;
                while (y < 16) {
                    int x = 0;
                    while (x < 16) {
                        int col = cols[x + xo + (y + yo) * 256];
                        int a = col >> 24 & 0xFF;
                        if (a > 128) {
                            r += col >> 16 & 0xFF;
                            g += col >> 8 & 0xFF;
                            b += col & 0xFF;
                            ++count;
                        }
                        ++x;
                    }
                    if (count == 0) {
                        ++count;
                    }
                    this.texCols[i * 3 + 0] = r / count;
                    this.texCols[i * 3 + 1] = g / count;
                    this.texCols[i * 3 + 2] = b / count;
                    ++y;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < 256) {
            if (Tile.tiles[i] != null) {
                this.textures[i * 3 + 0] = Tile.tiles[i].getTexture(1);
                this.textures[i * 3 + 1] = Tile.tiles[i].getTexture(2);
                this.textures[i * 3 + 2] = Tile.tiles[i].getTexture(3);
            }
            ++i;
        }
    }

    public void render(Zone zone) {
        Level level = zone.level;
        if (level == null) {
            zone.noContent = true;
            zone.rendered = true;
            return;
        }
        int x0 = zone.x * 16;
        int z0 = zone.y * 16;
        int x1 = x0 + 16;
        int z1 = z0 + 16;
        LevelChunk chunk = level.getChunk(zone.x, zone.y);
        if (chunk.isEmpty()) {
            zone.noContent = true;
            zone.rendered = true;
            return;
        }
        zone.noContent = false;
        Arrays.fill(this.zBuf, 0);
        Arrays.fill(this.waterBuf, 0);
        Arrays.fill(this.yBuf, 160);
        int z = z1 - 1;
        while (z >= z0) {
            int x = x1 - 1;
            while (x >= x0) {
                int xx = x - x0;
                int zz = z - z0;
                int xp = xx + zz;
                boolean solid = true;
                int y = 0;
                while (y < 128) {
                    int yp = zz - xx - y + 160 - 16;
                    if (yp < this.yBuf[xp] || yp < this.yBuf[xp + 1]) {
                        Tile t = Tile.tiles[level.getTile(x, y, z)];
                        if (t == null) {
                            solid = false;
                        } else if (t.material == Material.water) {
                            int ta = level.getTile(x, y + 1, z);
                            if (ta == 0 || Tile.tiles[ta].material != Material.water) {
                                float hh = (float)y / 127.0f * 0.6f + 0.4f;
                                float br = level.getBrightness(x, y + 1, z) * hh;
                                if (yp >= 0 && yp < 160) {
                                    int p = xp + yp * 32;
                                    if (xp >= 0 && xp <= 32 && this.waterBuf[p] <= y) {
                                        this.waterBuf[p] = y;
                                        this.waterBr[p] = (int)(br * 127.0f);
                                    }
                                    if (xp >= -1 && xp <= 31 && this.waterBuf[p + 1] <= y) {
                                        this.waterBuf[p + 1] = y;
                                        this.waterBr[p + 1] = (int)(br * 127.0f);
                                    }
                                    solid = false;
                                }
                            }
                        } else {
                            if (solid) {
                                if (yp < this.yBuf[xp]) {
                                    this.yBuf[xp] = yp;
                                }
                                if (yp < this.yBuf[xp + 1]) {
                                    this.yBuf[xp + 1] = yp;
                                }
                            }
                            float hh = (float)y / 127.0f * 0.6f + 0.4f;
                            if (yp >= 0 && yp < 160) {
                                float br;
                                int p = xp + yp * 32;
                                int upTex = this.textures[t.id * 3 + 0];
                                float upBr = (level.getBrightness(x, y + 1, z) * 0.8f + 0.2f) * hh;
                                int tex = upTex;
                                if (xp >= 0) {
                                    br = upBr;
                                    if (this.zBuf[p] <= y) {
                                        this.zBuf[p] = y;
                                        this.pixels[p] = 0xFF000000 | (int)(this.texCols[tex * 3 + 0] * br) << 16 | (int)(this.texCols[tex * 3 + 1] * br) << 8 | (int)(this.texCols[tex * 3 + 2] * br);
                                    }
                                }
                                if (xp < 31) {
                                    br = upBr * 0.9f;
                                    if (this.zBuf[p + 1] <= y) {
                                        this.zBuf[p + 1] = y;
                                        this.pixels[p + 1] = 0xFF000000 | (int)(this.texCols[tex * 3 + 0] * br) << 16 | (int)(this.texCols[tex * 3 + 1] * br) << 8 | (int)(this.texCols[tex * 3 + 2] * br);
                                    }
                                }
                            }
                            if (yp >= -1 && yp < 159) {
                                float br;
                                int p = xp + (yp + 1) * 32;
                                int lTex = this.textures[t.id * 3 + 1];
                                float lBr = level.getBrightness(x - 1, y, z) * 0.8f + 0.2f;
                                int rTex = this.textures[t.id * 3 + 2];
                                float rBr = level.getBrightness(x, y, z + 1) * 0.8f + 0.2f;
                                if (xp >= 0) {
                                    br = lBr * hh * 0.6f;
                                    if (this.zBuf[p] <= y - 1) {
                                        this.zBuf[p] = y - 1;
                                        this.pixels[p] = 0xFF000000 | (int)(this.texCols[lTex * 3 + 0] * br) << 16 | (int)(this.texCols[lTex * 3 + 1] * br) << 8 | (int)(this.texCols[lTex * 3 + 2] * br);
                                    }
                                }
                                if (xp < 31) {
                                    br = rBr * 0.9f * hh * 0.4f;
                                    if (this.zBuf[p + 1] <= y - 1) {
                                        this.zBuf[p + 1] = y - 1;
                                        this.pixels[p + 1] = 0xFF000000 | (int)(this.texCols[rTex * 3 + 0] * br) << 16 | (int)(this.texCols[rTex * 3 + 1] * br) << 8 | (int)(this.texCols[rTex * 3 + 2] * br);
                                    }
                                }
                            }
                        }
                    }
                    ++y;
                }
                --x;
            }
            --z;
        }
        this.postProcess();
        if (zone.image == null) {
            zone.image = new BufferedImage(32, 160, 2);
        }
        zone.image.setRGB(0, 0, 32, 160, this.pixels, 0, 32);
        zone.rendered = true;
    }

    private void postProcess() {
        int x = 0;
        while (x < 32) {
            int y = 0;
            while (y < 160) {
                int p = x + y * 32;
                if (this.zBuf[p] == 0) {
                    this.pixels[p] = 0;
                }
                if (this.waterBuf[p] > this.zBuf[p]) {
                    int a = this.pixels[p] >> 24 & 0xFF;
                    this.pixels[p] = ((this.pixels[p] & 0xFEFEFE) >> 1) + this.waterBr[p];
                    if (a < 128) {
                        this.pixels[p] = Integer.MIN_VALUE + this.waterBr[p] * 2;
                    } else {
                        int n = p;
                        this.pixels[n] = this.pixels[n] | 0xFF000000;
                    }
                }
                ++y;
            }
            ++x;
        }
    }
}

