/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.title;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gamemode.secret.SecretMode;
import net.minecraft.client.gui.Button;
import net.minecraft.client.gui.OptionsScreen;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenSizeCalculator;
import net.minecraft.client.gui.SelectWorldScreen;
import net.minecraft.client.locale.Language;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.skins.TexturePackSelectScreen;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import util.Mth;

public class TitleScreen
extends Screen {
    private static final Random random = new Random();
    String[] logo = new String[]{" *   * * *   * *** *** *** *** *** ***", " ** ** * **  * *   *   * * * * *    * ", " * * * * * * * **  *   **  *** **   * ", " *   * * *  ** *   *   * * * * *    * ", " *   * * *   * *   *** * * * * *    * "};
    private LetterBlock[][] letterBlocks;
    private float vo = 0.0f;
    private String splash = "missingno";

    public TitleScreen() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(TitleScreen.class.getResourceAsStream("/title/splashes.txt")));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() <= 0) continue;
                arrayList.add(string);
            }
            this.splash = (String)arrayList.get(random.nextInt(arrayList.size()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tick() {
        this.vo += 1.0f;
        if (this.letterBlocks != null) {
            for (int i = 0; i < this.letterBlocks.length; ++i) {
                for (int j = 0; j < this.letterBlocks[i].length; ++j) {
                    this.letterBlocks[i][j].tick();
                }
            }
        }
    }

    protected void keyPressed(char c, int n) {
    }

    public void init() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(2) + 1 == 11 && calendar.get(5) == 9) {
            this.splash = "Happy birthday, ez!";
        } else if (calendar.get(2) + 1 == 6 && calendar.get(5) == 1) {
            this.splash = "Happy birthday, Notch!";
        } else if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
            this.splash = "Merry X-mas!";
        } else if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
            this.splash = "Happy new year!";
        }
        Language language = Language.getInstance();
        int n = this.height / 4 + 48;
        this.buttons.add(new Button(1, this.width / 2 - 100, n, language.getElement("menu.singleplayer")));
        this.buttons.add(new Button(2, this.width / 2 - 100, n + 24, language.getElement("menu.multiplayer")));
        this.buttons.add(new Button(3, this.width / 2 - 100, n + 48, language.getElement("menu.mods")));
        if (this.minecraft.appletMode) {
            this.buttons.add(new Button(0, this.width / 2 - 100, n + 72, language.getElement("menu.options")));
        } else {
            this.buttons.add(new Button(0, this.width / 2 - 100, n + 72 + 12, 98, 20, language.getElement("menu.options")));
            this.buttons.add(new Button(4, this.width / 2 + 2, n + 72 + 12, 98, 20, language.getElement("menu.quit")));
        }
        if (this.minecraft.user == null) {
            ((Button)this.buttons.get((int)1)).active = false;
        }
        this.minecraft.gameMode = new SecretMode(this.minecraft);
        Level.deleteLevel(Minecraft.getWorkingDirectory(), "secretLevel");
        Level level = new Level(new File(Minecraft.getWorkingDirectory(), "saves"), "secretLevel", 4656295L);
        this.minecraft.setLevel(level);
        this.minecraft.setScreen(null);
    }

    protected void buttonClicked(Button button) {
        if (button.id == 0) {
            this.minecraft.setScreen(new OptionsScreen(this, this.minecraft.options));
        }
        if (button.id == 1) {
            this.minecraft.setScreen(new SelectWorldScreen(this));
        }
        if (button.id == 2) {
            // empty if block
        }
        if (button.id == 3) {
            this.minecraft.setScreen(new TexturePackSelectScreen(this));
        }
        if (button.id == 4) {
            this.minecraft.stop();
        }
    }

    public void render(int n, int n2, float f) {
        this.renderBackground();
        Tesselator tesselator = Tesselator.instance;
        this.renderMinecraftLogo(f);
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/gui/logo.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tesselator.color(0xFFFFFF);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2 + 90), (float)70.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = 1.8f - Mth.abs(Mth.sin((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f);
        f2 = f2 * 100.0f / (float)(this.font.width(this.splash) + 32);
        GL11.glScalef((float)f2, (float)f2, (float)f2);
        this.drawCenteredString(this.font, this.splash, 0, -8, 0xFFFF00);
        GL11.glPopMatrix();
        this.drawString(this.font, "Minecraft Beta 1.2_02", 2, 2, 0x505050);
        String string = "Copyright Mojang AB. Do not distribute.";
        this.drawString(this.font, string, this.width - this.font.width(string) - 2, this.height - 10, 0xFFFFFF);
        super.render(n, n2, f);
    }

    private void renderMinecraftLogo(float f) {
        int n;
        if (this.letterBlocks == null) {
            this.letterBlocks = new LetterBlock[this.logo[0].length()][this.logo.length];
            for (int i = 0; i < this.letterBlocks.length; ++i) {
                for (n = 0; n < this.letterBlocks[i].length; ++n) {
                    this.letterBlocks[i][n] = new LetterBlock(i, n);
                }
            }
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        ScreenSizeCalculator screenSizeCalculator = new ScreenSizeCalculator(this.minecraft.width, this.minecraft.height);
        n = 120 * screenSizeCalculator.scale;
        GLU.gluPerspective((float)70.0f, (float)((float)this.minecraft.width / (float)n), (float)0.05f, (float)100.0f);
        GL11.glViewport((int)0, (int)(this.minecraft.height - n), (int)this.minecraft.width, (int)n);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glDepthMask((boolean)true);
        TileRenderer tileRenderer = new TileRenderer();
        for (int i = 0; i < 3; ++i) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.4f, (float)0.6f, (float)-13.0f);
            if (i == 0) {
                GL11.glClear((int)256);
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
                GL11.glScalef((float)0.98f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                GL11.glDisable((int)3042);
                GL11.glClear((int)256);
            }
            if (i == 2) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
            }
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.89f, (float)1.0f, (float)0.4f);
            GL11.glTranslatef((float)((float)(-this.logo[0].length()) * 0.5f), (float)((float)(-this.logo.length) * 0.5f), (float)0.0f);
            GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/terrain.png"));
            if (i == 0) {
                GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/title/black.png"));
            }
            for (int j = 0; j < this.logo.length; ++j) {
                for (int k = 0; k < this.logo[j].length(); ++k) {
                    char c = this.logo[j].charAt(k);
                    if (c == ' ') continue;
                    GL11.glPushMatrix();
                    LetterBlock letterBlock = this.letterBlocks[k][j];
                    float f2 = (float)(letterBlock.yO + (letterBlock.y - letterBlock.yO) * (double)f);
                    float f3 = 1.0f;
                    float f4 = 1.0f;
                    float f5 = 0.0f;
                    if (i == 0) {
                        f3 = f2 * 0.04f + 1.0f;
                        f4 = 1.0f / f3;
                        f2 = 0.0f;
                    }
                    GL11.glTranslatef((float)k, (float)j, (float)f2);
                    GL11.glScalef((float)f3, (float)f3, (float)f3);
                    GL11.glRotatef((float)f5, (float)0.0f, (float)1.0f, (float)0.0f);
                    tileRenderer.renderCube(Tile.rock, f4);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glViewport((int)0, (int)0, (int)this.minecraft.width, (int)this.minecraft.height);
        GL11.glEnable((int)2884);
    }

    private class LetterBlock {
        public double y;
        public double yO;
        public double ya;

        public LetterBlock(int n, int n2) {
            this.y = this.yO = (double)(10 + n2) + random.nextDouble() * 32.0 + (double)n;
        }

        public void tick() {
            this.yO = this.y;
            if (this.y > 0.0) {
                this.ya -= 0.6;
            }
            this.y += this.ya;
            this.ya *= 0.9;
            if (this.y < 0.0) {
                this.y = 0.0;
                this.ya = 0.0;
            }
        }
    }
}

