/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.sound.Sound;

public class SoundRepository {
    private Random random = new Random();
    private Map<String, List<Sound>> urls = new HashMap<String, List<Sound>>();
    private List<Sound> all = new ArrayList<Sound>();
    public int count = 0;
    public boolean trimDigits = true;

    public Sound add(String name, File file) {
        try {
            String orgName = name;
            name = name.substring(0, name.indexOf("."));
            if (this.trimDigits) {
                while (Character.isDigit(name.charAt(name.length() - 1))) {
                    name = name.substring(0, name.length() - 1);
                }
            }
            if (!this.urls.containsKey(name = name.replaceAll("/", "."))) {
                this.urls.put(name, new ArrayList());
            }
            Sound sound = new Sound(orgName, file.toURI().toURL());
            this.urls.get(name).add(sound);
            this.all.add(sound);
            ++this.count;
            return sound;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Sound get(String name) {
        List<Sound> values = this.urls.get(name);
        if (values == null) {
            return null;
        }
        return values.get(this.random.nextInt(values.size()));
    }

    public Sound any() {
        if (this.all.size() == 0) {
            return null;
        }
        return this.all.get(this.random.nextInt(this.all.size()));
    }
}

