/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.io.File;
import java.util.Random;
import net.minecraft.client.Options;
import net.minecraft.client.sound.CodecMus;
import net.minecraft.client.sound.Sound;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.world.entity.Mob;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;
import util.Mth;

public class SoundEngine {
    private static final int SOUND_DISTANCE = 16;
    private static SoundSystem soundSystem;
    private SoundRepository sounds = new SoundRepository();
    private SoundRepository streamingSounds = new SoundRepository();
    private SoundRepository songs = new SoundRepository();
    private int idCounter = 0;
    private Options options;
    private static boolean loaded;
    private Random random = new Random();
    private int noMusicDelay = this.random.nextInt(12000);

    static {
        loaded = false;
    }

    public void init(Options options) {
        this.streamingSounds.trimDigits = false;
        this.options = options;
        if (!(loaded || options != null && options.sound == 0.0f && options.music == 0.0f)) {
            this.loadLibrary();
        }
    }

    private void loadLibrary() {
        try {
            float hadSound = this.options.sound;
            float hadMusic = this.options.music;
            this.options.sound = 0.0f;
            this.options.music = 0.0f;
            this.options.save();
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec("ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec("mus", CodecMus.class);
            SoundSystemConfig.setCodec("wav", CodecWav.class);
            soundSystem = new SoundSystem();
            this.options.sound = hadSound;
            this.options.music = hadMusic;
            this.options.save();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("error linking with the LibraryJavaSound plug-in");
        }
        loaded = true;
    }

    public void updateOptions() {
        if (!(loaded || this.options.sound == 0.0f && this.options.music == 0.0f)) {
            this.loadLibrary();
        }
        if (loaded) {
            if (this.options.music == 0.0f) {
                soundSystem.stop("BgMusic");
            } else {
                soundSystem.setVolume("BgMusic", this.options.music);
            }
        }
    }

    public void destroy() {
        if (loaded) {
            soundSystem.cleanup();
        }
    }

    public void add(String name, File file) {
        this.sounds.add(name, file);
    }

    public void addStreaming(String name, File file) {
        this.streamingSounds.add(name, file);
    }

    public void addMusic(String name, File file) {
        this.songs.add(name, file);
    }

    public void playMusicTick() {
        if (!loaded || this.options.music == 0.0f) {
            return;
        }
        if (!soundSystem.playing("BgMusic") && !soundSystem.playing("streaming")) {
            if (this.noMusicDelay > 0) {
                --this.noMusicDelay;
                return;
            }
            Sound song = this.songs.any();
            if (song != null) {
                this.noMusicDelay = this.random.nextInt(12000) + 12000;
                soundSystem.backgroundMusic("BgMusic", song.url, song.name, false);
                soundSystem.setVolume("BgMusic", this.options.music);
                soundSystem.play("BgMusic");
            }
        }
    }

    public void update(Mob player, float a) {
        if (!loaded || this.options.sound == 0.0f) {
            return;
        }
        if (player == null) {
            return;
        }
        float yRot = player.yRotO + (player.yRot - player.yRotO) * a;
        double x = player.xo + (player.x - player.xo) * (double)a;
        double y = player.yo + (player.y - player.yo) * (double)a;
        double z = player.zo + (player.z - player.zo) * (double)a;
        float yCos = Mth.cos(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float ySin = Mth.sin(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float xa = -ySin;
        float ya = 0.0f;
        float za = -yCos;
        float xa2 = 0.0f;
        float ya2 = 1.0f;
        float za2 = 0.0f;
        soundSystem.setListenerPosition((float)x, (float)y, (float)z);
        soundSystem.setListenerOrientation(xa, ya, za, xa2, ya2, za2);
    }

    public void playStreaming(String name, float x, float y, float z, float volume, float pitch) {
        if (!loaded || this.options.sound == 0.0f) {
            return;
        }
        String id = "streaming";
        if (soundSystem.playing("streaming")) {
            soundSystem.stop("streaming");
        }
        if (name == null) {
            return;
        }
        Sound sound = this.streamingSounds.get(name);
        if (sound != null && volume > 0.0f) {
            if (soundSystem.playing("BgMusic")) {
                soundSystem.stop("BgMusic");
            }
            float dist = 16.0f;
            soundSystem.newStreamingSource(true, id, sound.url, sound.name, false, x, y, z, 2, dist * 4.0f);
            soundSystem.setVolume(id, 0.5f * this.options.sound);
            soundSystem.play(id);
        }
    }

    public void play(String name, float x, float y, float z, float volume, float pitch) {
        if (!loaded || this.options.sound == 0.0f) {
            return;
        }
        Sound sound = this.sounds.get(name);
        if (sound != null && volume > 0.0f) {
            this.idCounter = (this.idCounter + 1) % 256;
            String id = "sound_" + this.idCounter;
            float dist = 16.0f;
            if (volume > 1.0f) {
                dist *= volume;
            }
            soundSystem.newSource(volume > 1.0f, id, sound.url, sound.name, false, x, y, z, 2, dist);
            soundSystem.setPitch(id, pitch);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            soundSystem.setVolume(id, volume * this.options.sound);
            soundSystem.play(id);
        }
    }

    public void playUI(String name, float volume, float pitch) {
        if (!loaded || this.options.sound == 0.0f) {
            return;
        }
        Sound sound = this.sounds.get(name);
        if (sound != null) {
            this.idCounter = (this.idCounter + 1) % 256;
            String id = "sound_" + this.idCounter;
            soundSystem.newSource(false, id, sound.url, sound.name, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            soundSystem.setPitch(id, pitch);
            soundSystem.setVolume(id, (volume *= 0.25f) * this.options.sound);
            soundSystem.play(id);
        }
    }
}

