/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import paulscode.sound.codecs.CodecJOrbis;

public class CodecMus
extends CodecJOrbis {
    @Override
    protected InputStream openInputStream() throws IOException {
        return new DecoderInputStream(this.url, this.urlConnection.getInputStream());
    }

    private class DecoderInputStream
    extends InputStream {
        private int seed;
        private InputStream in;
        byte[] buff = new byte[1];

        public DecoderInputStream(URL url, InputStream in) {
            this.in = in;
            String name = url.getPath();
            name = name.substring(name.lastIndexOf("/") + 1);
            this.seed = name.hashCode();
        }

        @Override
        public int read() throws IOException {
            int result = this.read(this.buff, 0, 1);
            if (result < 0) {
                return result;
            }
            return this.buff[0];
        }

        @Override
        public int read(byte[] buff, int off, int len) throws IOException {
            len = this.in.read(buff, off, len);
            int i = 0;
            while (i < len) {
                int n = off + i;
                byte by = (byte)(buff[n] ^ this.seed >> 8);
                buff[n] = by;
                byte val = by;
                this.seed = this.seed * 498729871 + 85731 * val;
                ++i;
            }
            return len;
        }
    }
}

