/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.skins;

import java.io.File;
import java.util.List;
import net.minecraft.client.gui.Button;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.SmallButton;
import net.minecraft.client.locale.Language;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.skins.TexturePack;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class TexturePackSelectScreen
extends Screen {
    protected Screen lastScreen;
    private int yo = 0;
    private int y0 = 32;
    private int y1 = this.height - 55 + 4;
    private int x0 = 0;
    private int x1 = this.width;
    private int yDrag = -2;
    private int updateIn = -1;
    private String instructions = "";

    public TexturePackSelectScreen(Screen lastScreen) {
        this.lastScreen = lastScreen;
    }

    @Override
    public void init() {
        Language language = Language.getInstance();
        this.buttons.add(new SmallButton(5, this.width / 2 - 154, this.height - 48, language.getElement("texturePack.openFolder")));
        this.buttons.add(new SmallButton(6, this.width / 2 + 4, this.height - 48, language.getElement("gui.done")));
        this.minecraft.skins.updateList();
        this.instructions = new File(this.minecraft.workingDirectory, "texturepacks").getAbsolutePath();
        this.y0 = 32;
        this.y1 = this.height - 58 + 4;
        this.x0 = 0;
        this.x1 = this.width;
    }

    @Override
    protected void buttonClicked(Button button) {
        if (!button.active) {
            return;
        }
        if (button.id == 5) {
            Sys.openURL((String)("file://" + this.instructions));
        }
        if (button.id == 6) {
            this.minecraft.textures.reloadAll();
            this.minecraft.setScreen(this.lastScreen);
        }
    }

    @Override
    protected void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
    }

    @Override
    protected void mouseReleased(int x, int y, int buttonNum) {
        super.mouseReleased(x, y, buttonNum);
    }

    @Override
    public void render(int xm, int ym, float a) {
        this.renderBackground();
        if (this.updateIn <= 0) {
            this.minecraft.skins.updateList();
            this.updateIn += 20;
        }
        List<TexturePack> skins = this.minecraft.skins.getAll();
        if (Mouse.isButtonDown((int)0)) {
            if (this.yDrag == -1) {
                if (ym >= this.y0 && ym <= this.y1) {
                    int x0 = this.width / 2 - 110;
                    int x1 = this.width / 2 + 110;
                    int slot = (ym - this.y0 + this.yo - 2) / 36;
                    if (xm >= x0 && xm <= x1 && slot >= 0 && slot < skins.size() && this.minecraft.skins.selectSkin(skins.get(slot))) {
                        this.minecraft.textures.reloadAll();
                    }
                    this.yDrag = ym;
                } else {
                    this.yDrag = -2;
                }
            } else if (this.yDrag >= 0) {
                this.yo -= ym - this.yDrag;
                this.yDrag = ym;
            }
        } else {
            if (this.yDrag >= 0) {
                // empty if block
            }
            this.yDrag = -1;
        }
        int max = skins.size() * 36 - (this.y1 - this.y0 - 4);
        if (max < 0) {
            max /= 2;
        }
        if (this.yo < 0) {
            this.yo = 0;
        }
        if (this.yo > max) {
            this.yo = max;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tesselator t = Tesselator.instance;
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float s = 32.0f;
        t.begin();
        t.color(0x202020);
        t.vertexUV(this.x0, this.y1, 0.0, (float)this.x0 / s, (float)(this.y1 + this.yo) / s);
        t.vertexUV(this.x1, this.y1, 0.0, (float)this.x1 / s, (float)(this.y1 + this.yo) / s);
        t.vertexUV(this.x1, this.y0, 0.0, (float)this.x1 / s, (float)(this.y0 + this.yo) / s);
        t.vertexUV(this.x0, this.y0, 0.0, (float)this.x0 / s, (float)(this.y0 + this.yo) / s);
        t.end();
        int i = 0;
        while (i < skins.size()) {
            TexturePack skin = skins.get(i);
            int x = this.width / 2 - 92 - 16;
            int y = 36 + i * 36 - this.yo;
            int h = 32;
            int w = 32;
            if (skin == this.minecraft.skins.selected) {
                int x0 = this.width / 2 - 110;
                int x1 = this.width / 2 + 110;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                t.begin();
                t.color(0x808080);
                t.vertexUV(x0, y + h + 2, 0.0, 0.0, 1.0);
                t.vertexUV(x1, y + h + 2, 0.0, 1.0, 1.0);
                t.vertexUV(x1, y - 2, 0.0, 1.0, 0.0);
                t.vertexUV(x0, y - 2, 0.0, 0.0, 0.0);
                t.color(0);
                t.vertexUV(x0 + 1, y + h + 1, 0.0, 0.0, 1.0);
                t.vertexUV(x1 - 1, y + h + 1, 0.0, 1.0, 1.0);
                t.vertexUV(x1 - 1, y - 1, 0.0, 1.0, 0.0);
                t.vertexUV(x0 + 1, y - 1, 0.0, 0.0, 0.0);
                t.end();
                GL11.glEnable((int)3553);
            }
            skin.bindTexture(this.minecraft);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            t.begin();
            t.color(0xFFFFFF);
            t.vertexUV(x, y + h, 0.0, 0.0, 1.0);
            t.vertexUV(x + w, y + h, 0.0, 1.0, 1.0);
            t.vertexUV(x + w, y, 0.0, 1.0, 0.0);
            t.vertexUV(x, y, 0.0, 0.0, 0.0);
            t.end();
            this.drawString(this.font, skin.name, x + w + 2, y + 1, 0xFFFFFF);
            this.drawString(this.font, skin.desc1, x + w + 2, y + 12, 0x808080);
            this.drawString(this.font, skin.desc2, x + w + 2, y + 12 + 10, 0x808080);
            ++i;
        }
        int d = 4;
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        t.begin();
        t.color(0, 0);
        t.vertexUV(this.x0, this.y0 + d, 0.0, 0.0, 1.0);
        t.vertexUV(this.x1, this.y0 + d, 0.0, 1.0, 1.0);
        t.color(0, 255);
        t.vertexUV(this.x1, this.y0, 0.0, 1.0, 0.0);
        t.vertexUV(this.x0, this.y0, 0.0, 0.0, 0.0);
        t.end();
        t.begin();
        t.color(0, 255);
        t.vertexUV(this.x0, this.y1, 0.0, 0.0, 1.0);
        t.vertexUV(this.x1, this.y1, 0.0, 1.0, 1.0);
        t.color(0, 0);
        t.vertexUV(this.x1, this.y1 - d, 0.0, 1.0, 0.0);
        t.vertexUV(this.x0, this.y1 - d, 0.0, 0.0, 0.0);
        t.end();
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        Language language = Language.getInstance();
        this.drawCenteredString(this.font, language.getElement("texturePack.title"), this.width / 2, 16, 0xFFFFFF);
        this.drawCenteredString(this.font, language.getElement("texturePack.folderInfo"), this.width / 2 - 77, this.height - 26, 0x808080);
        super.render(xm, ym, a);
    }

    @Override
    public void tick() {
        super.tick();
        --this.updateIn;
    }

    public void renderHoleBackground(int y0, int y1, int a0, int a1) {
        Tesselator t = Tesselator.instance;
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float s = 32.0f;
        t.begin();
        t.color(0x404040, a1);
        t.vertexUV(0.0, y1, 0.0, 0.0, (float)y1 / s);
        t.vertexUV(this.width, y1, 0.0, (float)this.width / s, (float)y1 / s);
        t.color(0x404040, a0);
        t.vertexUV(this.width, y0, 0.0, (float)this.width / s, (float)y0 / s);
        t.vertexUV(0.0, y0, 0.0, 0.0, (float)y0 / s);
        t.end();
    }
}

