/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.skins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.skins.DefaultTexturePack;
import net.minecraft.client.skins.FileTexturePack;
import net.minecraft.client.skins.TexturePack;

public class TexturePackRepository {
    private List<TexturePack> texturePacks = new ArrayList<TexturePack>();
    private TexturePack defaultTexturePack = new DefaultTexturePack();
    public TexturePack selected;
    private Map<String, TexturePack> skinCache = new HashMap<String, TexturePack>();
    private Minecraft minecraft;
    private File workDir;
    private String chosenSkinName;

    public TexturePackRepository(Minecraft minecraft, File workingDirectory) {
        this.minecraft = minecraft;
        this.workDir = new File(workingDirectory, "texturepacks");
        if (!this.workDir.exists()) {
            this.workDir.mkdirs();
        }
        this.chosenSkinName = minecraft.options.skin;
        this.updateList();
        this.selected.select();
    }

    public boolean selectSkin(TexturePack skin) {
        if (skin == this.selected) {
            return false;
        }
        this.selected.deselect();
        this.chosenSkinName = skin.name;
        this.selected = skin;
        this.minecraft.options.skin = this.chosenSkinName;
        this.minecraft.options.save();
        this.selected.select();
        return true;
    }

    public void updateList() {
        ArrayList<TexturePack> newSkins = new ArrayList<TexturePack>();
        this.selected = null;
        newSkins.add(this.defaultTexturePack);
        if (this.workDir.exists() && this.workDir.isDirectory()) {
            File[] files;
            File[] fileArray = files = this.workDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(".zip")) {
                    String id = String.valueOf(file.getName()) + ":" + file.length() + ":" + file.lastModified();
                    try {
                        TexturePack skin;
                        if (!this.skinCache.containsKey(id)) {
                            skin = new FileTexturePack(file);
                            skin.id = id;
                            this.skinCache.put(id, skin);
                            skin.load(this.minecraft);
                        }
                        skin = this.skinCache.get(id);
                        if (skin.name.equals(this.chosenSkinName)) {
                            this.selected = skin;
                        }
                        newSkins.add(skin);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        if (this.selected == null) {
            this.selected = this.defaultTexturePack;
        }
        this.texturePacks.removeAll(newSkins);
        for (TexturePack skin : this.texturePacks) {
            skin.unload(this.minecraft);
            this.skinCache.remove(skin.id);
        }
        this.texturePacks = newSkins;
    }

    public List<TexturePack> getAll() {
        return new ArrayList<TexturePack>(this.texturePacks);
    }
}

