/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import net.minecraft.client.gui.Font;
import net.minecraft.client.model.SignModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.SignTileEntity;
import org.lwjgl.opengl.GL11;

public class SignRenderer
extends TileEntityRenderer<SignTileEntity> {
    private SignModel signModel = new SignModel();

    @Override
    public void render(SignTileEntity sign, double x, double y, double z, float a) {
        Tile tile = sign.getTile();
        GL11.glPushMatrix();
        float size = 0.6666667f;
        if (tile == Tile.sign) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * size), (float)((float)z + 0.5f));
            float rot = (float)(sign.getData() * 360) / 16.0f;
            GL11.glRotatef((float)(-rot), (float)0.0f, (float)1.0f, (float)0.0f);
            this.signModel.cube2.visible = true;
        } else {
            int face = sign.getData();
            float rot = 0.0f;
            if (face == 2) {
                rot = 180.0f;
            }
            if (face == 4) {
                rot = 90.0f;
            }
            if (face == 5) {
                rot = -90.0f;
            }
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * size), (float)((float)z + 0.5f));
            GL11.glRotatef((float)(-rot), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
            this.signModel.cube2.visible = false;
        }
        this.bindTexture("/item/sign.png");
        GL11.glPushMatrix();
        GL11.glScalef((float)size, (float)(-size), (float)(-size));
        this.signModel.render();
        GL11.glPopMatrix();
        Font font = this.getFont();
        float s = 0.016666668f * size;
        GL11.glTranslatef((float)0.0f, (float)(0.5f * size), (float)(0.07f * size));
        GL11.glScalef((float)s, (float)(-s), (float)s);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * s));
        GL11.glDepthMask((boolean)false);
        int col = 0;
        int i = 0;
        while (i < sign.messages.length) {
            String msg = sign.messages[i];
            if (i == sign.selectedLine) {
                msg = "> " + msg + " <";
                font.draw(msg, -font.width(msg) / 2, i * 10 - sign.messages.length * 5, col);
            } else {
                font.draw(msg, -font.width(msg) / 2, i * 10 - sign.messages.length * 5, col);
            }
            ++i;
        }
        GL11.glDepthMask((boolean)true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

