/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.ptexture;

import net.minecraft.client.renderer.ptexture.DynamicTexture;
import net.minecraft.world.level.tile.Tile;

public class WaterTexture
extends DynamicTexture {
    protected float[] current = new float[256];
    protected float[] next = new float[256];
    protected float[] heat = new float[256];
    protected float[] heata = new float[256];
    private int tickCount = 0;

    public WaterTexture() {
        super(Tile.water.tex);
    }

    @Override
    public void tick() {
        float pow;
        int y;
        ++this.tickCount;
        int x = 0;
        while (x < 16) {
            y = 0;
            while (y < 16) {
                pow = 0.0f;
                int xx = x - 1;
                while (xx <= x + 1) {
                    int xi = xx & 0xF;
                    int yi = y & 0xF;
                    pow += this.current[xi + yi * 16];
                    ++xx;
                }
                this.next[x + y * 16] = pow / 3.3f + this.heat[x + y * 16] * 0.8f;
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 16) {
            y = 0;
            while (y < 16) {
                int n = x + y * 16;
                this.heat[n] = this.heat[n] + this.heata[x + y * 16] * 0.05f;
                if (this.heat[x + y * 16] < 0.0f) {
                    this.heat[x + y * 16] = 0.0f;
                }
                int n2 = x + y * 16;
                this.heata[n2] = this.heata[n2] - 0.1f;
                if (Math.random() < 0.05) {
                    this.heata[x + y * 16] = 0.5f;
                }
                ++y;
            }
            ++x;
        }
        float[] tmp = this.next;
        this.next = this.current;
        this.current = tmp;
        int i = 0;
        while (i < 256) {
            pow = this.current[i];
            if (pow > 1.0f) {
                pow = 1.0f;
            }
            if (pow < 0.0f) {
                pow = 0.0f;
            }
            float pp = pow * pow;
            int r = (int)(32.0f + pp * 32.0f);
            int g = (int)(50.0f + pp * 64.0f);
            int b = 255;
            int a = (int)(146.0f + pp * 50.0f);
            if (this.anaglyph3d) {
                int rr = (r * 30 + g * 59 + b * 11) / 100;
                int gg = (r * 30 + g * 70) / 100;
                int bb = (r * 30 + b * 70) / 100;
                r = rr;
                g = gg;
                b = bb;
            }
            this.pixels[i * 4 + 0] = (byte)r;
            this.pixels[i * 4 + 1] = (byte)g;
            this.pixels[i * 4 + 2] = (byte)b;
            this.pixels[i * 4 + 3] = (byte)a;
            ++i;
        }
    }
}

