/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.ptexture;

import java.util.Random;
import net.minecraft.client.renderer.ptexture.DynamicTexture;
import net.minecraft.world.level.tile.Tile;
import util.Mth;

public class PortalTexture
extends DynamicTexture {
    private int time = 0;
    private byte[][] frames = new byte[32][1024];

    public PortalTexture() {
        super(Tile.portalTile.tex);
        Random random = new Random(100L);
        int time = 0;
        while (time < 32) {
            int x = 0;
            while (x < 16) {
                int y = 0;
                while (y < 16) {
                    float pow = 0.0f;
                    int i = 0;
                    while (i < 2) {
                        float xo = i * 8;
                        float yo = i * 8;
                        float xd = ((float)x - xo) / 16.0f * 2.0f;
                        float yd = ((float)y - yo) / 16.0f * 2.0f;
                        if (xd < -1.0f) {
                            xd += 2.0f;
                        }
                        if (xd >= 1.0f) {
                            xd -= 2.0f;
                        }
                        if (yd < -1.0f) {
                            yd += 2.0f;
                        }
                        if (yd >= 1.0f) {
                            yd -= 2.0f;
                        }
                        float dd = xd * xd + yd * yd;
                        float pp = (float)Math.atan2(yd, xd) + ((float)time / 32.0f * (float)Math.PI * 2.0f - dd * 10.0f + (float)(i * 2)) * (float)(i * 2 - 1);
                        pp = (Mth.sin(pp) + 1.0f) / 2.0f;
                        pow += (pp /= dd + 1.0f) * 0.5f;
                        ++i;
                    }
                    int b = (int)((pow += random.nextFloat() * 0.1f) * 100.0f + 155.0f);
                    int r = (int)(pow * pow * 200.0f + 55.0f);
                    int g = (int)(pow * pow * pow * pow * 255.0f);
                    int a = (int)(pow * 100.0f + 155.0f);
                    int i2 = y * 16 + x;
                    this.frames[time][i2 * 4 + 0] = (byte)r;
                    this.frames[time][i2 * 4 + 1] = (byte)g;
                    this.frames[time][i2 * 4 + 2] = (byte)b;
                    this.frames[time][i2 * 4 + 3] = (byte)a;
                    ++y;
                }
                ++x;
            }
            ++time;
        }
    }

    @Override
    public void tick() {
        ++this.time;
        byte[] source = this.frames[this.time & 0x1F];
        int i = 0;
        while (i < 256) {
            int r = source[i * 4 + 0] & 0xFF;
            int g = source[i * 4 + 1] & 0xFF;
            int b = source[i * 4 + 2] & 0xFF;
            int a = source[i * 4 + 3] & 0xFF;
            if (this.anaglyph3d) {
                int rr = (r * 30 + g * 59 + b * 11) / 100;
                int gg = (r * 30 + g * 70) / 100;
                int bb = (r * 30 + b * 70) / 100;
                r = rr;
                g = gg;
                b = bb;
            }
            this.pixels[i * 4 + 0] = (byte)r;
            this.pixels[i * 4 + 1] = (byte)g;
            this.pixels[i * 4 + 2] = (byte)b;
            this.pixels[i * 4 + 3] = (byte)a;
            ++i;
        }
    }
}

