/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.ptexture;

import net.minecraft.client.renderer.ptexture.DynamicTexture;
import net.minecraft.world.level.tile.Tile;
import util.Mth;

public class LavaTexture
extends DynamicTexture {
    protected float[] current = new float[256];
    protected float[] next = new float[256];
    protected float[] heat = new float[256];
    protected float[] heata = new float[256];

    public LavaTexture() {
        super(Tile.lava.tex);
    }

    @Override
    public void tick() {
        float pow;
        int x = 0;
        while (x < 16) {
            int y = 0;
            while (y < 16) {
                pow = 0.0f;
                int xxo = (int)(Mth.sin((float)y * (float)Math.PI * 2.0f / 16.0f) * 1.2f);
                int yyo = (int)(Mth.sin((float)x * (float)Math.PI * 2.0f / 16.0f) * 1.2f);
                int xx = x - 1;
                while (xx <= x + 1) {
                    int yy = y - 1;
                    while (yy <= y + 1) {
                        int xi = xx + xxo & 0xF;
                        int yi = yy + yyo & 0xF;
                        pow += this.current[xi + yi * 16];
                        ++yy;
                    }
                    ++xx;
                }
                this.next[x + y * 16] = pow / 10.0f + (this.heat[(x + 0 & 0xF) + (y + 0 & 0xF) * 16] + this.heat[(x + 1 & 0xF) + (y + 0 & 0xF) * 16] + this.heat[(x + 1 & 0xF) + (y + 1 & 0xF) * 16] + this.heat[(x + 0 & 0xF) + (y + 1 & 0xF) * 16]) / 4.0f * 0.8f;
                int n = x + y * 16;
                this.heat[n] = this.heat[n] + this.heata[x + y * 16] * 0.01f;
                if (this.heat[x + y * 16] < 0.0f) {
                    this.heat[x + y * 16] = 0.0f;
                }
                int n2 = x + y * 16;
                this.heata[n2] = this.heata[n2] - 0.06f;
                if (Math.random() < 0.005) {
                    this.heata[x + y * 16] = 1.5f;
                }
                ++y;
            }
            ++x;
        }
        float[] tmp = this.next;
        this.next = this.current;
        this.current = tmp;
        int i = 0;
        while (i < 256) {
            pow = this.current[i] * 2.0f;
            if (pow > 1.0f) {
                pow = 1.0f;
            }
            if (pow < 0.0f) {
                pow = 0.0f;
            }
            float pp = pow;
            int r = (int)(pp * 100.0f + 155.0f);
            int g = (int)(pp * pp * 255.0f);
            int b = (int)(pp * pp * pp * pp * 128.0f);
            if (this.anaglyph3d) {
                int rr = (r * 30 + g * 59 + b * 11) / 100;
                int gg = (r * 30 + g * 70) / 100;
                int bb = (r * 30 + b * 70) / 100;
                r = rr;
                g = gg;
                b = bb;
            }
            this.pixels[i * 4 + 0] = (byte)r;
            this.pixels[i * 4 + 1] = (byte)g;
            this.pixels[i * 4 + 2] = (byte)b;
            this.pixels[i * 4 + 3] = -1;
            ++i;
        }
    }
}

