/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.ptexture;

import net.minecraft.client.renderer.ptexture.DynamicTexture;
import net.minecraft.world.level.tile.Tile;

public class FireTexture
extends DynamicTexture {
    protected float[] current = new float[320];
    protected float[] next = new float[320];

    public FireTexture(int id) {
        super(Tile.fire.tex + id * 16);
    }

    @Override
    public void tick() {
        int x = 0;
        while (x < 16) {
            int y = 0;
            while (y < 20) {
                int count = 18;
                float pow = this.current[x + (y + 1) % 20 * 16] * (float)count;
                int xx = x - 1;
                while (xx <= x + 1) {
                    int yy = y;
                    while (yy <= y + 1) {
                        int xi = xx;
                        int yi = yy;
                        if (xi >= 0 && yi >= 0 && xi < 16 && yi < 20) {
                            pow += this.current[xi + yi * 16];
                        }
                        ++count;
                        ++yy;
                    }
                    ++xx;
                }
                this.next[x + y * 16] = pow / ((float)count * 1.06f);
                if (y >= 19) {
                    this.next[x + y * 16] = (float)(Math.random() * Math.random() * Math.random() * 4.0 + Math.random() * (double)0.1f + (double)0.2f);
                }
                ++y;
            }
            ++x;
        }
        float[] tmp = this.next;
        this.next = this.current;
        this.current = tmp;
        int i = 0;
        while (i < 256) {
            float pow = this.current[i] * 1.8f;
            if (pow > 1.0f) {
                pow = 1.0f;
            }
            if (pow < 0.0f) {
                pow = 0.0f;
            }
            float pp = pow;
            int r = (int)(pp * 155.0f + 100.0f);
            int g = (int)(pp * pp * 255.0f);
            int b = (int)(pp * pp * pp * pp * pp * pp * pp * pp * pp * pp * 255.0f);
            int a = 255;
            if (pp < 0.5f) {
                a = 0;
            }
            pp = (pp - 0.5f) * 2.0f;
            if (this.anaglyph3d) {
                int rr = (r * 30 + g * 59 + b * 11) / 100;
                int gg = (r * 30 + g * 70) / 100;
                int bb = (r * 30 + b * 70) / 100;
                r = rr;
                g = gg;
                b = bb;
            }
            this.pixels[i * 4 + 0] = (byte)r;
            this.pixels[i * 4 + 1] = (byte)g;
            this.pixels[i * 4 + 2] = (byte)b;
            this.pixels[i * 4 + 3] = (byte)a;
            ++i;
        }
    }
}

