/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.ptexture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ptexture.DynamicTexture;
import net.minecraft.world.item.Item;

public class CompassTexture
extends DynamicTexture {
    private Minecraft mc;
    private int[] raw = new int[256];
    private double rot;
    private double rota;

    public CompassTexture(Minecraft mc) {
        super(Item.compass.getIcon(null));
        this.mc = mc;
        this.textureId = 1;
        try {
            BufferedImage bi = ImageIO.read(Minecraft.class.getResource("/gui/items.png"));
            int xo = this.tex % 16 * 16;
            int yo = this.tex / 16 * 16;
            bi.getRGB(xo, yo, 16, 16, this.raw, 0, 16);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tick() {
        int bb;
        int gg;
        int rr;
        int a;
        int b;
        int g;
        int r;
        int i;
        int y;
        int x;
        int i2 = 0;
        while (i2 < 256) {
            int a2 = this.raw[i2] >> 24 & 0xFF;
            int r2 = this.raw[i2] >> 16 & 0xFF;
            int g2 = this.raw[i2] >> 8 & 0xFF;
            int b2 = this.raw[i2] >> 0 & 0xFF;
            if (this.anaglyph3d) {
                int rr2 = (r2 * 30 + g2 * 59 + b2 * 11) / 100;
                int gg2 = (r2 * 30 + g2 * 70) / 100;
                int bb2 = (r2 * 30 + b2 * 70) / 100;
                r2 = rr2;
                g2 = gg2;
                b2 = bb2;
            }
            this.pixels[i2 * 4 + 0] = (byte)r2;
            this.pixels[i2 * 4 + 1] = (byte)g2;
            this.pixels[i2 * 4 + 2] = (byte)b2;
            this.pixels[i2 * 4 + 3] = (byte)a2;
            ++i2;
        }
        double rott = 0.0;
        if (this.mc.level != null && this.mc.player != null) {
            double xa = (double)this.mc.level.xSpawn - this.mc.player.x;
            double za = (double)this.mc.level.zSpawn - this.mc.player.z;
            rott = (double)(this.mc.player.yRot - 90.0f) * Math.PI / 180.0 - Math.atan2(za, xa);
            if (this.mc.level.dimension.foggy) {
                rott = Math.random() * 3.1415927410125732 * 2.0;
            }
        }
        double rotd = rott - this.rot;
        while (rotd < -Math.PI) {
            rotd += Math.PI * 2;
        }
        while (rotd >= Math.PI) {
            rotd -= Math.PI * 2;
        }
        if (rotd < -1.0) {
            rotd = -1.0;
        }
        if (rotd > 1.0) {
            rotd = 1.0;
        }
        this.rota += rotd * 0.1;
        this.rota *= 0.8;
        this.rot += this.rota;
        double sin = Math.sin(this.rot);
        double cos = Math.cos(this.rot);
        int d = -4;
        while (d <= 4) {
            x = (int)(8.5 + cos * (double)d * 0.3);
            y = (int)(7.5 - sin * (double)d * 0.3 * 0.5);
            i = y * 16 + x;
            r = 100;
            g = 100;
            b = 100;
            a = 255;
            if (this.anaglyph3d) {
                rr = (r * 30 + g * 59 + b * 11) / 100;
                gg = (r * 30 + g * 70) / 100;
                bb = (r * 30 + b * 70) / 100;
                r = rr;
                g = gg;
                b = bb;
            }
            this.pixels[i * 4 + 0] = (byte)r;
            this.pixels[i * 4 + 1] = (byte)g;
            this.pixels[i * 4 + 2] = (byte)b;
            this.pixels[i * 4 + 3] = (byte)a;
            ++d;
        }
        d = -8;
        while (d <= 16) {
            x = (int)(8.5 + sin * (double)d * 0.3);
            y = (int)(7.5 + cos * (double)d * 0.3 * 0.5);
            i = y * 16 + x;
            r = d >= 0 ? 255 : 100;
            g = d >= 0 ? 20 : 100;
            b = d >= 0 ? 20 : 100;
            a = 255;
            if (this.anaglyph3d) {
                rr = (r * 30 + g * 59 + b * 11) / 100;
                gg = (r * 30 + g * 70) / 100;
                bb = (r * 30 + b * 70) / 100;
                r = rr;
                g = gg;
                b = bb;
            }
            this.pixels[i * 4 + 0] = (byte)r;
            this.pixels[i * 4 + 1] = (byte)g;
            this.pixels[i * 4 + 2] = (byte)b;
            this.pixels[i * 4 + 3] = (byte)a;
            ++d;
        }
    }
}

