/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.tile.Tile;
import org.lwjgl.opengl.GL11;

public class TntRenderer
extends EntityRenderer<PrimedTnt> {
    private TileRenderer tileRenderer = new TileRenderer();

    public TntRenderer() {
        this.shadowRadius = 0.5f;
    }

    @Override
    public void render(PrimedTnt tnt, double x, double y, double z, float rot, float a) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        if ((float)tnt.life - a + 1.0f < 10.0f) {
            float g = 1.0f - ((float)tnt.life - a + 1.0f) / 10.0f;
            if (g < 0.0f) {
                g = 0.0f;
            }
            if (g > 1.0f) {
                g = 1.0f;
            }
            g *= g;
            g *= g;
            float s = 1.0f + g * 0.3f;
            GL11.glScalef((float)s, (float)s, (float)s);
        }
        float br = (1.0f - ((float)tnt.life - a + 1.0f) / 100.0f) * 0.8f;
        this.bindTexture("/terrain.png");
        this.tileRenderer.renderTile(Tile.tnt, 0);
        if (tnt.life / 5 % 2 == 0) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)772);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)br);
            this.tileRenderer.renderTile(Tile.tnt, 0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
        }
        GL11.glPopMatrix();
    }
}

