/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.world.entity.monster.Slime;
import org.lwjgl.opengl.GL11;

public class SlimeRenderer
extends MobRenderer<Slime> {
    private Model armor;

    public SlimeRenderer(Model model, Model armor, float shadow) {
        super(model, shadow);
        this.armor = armor;
    }

    @Override
    protected boolean prepareArmor(Slime slime, int layer, float a) {
        if (layer == 0) {
            this.setArmor(this.armor);
            GL11.glEnable((int)2977);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            return true;
        }
        if (layer == 1) {
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return false;
    }

    @Override
    protected void scale(Slime slime, float a) {
        float ss = (slime.oSquish + (slime.squish - slime.oSquish) * a) / ((float)slime.size * 0.5f + 1.0f);
        float w = 1.0f / (ss + 1.0f);
        float s = slime.size;
        GL11.glScalef((float)(w * s), (float)(1.0f / w * s), (float)(w * s));
    }
}

