/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.gui.Font;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.tile.Tile;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class PlayerRenderer
extends MobRenderer<Player> {
    private HumanoidModel humanoidModel;
    private HumanoidModel armorParts1;
    private HumanoidModel armorParts2;
    private static final String[] MATERIAL_NAMES = new String[]{"cloth", "chain", "iron", "diamond", "gold"};

    public PlayerRenderer() {
        super(new HumanoidModel(0.0f), 0.5f);
        this.humanoidModel = (HumanoidModel)this.model;
        this.armorParts1 = new HumanoidModel(1.0f);
        this.armorParts2 = new HumanoidModel(0.5f);
    }

    @Override
    protected boolean prepareArmor(Player player, int layer, float a) {
        Item item;
        ItemInstance itemInstance = player.inventory.getArmor(3 - layer);
        if (itemInstance != null && (item = itemInstance.getItem()) instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            this.bindTexture("/armor/" + MATERIAL_NAMES[armorItem.icon] + "_" + (layer == 2 ? 2 : 1) + ".png");
            HumanoidModel armor = layer == 2 ? this.armorParts2 : this.armorParts1;
            armor.head.visible = layer == 0;
            armor.hair.visible = layer == 0;
            armor.body.visible = layer == 1 || layer == 2;
            armor.arm0.visible = layer == 1;
            armor.arm1.visible = layer == 1;
            armor.leg0.visible = layer == 2 || layer == 3;
            armor.leg1.visible = layer == 2 || layer == 3;
            this.setArmor(armor);
            return true;
        }
        return false;
    }

    @Override
    public void render(Player mob, double x, double y, double z, float rot, float a) {
        ItemInstance item = mob.inventory.getSelected();
        this.humanoidModel.holdingRightHand = item != null;
        this.armorParts2.holdingRightHand = this.humanoidModel.holdingRightHand;
        this.armorParts1.holdingRightHand = this.humanoidModel.holdingRightHand;
        this.armorParts2.sneaking = this.humanoidModel.sneaking = mob.isSneaking();
        this.armorParts1.sneaking = this.humanoidModel.sneaking;
        double yp = y - (double)mob.heightOffset;
        if (mob.isSneaking()) {
            yp -= 0.125;
        }
        super.render(mob, x, yp, z, rot, a);
        this.humanoidModel.sneaking = false;
        this.armorParts2.sneaking = false;
        this.armorParts1.sneaking = false;
        this.humanoidModel.holdingRightHand = false;
        this.armorParts2.holdingRightHand = false;
        this.armorParts1.holdingRightHand = false;
        float size = 1.6f;
        float s = 0.016666668f * size;
        float dist = mob.distanceTo(this.entityRenderDispatcher.player);
        float maxDist = mob.isSneaking() ? 32 : 64;
        if (dist < maxDist) {
            s = (float)((double)s * (Math.sqrt(dist) / 2.0));
            Font font = this.getFont();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 2.3f), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.entityRenderDispatcher.playerRotY), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.entityRenderDispatcher.playerRotX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-s), (float)(-s), (float)s);
            String msg = mob.name;
            GL11.glDisable((int)2896);
            if (!mob.isSneaking()) {
                GL11.glDepthMask((boolean)false);
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                Tesselator t = Tesselator.instance;
                int offs = 0;
                if (mob.name.equals("deadmau5")) {
                    offs = -10;
                }
                GL11.glDisable((int)3553);
                t.begin();
                int w = font.width(msg) / 2;
                t.color(0.0f, 0.0f, 0.0f, 0.25f);
                t.vertex(-w - 1, -1 + offs, 0.0);
                t.vertex(-w - 1, 8 + offs, 0.0);
                t.vertex(w + 1, 8 + offs, 0.0);
                t.vertex(w + 1, -1 + offs, 0.0);
                t.end();
                GL11.glEnable((int)3553);
                font.draw(msg, -font.width(msg) / 2, offs, 0x20FFFFFF);
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
                font.draw(msg, -font.width(msg) / 2, offs, -1);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            } else {
                GL11.glTranslatef((float)0.0f, (float)(0.25f / s), (float)0.0f);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                Tesselator t = Tesselator.instance;
                GL11.glDisable((int)3553);
                t.begin();
                int w = font.width(msg) / 2;
                t.color(0.0f, 0.0f, 0.0f, 0.25f);
                t.vertex(-w - 1, -1.0, 0.0);
                t.vertex(-w - 1, 8.0, 0.0);
                t.vertex(w + 1, 8.0, 0.0);
                t.vertex(w + 1, -1.0, 0.0);
                t.end();
                GL11.glEnable((int)3553);
                GL11.glDepthMask((boolean)true);
                font.draw(msg, -font.width(msg) / 2, 0, 0x20FFFFFF);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    protected void additionalRendering(Player mob, float a) {
        ItemInstance item;
        ItemInstance headGear = mob.inventory.getArmor(3);
        if (headGear != null && headGear.getItem().id < 256) {
            GL11.glPushMatrix();
            this.humanoidModel.head.translateTo(0.0625f);
            if (TileRenderer.canRender(Tile.tiles[headGear.id].getRenderShape())) {
                float s = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)s, (float)(-s), (float)s);
            }
            this.entityRenderDispatcher.itemInHandRenderer.renderItem(headGear);
            GL11.glPopMatrix();
        }
        if (mob.name.equals("deadmau5") && this.bindTexture(mob.customTextureUrl, null)) {
            int i = 0;
            while (i < 2) {
                float yr = mob.yRotO + (mob.yRot - mob.yRotO) * a - (mob.yBodyRotO + (mob.yBodyRot - mob.yBodyRotO) * a);
                float xr = mob.xRotO + (mob.xRot - mob.xRotO) * a;
                GL11.glPushMatrix();
                GL11.glRotatef((float)yr, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)xr, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.375f * (float)(i * 2 - 1)), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.0f);
                GL11.glRotatef((float)(-xr), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(-yr), (float)0.0f, (float)1.0f, (float)0.0f);
                float s = 1.3333334f;
                GL11.glScalef((float)s, (float)s, (float)s);
                this.humanoidModel.renderEars(0.0625f);
                GL11.glPopMatrix();
                ++i;
            }
        }
        if (this.bindTexture(mob.cloakTexture, null)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double xd = mob.xCloakO + (mob.xCloak - mob.xCloakO) * (double)a - (mob.xo + (mob.x - mob.xo) * (double)a);
            double yd = mob.yCloakO + (mob.yCloak - mob.yCloakO) * (double)a - (mob.yo + (mob.y - mob.yo) * (double)a);
            double zd = mob.zCloakO + (mob.zCloak - mob.zCloakO) * (double)a - (mob.zo + (mob.z - mob.zo) * (double)a);
            float yr = mob.yBodyRotO + (mob.yBodyRot - mob.yBodyRotO) * a;
            double xa = Mth.sin(yr * (float)Math.PI / 180.0f);
            double za = -Mth.cos(yr * (float)Math.PI / 180.0f);
            float flap = (float)yd * 10.0f;
            if (flap < -6.0f) {
                flap = -6.0f;
            }
            if (flap > 32.0f) {
                flap = 32.0f;
            }
            float lean = (float)(xd * xa + zd * za) * 100.0f;
            float lean2 = (float)(xd * za - zd * xa) * 100.0f;
            if (lean < 0.0f) {
                lean = 0.0f;
            }
            float pow = mob.oBob + (mob.bob - mob.oBob) * a;
            GL11.glRotatef((float)(6.0f + lean / 2.0f + (flap += Mth.sin((mob.walkDistO + (mob.walkDist - mob.walkDistO) * a) * 6.0f) * 32.0f * pow)), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(lean2 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-lean2 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.humanoidModel.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((item = mob.inventory.getSelected()) != null) {
            float s;
            GL11.glPushMatrix();
            this.humanoidModel.arm0.translateTo(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (mob.fishing != null) {
                item = new ItemInstance(Item.stick);
            }
            if (item.id < 256 && TileRenderer.canRender(Tile.tiles[item.id].getRenderShape())) {
                s = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(s *= 0.75f), (float)(-s), (float)s);
            } else if (Item.items[item.id].isHandEquipped()) {
                s = 0.625f;
                if (Item.items[item.id].isMirroredArt()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)s, (float)(-s), (float)s);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                s = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)s, (float)s, (float)s);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.entityRenderDispatcher.itemInHandRenderer.renderItem(item);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void scale(Player player, float a) {
        float s = 0.9375f;
        GL11.glScalef((float)s, (float)s, (float)s);
    }

    public void renderHand() {
        this.humanoidModel.attackTime = 0.0f;
        this.humanoidModel.setupAnim(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.humanoidModel.arm0.render(0.0625f);
    }
}

