/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import java.util.Random;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Painting;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class PaintingRenderer
extends EntityRenderer<Painting> {
    private Random random = new Random();

    @Override
    public void render(Painting painting, double x, double y, double z, float rot, float a) {
        this.random.setSeed(187L);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        this.bindTexture("/art/kz.png");
        Painting.Motive motive = painting.motive;
        float s = 0.0625f;
        GL11.glScalef((float)s, (float)s, (float)s);
        this.renderPainting(painting, motive.w, motive.h, motive.uo, motive.vo);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void renderPainting(Painting painting, int w, int h, int uo, int vo) {
        float xx0 = (float)(-w) / 2.0f;
        float yy0 = (float)(-h) / 2.0f;
        float z0 = -0.5f;
        float z1 = 0.5f;
        int xs = 0;
        while (xs < w / 16) {
            int ys = 0;
            while (ys < h / 16) {
                float x0 = xx0 + (float)((xs + 1) * 16);
                float x1 = xx0 + (float)(xs * 16);
                float y0 = yy0 + (float)((ys + 1) * 16);
                float y1 = yy0 + (float)(ys * 16);
                this.setBrightness(painting, (x0 + x1) / 2.0f, (y0 + y1) / 2.0f);
                float fu0 = (float)(uo + w - xs * 16) / 256.0f;
                float fu1 = (float)(uo + w - (xs + 1) * 16) / 256.0f;
                float fv0 = (float)(vo + h - ys * 16) / 256.0f;
                float fv1 = (float)(vo + h - (ys + 1) * 16) / 256.0f;
                float bu0 = 0.75f;
                float bu1 = 0.8125f;
                float bv0 = 0.0f;
                float bv1 = 0.0625f;
                float uu0 = 0.75f;
                float uu1 = 0.8125f;
                float uv0 = 0.001953125f;
                float uv1 = 0.001953125f;
                float su0 = 0.7519531f;
                float su1 = 0.7519531f;
                float sv0 = 0.0f;
                float sv1 = 0.0625f;
                Tesselator t = Tesselator.instance;
                t.begin();
                t.normal(0.0f, 0.0f, -1.0f);
                t.vertexUV(x0, y1, z0, fu1, fv0);
                t.vertexUV(x1, y1, z0, fu0, fv0);
                t.vertexUV(x1, y0, z0, fu0, fv1);
                t.vertexUV(x0, y0, z0, fu1, fv1);
                t.normal(0.0f, 0.0f, 1.0f);
                t.vertexUV(x0, y0, z1, bu0, bv0);
                t.vertexUV(x1, y0, z1, bu1, bv0);
                t.vertexUV(x1, y1, z1, bu1, bv1);
                t.vertexUV(x0, y1, z1, bu0, bv1);
                t.normal(0.0f, -1.0f, 0.0f);
                t.vertexUV(x0, y0, z0, uu0, uv0);
                t.vertexUV(x1, y0, z0, uu1, uv0);
                t.vertexUV(x1, y0, z1, uu1, uv1);
                t.vertexUV(x0, y0, z1, uu0, uv1);
                t.normal(0.0f, 1.0f, 0.0f);
                t.vertexUV(x0, y1, z1, uu0, uv0);
                t.vertexUV(x1, y1, z1, uu1, uv0);
                t.vertexUV(x1, y1, z0, uu1, uv1);
                t.vertexUV(x0, y1, z0, uu0, uv1);
                t.normal(-1.0f, 0.0f, 0.0f);
                t.vertexUV(x0, y0, z1, su1, sv0);
                t.vertexUV(x0, y1, z1, su1, sv1);
                t.vertexUV(x0, y1, z0, su0, sv1);
                t.vertexUV(x0, y0, z0, su0, sv0);
                t.normal(1.0f, 0.0f, 0.0f);
                t.vertexUV(x1, y0, z0, su1, sv0);
                t.vertexUV(x1, y1, z0, su1, sv1);
                t.vertexUV(x1, y1, z1, su0, sv1);
                t.vertexUV(x1, y0, z1, su0, sv0);
                t.end();
                ++ys;
            }
            ++xs;
        }
    }

    private void setBrightness(Painting painting, float ss, float ya) {
        int x = Mth.floor(painting.x);
        int y = Mth.floor(painting.y + (double)(ya / 16.0f));
        int z = Mth.floor(painting.z);
        if (painting.dir == 0) {
            x = Mth.floor(painting.x + (double)(ss / 16.0f));
        }
        if (painting.dir == 1) {
            z = Mth.floor(painting.z - (double)(ss / 16.0f));
        }
        if (painting.dir == 2) {
            x = Mth.floor(painting.x - (double)(ss / 16.0f));
        }
        if (painting.dir == 3) {
            z = Mth.floor(painting.z + (double)(ss / 16.0f));
        }
        float br = this.entityRenderDispatcher.level.getBrightness(x, y, z);
        GL11.glColor3f((float)br, (float)br, (float)br);
    }
}

