/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class MobRenderer<T extends Mob>
extends EntityRenderer<T> {
    private static final int MAX_ARMOR_LAYERS = 4;
    protected Model model;
    protected Model armor;

    public MobRenderer(Model model, float shadow) {
        this.model = model;
        this.shadowRadius = shadow;
    }

    public void setArmor(Model armor) {
        this.armor = armor;
    }

    @Override
    public void render(T mob, double x, double y, double z, float rot, float a) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.model.attackTime = this.getAttackAnim(mob, a);
        this.model.riding = ((Entity)mob).isRiding();
        if (this.armor != null) {
            this.armor.riding = this.model.riding;
        }
        try {
            float bodyRot = ((Mob)mob).yBodyRotO + (((Mob)mob).yBodyRot - ((Mob)mob).yBodyRotO) * a;
            float headRot = ((Mob)mob).yRotO + (((Mob)mob).yRot - ((Mob)mob).yRotO) * a;
            float headRotx = ((Mob)mob).xRotO + (((Mob)mob).xRot - ((Mob)mob).xRotO) * a;
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            float bob = this.getBob(mob, a);
            this.setupRotations(mob, bob, bodyRot, a);
            float scale = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.scale(mob, a);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * scale - 0.0078125f), (float)0.0f);
            float ws = ((Mob)mob).walkAnimSpeedO + (((Mob)mob).walkAnimSpeed - ((Mob)mob).walkAnimSpeedO) * a;
            float wp = ((Mob)mob).walkAnimPos - ((Mob)mob).walkAnimSpeed * (1.0f - a);
            if (ws > 1.0f) {
                ws = 1.0f;
            }
            this.bindTexture(((Mob)mob).customTextureUrl, ((Mob)mob).getTexture());
            GL11.glEnable((int)3008);
            this.model.render(wp, ws, bob, headRot - bodyRot, headRotx, scale);
            int i = 0;
            while (i < 4) {
                if (this.prepareArmor(mob, i, a)) {
                    this.armor.render(wp, ws, bob, headRot - bodyRot, headRotx, scale);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                }
                ++i;
            }
            this.additionalRendering(mob, a);
            float br = ((Entity)mob).getBrightness(a);
            int overlayColor = this.getOverlayColor(mob, br, a);
            if ((overlayColor >> 24 & 0xFF) > 0 || ((Mob)mob).hurtTime > 0 || ((Mob)mob).deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (((Mob)mob).hurtTime > 0 || ((Mob)mob).deathTime > 0) {
                    GL11.glColor4f((float)br, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.model.render(wp, ws, bob, headRot - bodyRot, headRotx, scale);
                    int i2 = 0;
                    while (i2 < 4) {
                        if (this.prepareArmor(mob, i2, a)) {
                            GL11.glColor4f((float)br, (float)0.0f, (float)0.0f, (float)0.4f);
                            this.armor.render(wp, ws, bob, headRot - bodyRot, headRotx, scale);
                        }
                        ++i2;
                    }
                }
                if ((overlayColor >> 24 & 0xFF) > 0) {
                    float r = (float)(overlayColor >> 16 & 0xFF) / 255.0f;
                    float g = (float)(overlayColor >> 8 & 0xFF) / 255.0f;
                    float b = (float)(overlayColor & 0xFF) / 255.0f;
                    float aa = (float)(overlayColor >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)r, (float)g, (float)b, (float)aa);
                    this.model.render(wp, ws, bob, headRot - bodyRot, headRotx, scale);
                    int i3 = 0;
                    while (i3 < 4) {
                        if (this.prepareArmor(mob, i3, a)) {
                            GL11.glColor4f((float)r, (float)g, (float)b, (float)aa);
                            this.armor.render(wp, ws, bob, headRot - bodyRot, headRotx, scale);
                        }
                        ++i3;
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    protected void setupRotations(T mob, float bob, float bodyRot, float a) {
        GL11.glRotatef((float)(180.0f - bodyRot), (float)0.0f, (float)1.0f, (float)0.0f);
        if (((Mob)mob).deathTime > 0) {
            float fall = ((float)((Mob)mob).deathTime + a - 1.0f) / 20.0f * 1.6f;
            if ((fall = Mth.sqrt(fall)) > 1.0f) {
                fall = 1.0f;
            }
            GL11.glRotatef((float)(fall * this.getFlipDegrees(mob)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float getAttackAnim(T mob, float a) {
        return ((Mob)mob).getAttackAnim(a);
    }

    protected float getBob(T mob, float a) {
        return (float)((Mob)mob).tickCount + a;
    }

    protected void additionalRendering(T mob, float a) {
    }

    protected boolean prepareArmor(T mob, int layer, float a) {
        return false;
    }

    protected float getFlipDegrees(T mob) {
        return 90.0f;
    }

    protected int getOverlayColor(T mob, float br, float a) {
        return 0;
    }

    protected void scale(T mob, float a) {
    }
}

