/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.item.Minecart;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class MinecartRenderer
extends EntityRenderer<Minecart> {
    protected Model model;

    public MinecartRenderer() {
        this.shadowRadius = 0.5f;
        this.model = new MinecartModel();
    }

    @Override
    public void render(Minecart cart, double x, double y, double z, float rot, float a) {
        GL11.glPushMatrix();
        double xx = cart.xOld + (cart.x - cart.xOld) * (double)a;
        double yy = cart.yOld + (cart.y - cart.yOld) * (double)a;
        double zz = cart.zOld + (cart.z - cart.zOld) * (double)a;
        double r = 0.3f;
        Vec3 p = cart.getPos(xx, yy, zz);
        float xRot = cart.xRotO + (cart.xRot - cart.xRotO) * a;
        if (p != null) {
            Vec3 p0 = cart.getPosOffs(xx, yy, zz, r);
            Vec3 p1 = cart.getPosOffs(xx, yy, zz, -r);
            if (p0 == null) {
                p0 = p;
            }
            if (p1 == null) {
                p1 = p;
            }
            x += p.x - xx;
            y += (p0.y + p1.y) / 2.0 - yy;
            z += p.z - zz;
            Vec3 dir = p1.add(-p0.x, -p0.y, -p0.z);
            if (dir.length() != 0.0) {
                dir = dir.normalize();
                rot = (float)(Math.atan2(dir.z, dir.x) * 180.0 / Math.PI);
                xRot = (float)(Math.atan(dir.y) * 73.0);
            }
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - rot), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-xRot), (float)0.0f, (float)0.0f, (float)1.0f);
        float hurt = (float)cart.hurtTime - a;
        float dmg = (float)cart.damage - a;
        if (dmg < 0.0f) {
            dmg = 0.0f;
        }
        if (hurt > 0.0f) {
            GL11.glRotatef((float)(Mth.sin(hurt) * hurt * dmg / 10.0f * (float)cart.hurtDir), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (cart.type != 0) {
            this.bindTexture("/terrain.png");
            float ss = 0.75f;
            GL11.glScalef((float)ss, (float)ss, (float)ss);
            GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (cart.type == 1) {
                new TileRenderer().renderTile(Tile.chest, 0);
            } else if (cart.type == 2) {
                new TileRenderer().renderTile(Tile.furnace, 0);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)0.0f);
            GL11.glScalef((float)(1.0f / ss), (float)(1.0f / ss), (float)(1.0f / ss));
        }
        this.bindTexture("/item/cart.png");
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.model.render(0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }
}

