/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.Textures;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.tile.Tile;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class ItemRenderer
extends EntityRenderer<ItemEntity> {
    private TileRenderer tileRenderer = new TileRenderer();
    private Random random = new Random();

    public ItemRenderer() {
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    @Override
    public void render(ItemEntity itemEntity, double x, double y, double z, float rot, float a) {
        this.random.setSeed(187L);
        ItemInstance item = itemEntity.item;
        GL11.glPushMatrix();
        float bob = Mth.sin(((float)itemEntity.age + a) / 10.0f + itemEntity.bobOffs) * 0.1f + 0.1f;
        float spin = (((float)itemEntity.age + a) / 20.0f + itemEntity.bobOffs) * 57.295776f;
        int count = 1;
        if (itemEntity.item.count > 1) {
            count = 2;
        }
        if (itemEntity.item.count > 5) {
            count = 3;
        }
        if (itemEntity.item.count > 20) {
            count = 4;
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y + bob), (float)((float)z));
        GL11.glEnable((int)32826);
        if (item.id < 256 && TileRenderer.canRender(Tile.tiles[item.id].getRenderShape())) {
            GL11.glRotatef((float)spin, (float)0.0f, (float)1.0f, (float)0.0f);
            this.bindTexture("/terrain.png");
            float s = 0.25f;
            if (!Tile.tiles[item.id].isCubeShaped() && item.id != Tile.stoneSlabHalf.id) {
                s = 0.5f;
            }
            GL11.glScalef((float)s, (float)s, (float)s);
            int i = 0;
            while (i < count) {
                GL11.glPushMatrix();
                if (i > 0) {
                    float xo = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / s;
                    float yo = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / s;
                    float zo = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / s;
                    GL11.glTranslatef((float)xo, (float)yo, (float)zo);
                }
                this.tileRenderer.renderTile(Tile.tiles[item.id], item.getAuxValue());
                GL11.glPopMatrix();
                ++i;
            }
        } else {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int icon = item.getIcon();
            if (item.id < 256) {
                this.bindTexture("/terrain.png");
            } else {
                this.bindTexture("/gui/items.png");
            }
            Tesselator t = Tesselator.instance;
            float u0 = (float)(icon % 16 * 16 + 0) / 256.0f;
            float u1 = (float)(icon % 16 * 16 + 16) / 256.0f;
            float v0 = (float)(icon / 16 * 16 + 0) / 256.0f;
            float v1 = (float)(icon / 16 * 16 + 16) / 256.0f;
            float r = 1.0f;
            float xo = 0.5f;
            float yo = 0.25f;
            int i = 0;
            while (i < count) {
                GL11.glPushMatrix();
                if (i > 0) {
                    float _xo = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float _yo = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float _zo = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)_xo, (float)_yo, (float)_zo);
                }
                GL11.glRotatef((float)(180.0f - this.entityRenderDispatcher.playerRotY), (float)0.0f, (float)1.0f, (float)0.0f);
                t.begin();
                t.normal(0.0f, 1.0f, 0.0f);
                t.vertexUV(0.0f - xo, 0.0f - yo, 0.0, u0, v1);
                t.vertexUV(r - xo, 0.0f - yo, 0.0, u1, v1);
                t.vertexUV(r - xo, 1.0f - yo, 0.0, u1, v0);
                t.vertexUV(0.0f - xo, 1.0f - yo, 0.0, u0, v0);
                t.end();
                GL11.glPopMatrix();
                ++i;
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void renderGuiItem(Font font, Textures textures, ItemInstance item, int x, int y) {
        if (item == null) {
            return;
        }
        if (item.id < 256 && TileRenderer.canRender(Tile.tiles[item.id].getRenderShape())) {
            int paint = item.id;
            textures.bind(textures.loadTexture("/terrain.png"));
            Tile tile = Tile.tiles[paint];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)0.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)8.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            this.tileRenderer.renderTile(tile, item.getAuxValue());
            GL11.glPopMatrix();
        } else if (item.getIcon() >= 0) {
            GL11.glDisable((int)2896);
            if (item.id < 256) {
                textures.bind(textures.loadTexture("/terrain.png"));
            } else {
                textures.bind(textures.loadTexture("/gui/items.png"));
            }
            this.blit(x, y, item.getIcon() % 16 * 16, item.getIcon() / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }

    public void renderGuiItemDecorations(Font font, Textures textures, ItemInstance item, int x, int y) {
        if (item == null) {
            return;
        }
        if (item.count > 1) {
            String amount = "" + item.count;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            font.drawShadow(amount, x + 19 - 2 - font.width(amount), y + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (item.isDamaged()) {
            int p = (int)Math.round(13.0 - (double)item.getDamageValue() * 13.0 / (double)item.getMaxDamage());
            int cc = (int)Math.round(255.0 - (double)item.getDamageValue() * 255.0 / (double)item.getMaxDamage());
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            Tesselator t = Tesselator.instance;
            int ca = 255 - cc << 16 | cc << 8;
            int cb = (255 - cc) / 4 << 16 | 0x3F00;
            this.fillRect(t, x + 2, y + 13, 13, 2, 0);
            this.fillRect(t, x + 2, y + 13, 12, 1, cb);
            this.fillRect(t, x + 2, y + 13, p, 1, ca);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void fillRect(Tesselator t, int x, int y, int w, int h, int c) {
        t.begin();
        t.color(c);
        t.vertex(x + 0, y + 0, 0.0);
        t.vertex(x + 0, y + h, 0.0);
        t.vertex(x + w, y + h, 0.0);
        t.vertex(x + w, y + 0, 0.0);
        t.end();
    }

    public void blit(int x, int y, int sx, int sy, int w, int h) {
        float blitOffset = 0.0f;
        float us = 0.00390625f;
        float vs = 0.00390625f;
        Tesselator t = Tesselator.instance;
        t.begin();
        t.vertexUV(x + 0, y + h, blitOffset, (float)(sx + 0) * us, (float)(sy + h) * vs);
        t.vertexUV(x + w, y + h, blitOffset, (float)(sx + w) * us, (float)(sy + h) * vs);
        t.vertexUV(x + w, y + 0, blitOffset, (float)(sx + w) * us, (float)(sy + 0) * vs);
        t.vertexUV(x + 0, y + 0, blitOffset, (float)(sx + 0) * us, (float)(sy + 0) * vs);
        t.end();
    }
}

