/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.tile.Tile;
import org.lwjgl.opengl.GL11;

public class HumanoidMobRenderer<T extends Mob>
extends MobRenderer<T> {
    protected HumanoidModel humanoidModel;

    public HumanoidMobRenderer(HumanoidModel humanoidModel, float shadow) {
        super(humanoidModel, shadow);
        this.humanoidModel = humanoidModel;
    }

    @Override
    protected void additionalRendering(Mob mob, float a) {
        ItemInstance item = mob.getCarriedItem();
        if (item != null) {
            GL11.glPushMatrix();
            this.humanoidModel.arm0.translateTo(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (item.id < 256 && TileRenderer.canRender(Tile.tiles[item.id].getRenderShape())) {
                float s = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(s *= 0.75f), (float)(-s), (float)s);
            } else if (Item.items[item.id].isHandEquipped()) {
                float s = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)s, (float)(-s), (float)s);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float s = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)s, (float)s, (float)s);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.entityRenderDispatcher.itemInHandRenderer.renderItem(item);
            GL11.glPopMatrix();
        }
    }
}

