/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.gui.Font;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.Textures;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import org.lwjgl.opengl.GL11;
import util.Mth;

public abstract class EntityRenderer<T extends Entity> {
    protected EntityRenderDispatcher entityRenderDispatcher;
    private Model model = new HumanoidModel();
    private TileRenderer tileRenderer = new TileRenderer();
    protected float shadowRadius = 0.0f;
    protected float shadowStrength = 1.0f;

    public abstract void render(T var1, double var2, double var4, double var6, float var8, float var9);

    protected void bindTexture(String resourceName) {
        Textures t = this.entityRenderDispatcher.textures;
        t.bind(t.loadTexture(resourceName));
    }

    protected boolean bindTexture(String urlTexture, String backupTexture) {
        Textures t = this.entityRenderDispatcher.textures;
        int id = t.loadHttpTexture(urlTexture, backupTexture);
        if (id >= 0) {
            t.bind(id);
            return true;
        }
        return false;
    }

    private void renderFlame(Entity e, double x, double y, double z, float a) {
        GL11.glDisable((int)2896);
        int tex = Tile.fire.tex;
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        float u0 = (float)xt / 256.0f;
        float u1 = ((float)xt + 15.99f) / 256.0f;
        float v0 = (float)yt / 256.0f;
        float v1 = ((float)yt + 15.99f) / 256.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float s = e.bbWidth * 1.4f;
        GL11.glScalef((float)s, (float)s, (float)s);
        this.bindTexture("/terrain.png");
        Tesselator t = Tesselator.instance;
        float r = 1.0f;
        float xo = 0.5f;
        float yo = 0.0f;
        float h = e.bbHeight / e.bbWidth;
        GL11.glRotatef((float)(-this.entityRenderDispatcher.playerRotY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.4f + (float)((int)h) * 0.02f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        t.begin();
        while (h > 0.0f) {
            t.vertexUV(r - xo, 0.0f - yo, 0.0, u1, v1);
            t.vertexUV(0.0f - xo, 0.0f - yo, 0.0, u0, v1);
            t.vertexUV(0.0f - xo, 1.4f - yo, 0.0, u0, v0);
            t.vertexUV(r - xo, 1.4f - yo, 0.0, u1, v0);
            h -= 1.0f;
            yo -= 1.0f;
            r *= 0.9f;
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.04f);
        }
        t.end();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderShadow(Entity e, double x, double y, double z, float pow, float a) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Textures textures = this.entityRenderDispatcher.textures;
        textures.bind(textures.loadTexture("%clamp%/misc/shadow.png"));
        Level level = this.getLevel();
        GL11.glDepthMask((boolean)false);
        float r = this.shadowRadius;
        double ex = e.xOld + (e.x - e.xOld) * (double)a;
        double ey = e.yOld + (e.y - e.yOld) * (double)a + (double)e.getShadowHeightOffs();
        double ez = e.zOld + (e.z - e.zOld) * (double)a;
        int x0 = Mth.floor(ex - (double)r);
        int x1 = Mth.floor(ex + (double)r);
        int y0 = Mth.floor(ey - (double)r);
        int y1 = Mth.floor(ey);
        int z0 = Mth.floor(ez - (double)r);
        int z1 = Mth.floor(ez + (double)r);
        double xo = x - ex;
        double yo = y - ey;
        double zo = z - ez;
        Tesselator tt = Tesselator.instance;
        tt.begin();
        int xt = x0;
        while (xt <= x1) {
            int yt = y0;
            while (yt <= y1) {
                int zt = z0;
                while (zt <= z1) {
                    int t = level.getTile(xt, yt - 1, zt);
                    if (t > 0 && level.getRawBrightness(xt, yt, zt) > 3) {
                        this.renderTileShadow(Tile.tiles[t], x, y + (double)e.getShadowHeightOffs(), z, xt, yt, zt, pow, r, xo, yo + (double)e.getShadowHeightOffs(), zo);
                    }
                    ++zt;
                }
                ++yt;
            }
            ++xt;
        }
        tt.end();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private Level getLevel() {
        return this.entityRenderDispatcher.level;
    }

    private void renderTileShadow(Tile tt, double x, double y, double z, int xt, int yt, int zt, float pow, float r, double xo, double yo, double zo) {
        Tesselator t = Tesselator.instance;
        if (!tt.isCubeShaped()) {
            return;
        }
        double a = ((double)pow - (y - ((double)yt + yo)) / 2.0) * 0.5 * (double)this.getLevel().getBrightness(xt, yt, zt);
        if (a < 0.0) {
            return;
        }
        if (a > 1.0) {
            a = 1.0;
        }
        t.color(1.0f, 1.0f, 1.0f, (float)a);
        double x0 = (double)xt + tt.xx0 + xo;
        double x1 = (double)xt + tt.xx1 + xo;
        double y0 = (double)yt + tt.yy0 + yo + 0.015625;
        double z0 = (double)zt + tt.zz0 + zo;
        double z1 = (double)zt + tt.zz1 + zo;
        float u0 = (float)((x - x0) / 2.0 / (double)r + 0.5);
        float u1 = (float)((x - x1) / 2.0 / (double)r + 0.5);
        float v0 = (float)((z - z0) / 2.0 / (double)r + 0.5);
        float v1 = (float)((z - z1) / 2.0 / (double)r + 0.5);
        t.vertexUV(x0, y0, z0, u0, v0);
        t.vertexUV(x0, y0, z1, u0, v1);
        t.vertexUV(x1, y0, z1, u1, v1);
        t.vertexUV(x1, y0, z0, u1, v0);
    }

    public static void render(AABB bb, double xo, double yo, double zo) {
        GL11.glDisable((int)3553);
        Tesselator t = Tesselator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        t.begin();
        t.offset(xo, yo, zo);
        t.normal(0.0f, 0.0f, -1.0f);
        t.vertex(bb.x0, bb.y1, bb.z0);
        t.vertex(bb.x1, bb.y1, bb.z0);
        t.vertex(bb.x1, bb.y0, bb.z0);
        t.vertex(bb.x0, bb.y0, bb.z0);
        t.normal(0.0f, 0.0f, 1.0f);
        t.vertex(bb.x0, bb.y0, bb.z1);
        t.vertex(bb.x1, bb.y0, bb.z1);
        t.vertex(bb.x1, bb.y1, bb.z1);
        t.vertex(bb.x0, bb.y1, bb.z1);
        t.normal(0.0f, -1.0f, 0.0f);
        t.vertex(bb.x0, bb.y0, bb.z0);
        t.vertex(bb.x1, bb.y0, bb.z0);
        t.vertex(bb.x1, bb.y0, bb.z1);
        t.vertex(bb.x0, bb.y0, bb.z1);
        t.normal(0.0f, 1.0f, 0.0f);
        t.vertex(bb.x0, bb.y1, bb.z1);
        t.vertex(bb.x1, bb.y1, bb.z1);
        t.vertex(bb.x1, bb.y1, bb.z0);
        t.vertex(bb.x0, bb.y1, bb.z0);
        t.normal(-1.0f, 0.0f, 0.0f);
        t.vertex(bb.x0, bb.y0, bb.z1);
        t.vertex(bb.x0, bb.y1, bb.z1);
        t.vertex(bb.x0, bb.y1, bb.z0);
        t.vertex(bb.x0, bb.y0, bb.z0);
        t.normal(1.0f, 0.0f, 0.0f);
        t.vertex(bb.x1, bb.y0, bb.z0);
        t.vertex(bb.x1, bb.y1, bb.z0);
        t.vertex(bb.x1, bb.y1, bb.z1);
        t.vertex(bb.x1, bb.y0, bb.z1);
        t.offset(0.0, 0.0, 0.0);
        t.end();
        GL11.glEnable((int)3553);
    }

    public static void renderFlat(AABB bb) {
        Tesselator t = Tesselator.instance;
        t.begin();
        t.vertex(bb.x0, bb.y1, bb.z0);
        t.vertex(bb.x1, bb.y1, bb.z0);
        t.vertex(bb.x1, bb.y0, bb.z0);
        t.vertex(bb.x0, bb.y0, bb.z0);
        t.vertex(bb.x0, bb.y0, bb.z1);
        t.vertex(bb.x1, bb.y0, bb.z1);
        t.vertex(bb.x1, bb.y1, bb.z1);
        t.vertex(bb.x0, bb.y1, bb.z1);
        t.vertex(bb.x0, bb.y0, bb.z0);
        t.vertex(bb.x1, bb.y0, bb.z0);
        t.vertex(bb.x1, bb.y0, bb.z1);
        t.vertex(bb.x0, bb.y0, bb.z1);
        t.vertex(bb.x0, bb.y1, bb.z1);
        t.vertex(bb.x1, bb.y1, bb.z1);
        t.vertex(bb.x1, bb.y1, bb.z0);
        t.vertex(bb.x0, bb.y1, bb.z0);
        t.vertex(bb.x0, bb.y0, bb.z1);
        t.vertex(bb.x0, bb.y1, bb.z1);
        t.vertex(bb.x0, bb.y1, bb.z0);
        t.vertex(bb.x0, bb.y0, bb.z0);
        t.vertex(bb.x1, bb.y0, bb.z0);
        t.vertex(bb.x1, bb.y1, bb.z0);
        t.vertex(bb.x1, bb.y1, bb.z1);
        t.vertex(bb.x1, bb.y0, bb.z1);
        t.end();
    }

    public void init(EntityRenderDispatcher entityRenderDispatcher) {
        this.entityRenderDispatcher = entityRenderDispatcher;
    }

    public void postRender(Entity entity, double x, double y, double z, float rot, float a) {
        double dist;
        float pow;
        if (this.entityRenderDispatcher.options.fancyGraphics && this.shadowRadius > 0.0f && (pow = (float)((1.0 - (dist = this.entityRenderDispatcher.distanceToSqr(entity.x, entity.y, entity.z)) / 256.0) * (double)this.shadowStrength)) > 0.0f) {
            this.renderShadow(entity, x, y, z, pow, a);
        }
        if (entity.isOnFire()) {
            this.renderFlame(entity, x, y, z, a);
        }
    }

    public Font getFont() {
        return this.entityRenderDispatcher.getFont();
    }
}

