/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Options;
import net.minecraft.client.gamemode.secret.Builder;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.Textures;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.ChickenRenderer;
import net.minecraft.client.renderer.entity.CowRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.DefaultRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.FallingTileRenderer;
import net.minecraft.client.renderer.entity.FireballRenderer;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.GiantMobRenderer;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.ItemSpriteRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.client.renderer.entity.SquidRenderer;
import net.minecraft.client.renderer.entity.TntRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Painting;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.item.Boat;
import net.minecraft.world.entity.item.FallingTile;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.Minecart;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityRenderDispatcher {
    private Map<Class<? extends Entity>, EntityRenderer<? extends Entity>> renderers = new HashMap<Class<? extends Entity>, EntityRenderer<? extends Entity>>();
    public static EntityRenderDispatcher instance = new EntityRenderDispatcher();
    private Font font;
    public static double xOff;
    public static double yOff;
    public static double zOff;
    public Textures textures;
    public ItemInHandRenderer itemInHandRenderer;
    public Level level;
    public Player player;
    public float playerRotY;
    public float playerRotX;
    public Options options;
    public double xPlayer;
    public double yPlayer;
    public double zPlayer;

    private EntityRenderDispatcher() {
        this.renderers.put(Spider.class, new SpiderRenderer());
        this.renderers.put(Pig.class, new PigRenderer(new PigModel(), new PigModel(0.5f), 0.7f));
        this.renderers.put(Sheep.class, new SheepRenderer(new SheepModel(), new SheepFurModel(), 0.7f));
        this.renderers.put(Cow.class, new CowRenderer(new CowModel(), 0.7f));
        this.renderers.put(Chicken.class, new ChickenRenderer(new ChickenModel(), 0.3f));
        this.renderers.put(Creeper.class, new CreeperRenderer());
        this.renderers.put(Skeleton.class, new HumanoidMobRenderer(new SkeletonModel(), 0.5f));
        this.renderers.put(Zombie.class, new HumanoidMobRenderer(new ZombieModel(), 0.5f));
        this.renderers.put(Builder.class, new HumanoidMobRenderer(new HumanoidModel(), 0.5f));
        this.renderers.put(Slime.class, new SlimeRenderer(new SlimeModel(16), new SlimeModel(0), 0.25f));
        this.renderers.put(Player.class, new PlayerRenderer());
        this.renderers.put(Giant.class, new GiantMobRenderer(new ZombieModel(), 0.5f, 6.0f));
        this.renderers.put(Ghast.class, new GhastRenderer());
        this.renderers.put(Squid.class, new SquidRenderer(new SquidModel(), 0.7f));
        this.renderers.put(Mob.class, new MobRenderer(new HumanoidModel(), 0.5f));
        this.renderers.put(Entity.class, new DefaultRenderer());
        this.renderers.put(Painting.class, new PaintingRenderer());
        this.renderers.put(Arrow.class, new ArrowRenderer());
        this.renderers.put(Snowball.class, new ItemSpriteRenderer(Item.snowBall.getIcon(null)));
        this.renderers.put(ThrownEgg.class, new ItemSpriteRenderer(Item.egg.getIcon(null)));
        this.renderers.put(Fireball.class, new FireballRenderer());
        this.renderers.put(ItemEntity.class, new ItemRenderer());
        this.renderers.put(PrimedTnt.class, new TntRenderer());
        this.renderers.put(FallingTile.class, new FallingTileRenderer());
        this.renderers.put(Minecart.class, new MinecartRenderer());
        this.renderers.put(Boat.class, new BoatRenderer());
        this.renderers.put(FishingHook.class, new FishingHookRenderer());
        for (EntityRenderer<? extends Entity> entityRenderer : this.renderers.values()) {
            entityRenderer.init(this);
        }
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(Class<? extends Entity> clazz) {
        EntityRenderer<Entity> entityRenderer = this.renderers.get(clazz);
        if (entityRenderer == null && clazz != Entity.class) {
            entityRenderer = this.getRenderer(clazz.getSuperclass());
            this.renderers.put(clazz, entityRenderer);
        }
        return entityRenderer;
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(Entity entity) {
        return this.getRenderer(entity.getClass());
    }

    public void prepare(Level level, Textures textures, Font font, Player player, Options options, float f) {
        this.level = level;
        this.textures = textures;
        this.options = options;
        this.player = player;
        this.font = font;
        this.playerRotY = player.yRotO + (player.yRot - player.yRotO) * f;
        this.playerRotX = player.xRotO + (player.xRot - player.xRotO) * f;
        this.xPlayer = player.xOld + (player.x - player.xOld) * (double)f;
        this.yPlayer = player.yOld + (player.y - player.yOld) * (double)f;
        this.zPlayer = player.zOld + (player.z - player.zOld) * (double)f;
    }

    public void render(Entity entity, float f) {
        double d = entity.xOld + (entity.x - entity.xOld) * (double)f;
        double d2 = entity.yOld + (entity.y - entity.yOld) * (double)f;
        double d3 = entity.zOld + (entity.z - entity.zOld) * (double)f;
        float f2 = entity.yRotO + (entity.yRot - entity.yRotO) * f;
        float f3 = entity.getBrightness(f);
        GL11.glColor3f((float)f3, (float)f3, (float)f3);
        this.render(entity, d - xOff, d2 - yOff, d3 - zOff, f2, f);
    }

    public void render(Entity entity, double d, double d2, double d3, float f, float f2) {
        EntityRenderer<Entity> entityRenderer = this.getRenderer(entity);
        if (entityRenderer != null) {
            entityRenderer.render(entity, d, d2, d3, f, f2);
            entityRenderer.postRender(entity, d, d2, d3, f, f2);
        }
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public double distanceToSqr(double d, double d2, double d3) {
        double d4 = d - this.xPlayer;
        double d5 = d2 - this.yPlayer;
        double d6 = d3 - this.zPlayer;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public Font getFont() {
        return this.font;
    }
}

