/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.world.entity.monster.Creeper;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class CreeperRenderer
extends MobRenderer<Creeper> {
    public CreeperRenderer() {
        super(new CreeperModel(), 0.5f);
    }

    @Override
    protected void scale(Creeper mob, float a) {
        Creeper creeper = mob;
        float g = creeper.getSwelling(a);
        float wobble = 1.0f + Mth.sin(g * 100.0f) * g * 0.01f;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        g *= g;
        g *= g;
        float s = (1.0f + g * 0.4f) * wobble;
        float hs = (1.0f + g * 0.1f) / wobble;
        GL11.glScalef((float)s, (float)hs, (float)s);
    }

    @Override
    protected int getOverlayColor(Creeper mob, float br, float a) {
        Creeper creeper = mob;
        float step = creeper.getSwelling(a);
        if ((int)(step * 10.0f) % 2 == 0) {
            return 0;
        }
        int _a = (int)(step * 0.2f * 255.0f);
        if (_a < 0) {
            _a = 0;
        }
        if (_a > 255) {
            _a = 255;
        }
        int r = 255;
        int g = 255;
        int b = 255;
        return _a << 24 | r << 16 | g << 8 | b;
    }
}

