/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.item.Boat;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class BoatRenderer
extends EntityRenderer<Boat> {
    protected Model model;

    public BoatRenderer() {
        this.shadowRadius = 0.5f;
        this.model = new BoatModel();
    }

    @Override
    public void render(Boat boat, double x, double y, double z, float rot, float a) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - rot), (float)0.0f, (float)1.0f, (float)0.0f);
        float hurt = (float)boat.hurtTime - a;
        float dmg = (float)boat.damage - a;
        if (dmg < 0.0f) {
            dmg = 0.0f;
        }
        if (hurt > 0.0f) {
            GL11.glRotatef((float)(Mth.sin(hurt) * hurt * dmg / 10.0f * (float)boat.hurtDir), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.bindTexture("/terrain.png");
        float ss = 0.75f;
        GL11.glScalef((float)ss, (float)ss, (float)ss);
        GL11.glScalef((float)(1.0f / ss), (float)(1.0f / ss), (float)(1.0f / ss));
        this.bindTexture("/item/boat.png");
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.model.render(0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }
}

