/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.culling;

import net.minecraft.client.renderer.culling.Culler;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.FrustumData;
import net.minecraft.world.phys.AABB;

public class FrustumCuller
implements Culler {
    private FrustumData frustum = Frustum.getFrustum();
    private double xOff;
    private double yOff;
    private double zOff;

    @Override
    public void prepare(double xOff, double yOff, double zOff) {
        this.xOff = xOff;
        this.yOff = yOff;
        this.zOff = zOff;
    }

    @Override
    public boolean cubeFullyInFrustum(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.frustum.cubeFullyInFrustum(x0 - this.xOff, y0 - this.yOff, z0 - this.zOff, x1 - this.xOff, y1 - this.yOff, z1 - this.zOff);
    }

    @Override
    public boolean cubeInFrustum(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.frustum.cubeInFrustum(x0 - this.xOff, y0 - this.yOff, z0 - this.zOff, x1 - this.xOff, y1 - this.yOff, z1 - this.zOff);
    }

    @Override
    public boolean isVisible(AABB bb) {
        return this.cubeInFrustum(bb.x0, bb.y0, bb.z0, bb.x1, bb.y1, bb.z1);
    }
}

