/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.DoorTile;
import net.minecraft.world.level.tile.LiquidTile;
import net.minecraft.world.level.tile.RedStoneDustTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class TileRenderer {
    private LevelSource level;
    private int fixedTexture = -1;
    private boolean xFlipTexture = false;
    private boolean noCulling = false;

    public TileRenderer(LevelSource level) {
        this.level = level;
    }

    public TileRenderer() {
    }

    public void tesselateInWorld(Tile tile, int x, int y, int z, int fixedTexture) {
        this.fixedTexture = fixedTexture;
        this.tesselateInWorld(tile, x, y, z);
        this.fixedTexture = -1;
    }

    public void tesselateInWorldNoCulling(Tile tile, int x, int y, int z) {
        this.noCulling = true;
        this.tesselateInWorld(tile, x, y, z);
        this.noCulling = false;
    }

    public boolean tesselateInWorld(Tile tt, int x, int y, int z) {
        int shape = tt.getRenderShape();
        tt.updateShape(this.level, x, y, z);
        if (shape == 0) {
            return this.tesselateBlockInWorld(tt, x, y, z);
        }
        if (shape == 4) {
            return this.tesselateWaterInWorld(tt, x, y, z);
        }
        if (shape == 13) {
            return this.tesselateCactusInWorld(tt, x, y, z);
        }
        if (shape == 1) {
            return this.tesselateCrossInWorld(tt, x, y, z);
        }
        if (shape == 6) {
            return this.tesselateRowInWorld(tt, x, y, z);
        }
        if (shape == 2) {
            return this.tesselateTorchInWorld(tt, x, y, z);
        }
        if (shape == 3) {
            return this.tesselateFireInWorld(tt, x, y, z);
        }
        if (shape == 5) {
            return this.tesselateDustInWorld(tt, x, y, z);
        }
        if (shape == 8) {
            return this.tesselateLadderInWorld(tt, x, y, z);
        }
        if (shape == 7) {
            return this.tesselateDoorInWorld(tt, x, y, z);
        }
        if (shape == 9) {
            return this.tesselateRailInWorld(tt, x, y, z);
        }
        if (shape == 10) {
            return this.tesselateStairsInWorld(tt, x, y, z);
        }
        if (shape == 11) {
            return this.tesselateFenceInWorld(tt, x, y, z);
        }
        if (shape == 12) {
            return this.tesselateLeverInWorld(tt, x, y, z);
        }
        return false;
    }

    public boolean tesselateTorchInWorld(Tile tt, int x, int y, int z) {
        int dir = this.level.getData(x, y, z);
        Tesselator t = Tesselator.instance;
        float br = tt.getBrightness(this.level, x, y, z);
        if (Tile.lightEmission[tt.id] > 0) {
            br = 1.0f;
        }
        t.color(br, br, br);
        double r = 0.4f;
        double r2 = 0.5 - r;
        double h = 0.2f;
        if (dir == 1) {
            this.tesselateTorch(tt, (double)x - r2, (double)y + h, z, -r, 0.0);
        } else if (dir == 2) {
            this.tesselateTorch(tt, (double)x + r2, (double)y + h, z, r, 0.0);
        } else if (dir == 3) {
            this.tesselateTorch(tt, x, (double)y + h, (double)z - r2, 0.0, -r);
        } else if (dir == 4) {
            this.tesselateTorch(tt, x, (double)y + h, (double)z + r2, 0.0, r);
        } else {
            this.tesselateTorch(tt, x, y, z, 0.0, 0.0);
        }
        return true;
    }

    public boolean tesselateLeverInWorld(Tile tt, int x, int y, int z) {
        boolean hadFixed;
        int data = this.level.getData(x, y, z);
        int dir = data & 7;
        boolean flipped = (data & 8) > 0;
        Tesselator t = Tesselator.instance;
        boolean bl = hadFixed = this.fixedTexture >= 0;
        if (!hadFixed) {
            this.fixedTexture = Tile.stoneBrick.tex;
        }
        float w1 = 0.25f;
        float w2 = 0.1875f;
        float h = 0.1875f;
        if (dir == 5) {
            tt.setShape(0.5f - w2, 0.0f, 0.5f - w1, 0.5f + w2, h, 0.5f + w1);
        } else if (dir == 6) {
            tt.setShape(0.5f - w1, 0.0f, 0.5f - w2, 0.5f + w1, h, 0.5f + w2);
        } else if (dir == 4) {
            tt.setShape(0.5f - w2, 0.5f - w1, 1.0f - h, 0.5f + w2, 0.5f + w1, 1.0f);
        } else if (dir == 3) {
            tt.setShape(0.5f - w2, 0.5f - w1, 0.0f, 0.5f + w2, 0.5f + w1, h);
        } else if (dir == 2) {
            tt.setShape(1.0f - h, 0.5f - w1, 0.5f - w2, 1.0f, 0.5f + w1, 0.5f + w2);
        } else if (dir == 1) {
            tt.setShape(0.0f, 0.5f - w1, 0.5f - w2, h, 0.5f + w1, 0.5f + w2);
        }
        this.tesselateBlockInWorld(tt, x, y, z);
        if (!hadFixed) {
            this.fixedTexture = -1;
        }
        float br = tt.getBrightness(this.level, x, y, z);
        if (Tile.lightEmission[tt.id] > 0) {
            br = 1.0f;
        }
        t.color(br, br, br);
        int tex = tt.getTexture(0);
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        float u0 = (float)xt / 256.0f;
        float u1 = ((float)xt + 15.99f) / 256.0f;
        float v0 = (float)yt / 256.0f;
        float v1 = ((float)yt + 15.99f) / 256.0f;
        Vec3[] corners = new Vec3[8];
        float xv = 0.0625f;
        float zv = 0.0625f;
        float yv = 0.625f;
        corners[0] = Vec3.newTemp(-xv, 0.0, -zv);
        corners[1] = Vec3.newTemp(xv, 0.0, -zv);
        corners[2] = Vec3.newTemp(xv, 0.0, zv);
        corners[3] = Vec3.newTemp(-xv, 0.0, zv);
        corners[4] = Vec3.newTemp(-xv, yv, -zv);
        corners[5] = Vec3.newTemp(xv, yv, -zv);
        corners[6] = Vec3.newTemp(xv, yv, zv);
        corners[7] = Vec3.newTemp(-xv, yv, zv);
        int i = 0;
        while (i < 8) {
            if (flipped) {
                corners[i].z -= 0.0625;
                corners[i].xRot(0.69813174f);
            } else {
                corners[i].z += 0.0625;
                corners[i].xRot(-0.69813174f);
            }
            if (dir == 6) {
                corners[i].yRot(1.5707964f);
            }
            if (dir < 5) {
                corners[i].y -= 0.375;
                corners[i].xRot(1.5707964f);
                if (dir == 4) {
                    corners[i].yRot(0.0f);
                }
                if (dir == 3) {
                    corners[i].yRot((float)Math.PI);
                }
                if (dir == 2) {
                    corners[i].yRot(1.5707964f);
                }
                if (dir == 1) {
                    corners[i].yRot(-1.5707964f);
                }
                corners[i].x += (double)x + 0.5;
                corners[i].y += (double)((float)y + 0.5f);
                corners[i].z += (double)z + 0.5;
            } else {
                corners[i].x += (double)x + 0.5;
                corners[i].y += (double)((float)y + 0.125f);
                corners[i].z += (double)z + 0.5;
            }
            ++i;
        }
        Vec3 c0 = null;
        Vec3 c1 = null;
        Vec3 c2 = null;
        Vec3 c3 = null;
        int i2 = 0;
        while (i2 < 6) {
            if (i2 == 0) {
                u0 = (float)(xt + 7) / 256.0f;
                u1 = ((float)(xt + 9) - 0.01f) / 256.0f;
                v0 = (float)(yt + 6) / 256.0f;
                v1 = ((float)(yt + 8) - 0.01f) / 256.0f;
            } else if (i2 == 2) {
                u0 = (float)(xt + 7) / 256.0f;
                u1 = ((float)(xt + 9) - 0.01f) / 256.0f;
                v0 = (float)(yt + 6) / 256.0f;
                v1 = ((float)(yt + 16) - 0.01f) / 256.0f;
            }
            if (i2 == 0) {
                c0 = corners[0];
                c1 = corners[1];
                c2 = corners[2];
                c3 = corners[3];
            } else if (i2 == 1) {
                c0 = corners[7];
                c1 = corners[6];
                c2 = corners[5];
                c3 = corners[4];
            } else if (i2 == 2) {
                c0 = corners[1];
                c1 = corners[0];
                c2 = corners[4];
                c3 = corners[5];
            } else if (i2 == 3) {
                c0 = corners[2];
                c1 = corners[1];
                c2 = corners[5];
                c3 = corners[6];
            } else if (i2 == 4) {
                c0 = corners[3];
                c1 = corners[2];
                c2 = corners[6];
                c3 = corners[7];
            } else if (i2 == 5) {
                c0 = corners[0];
                c1 = corners[3];
                c2 = corners[7];
                c3 = corners[4];
            }
            t.vertexUV(c0.x, c0.y, c0.z, u0, v1);
            t.vertexUV(c1.x, c1.y, c1.z, u1, v1);
            t.vertexUV(c2.x, c2.y, c2.z, u1, v0);
            t.vertexUV(c3.x, c3.y, c3.z, u0, v0);
            ++i2;
        }
        return true;
    }

    public boolean tesselateFireInWorld(Tile tt, int x, int y, int z) {
        Tesselator t = Tesselator.instance;
        int tex = tt.getTexture(0);
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        float br = tt.getBrightness(this.level, x, y, z);
        t.color(br, br, br);
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = (float)xt / 256.0f;
        double u1 = ((float)xt + 15.99f) / 256.0f;
        double v0 = (float)yt / 256.0f;
        double v1 = ((float)yt + 15.99f) / 256.0f;
        float h = 1.4f;
        if (this.level.isSolidTile(x, y - 1, z) || Tile.fire.canBurn(this.level, x, y - 1, z)) {
            double x0 = (double)x + 0.5 + 0.2;
            double x1 = (double)x + 0.5 - 0.2;
            double z0 = (double)z + 0.5 + 0.2;
            double z1 = (double)z + 0.5 - 0.2;
            double x0_ = (double)x + 0.5 - 0.3;
            double x1_ = (double)x + 0.5 + 0.3;
            double z0_ = (double)z + 0.5 - 0.3;
            double z1_ = (double)z + 0.5 + 0.3;
            t.vertexUV(x0_, (float)y + h, z + 1, u1, v0);
            t.vertexUV(x0, y + 0, z + 1, u1, v1);
            t.vertexUV(x0, y + 0, z + 0, u0, v1);
            t.vertexUV(x0_, (float)y + h, z + 0, u0, v0);
            t.vertexUV(x1_, (float)y + h, z + 0, u1, v0);
            t.vertexUV(x1, y + 0, z + 0, u1, v1);
            t.vertexUV(x1, y + 0, z + 1, u0, v1);
            t.vertexUV(x1_, (float)y + h, z + 1, u0, v0);
            u0 = (float)xt / 256.0f;
            u1 = ((float)xt + 15.99f) / 256.0f;
            v0 = (float)(yt + 16) / 256.0f;
            v1 = ((float)yt + 15.99f + 16.0f) / 256.0f;
            t.vertexUV(x + 1, (float)y + h, z1_, u1, v0);
            t.vertexUV(x + 1, y + 0, z1, u1, v1);
            t.vertexUV(x + 0, y + 0, z1, u0, v1);
            t.vertexUV(x + 0, (float)y + h, z1_, u0, v0);
            t.vertexUV(x + 0, (float)y + h, z0_, u1, v0);
            t.vertexUV(x + 0, y + 0, z0, u1, v1);
            t.vertexUV(x + 1, y + 0, z0, u0, v1);
            t.vertexUV(x + 1, (float)y + h, z0_, u0, v0);
            x0 = (double)x + 0.5 - 0.5;
            x1 = (double)x + 0.5 + 0.5;
            z0 = (double)z + 0.5 - 0.5;
            z1 = (double)z + 0.5 + 0.5;
            x0_ = (double)x + 0.5 - 0.4;
            x1_ = (double)x + 0.5 + 0.4;
            z0_ = (double)z + 0.5 - 0.4;
            z1_ = (double)z + 0.5 + 0.4;
            t.vertexUV(x0_, (float)y + h, z + 0, u0, v0);
            t.vertexUV(x0, y + 0, z + 0, u0, v1);
            t.vertexUV(x0, y + 0, z + 1, u1, v1);
            t.vertexUV(x0_, (float)y + h, z + 1, u1, v0);
            t.vertexUV(x1_, (float)y + h, z + 1, u0, v0);
            t.vertexUV(x1, y + 0, z + 1, u0, v1);
            t.vertexUV(x1, y + 0, z + 0, u1, v1);
            t.vertexUV(x1_, (float)y + h, z + 0, u1, v0);
            u0 = (float)xt / 256.0f;
            u1 = ((float)xt + 15.99f) / 256.0f;
            v0 = (float)yt / 256.0f;
            v1 = ((float)yt + 15.99f) / 256.0f;
            t.vertexUV(x + 0, (float)y + h, z1_, u0, v0);
            t.vertexUV(x + 0, y + 0, z1, u0, v1);
            t.vertexUV(x + 1, y + 0, z1, u1, v1);
            t.vertexUV(x + 1, (float)y + h, z1_, u1, v0);
            t.vertexUV(x + 1, (float)y + h, z0_, u0, v0);
            t.vertexUV(x + 1, y + 0, z0, u0, v1);
            t.vertexUV(x + 0, y + 0, z0, u1, v1);
            t.vertexUV(x + 0, (float)y + h, z0_, u1, v0);
        } else {
            float r = 0.2f;
            float yo = 0.0625f;
            if ((x + y + z & 1) == 1) {
                u0 = (float)xt / 256.0f;
                u1 = ((float)xt + 15.99f) / 256.0f;
                v0 = (float)(yt + 16) / 256.0f;
                v1 = ((float)yt + 15.99f + 16.0f) / 256.0f;
            }
            if ((x / 2 + y / 2 + z / 2 & 1) == 1) {
                double tmp = u1;
                u1 = u0;
                u0 = tmp;
            }
            if (Tile.fire.canBurn(this.level, x - 1, y, z)) {
                t.vertexUV((float)x + r, (float)y + h + yo, z + 1, u1, v0);
                t.vertexUV(x + 0, (float)(y + 0) + yo, z + 1, u1, v1);
                t.vertexUV(x + 0, (float)(y + 0) + yo, z + 0, u0, v1);
                t.vertexUV((float)x + r, (float)y + h + yo, z + 0, u0, v0);
                t.vertexUV((float)x + r, (float)y + h + yo, z + 0, u0, v0);
                t.vertexUV(x + 0, (float)(y + 0) + yo, z + 0, u0, v1);
                t.vertexUV(x + 0, (float)(y + 0) + yo, z + 1, u1, v1);
                t.vertexUV((float)x + r, (float)y + h + yo, z + 1, u1, v0);
            }
            if (Tile.fire.canBurn(this.level, x + 1, y, z)) {
                t.vertexUV((float)(x + 1) - r, (float)y + h + yo, z + 0, u0, v0);
                t.vertexUV(x + 1 - 0, (float)(y + 0) + yo, z + 0, u0, v1);
                t.vertexUV(x + 1 - 0, (float)(y + 0) + yo, z + 1, u1, v1);
                t.vertexUV((float)(x + 1) - r, (float)y + h + yo, z + 1, u1, v0);
                t.vertexUV((float)(x + 1) - r, (float)y + h + yo, z + 1, u1, v0);
                t.vertexUV(x + 1 - 0, (float)(y + 0) + yo, z + 1, u1, v1);
                t.vertexUV(x + 1 - 0, (float)(y + 0) + yo, z + 0, u0, v1);
                t.vertexUV((float)(x + 1) - r, (float)y + h + yo, z + 0, u0, v0);
            }
            if (Tile.fire.canBurn(this.level, x, y, z - 1)) {
                t.vertexUV(x + 0, (float)y + h + yo, (float)z + r, u1, v0);
                t.vertexUV(x + 0, (float)(y + 0) + yo, z + 0, u1, v1);
                t.vertexUV(x + 1, (float)(y + 0) + yo, z + 0, u0, v1);
                t.vertexUV(x + 1, (float)y + h + yo, (float)z + r, u0, v0);
                t.vertexUV(x + 1, (float)y + h + yo, (float)z + r, u0, v0);
                t.vertexUV(x + 1, (float)(y + 0) + yo, z + 0, u0, v1);
                t.vertexUV(x + 0, (float)(y + 0) + yo, z + 0, u1, v1);
                t.vertexUV(x + 0, (float)y + h + yo, (float)z + r, u1, v0);
            }
            if (Tile.fire.canBurn(this.level, x, y, z + 1)) {
                t.vertexUV(x + 1, (float)y + h + yo, (float)(z + 1) - r, u0, v0);
                t.vertexUV(x + 1, (float)(y + 0) + yo, z + 1 - 0, u0, v1);
                t.vertexUV(x + 0, (float)(y + 0) + yo, z + 1 - 0, u1, v1);
                t.vertexUV(x + 0, (float)y + h + yo, (float)(z + 1) - r, u1, v0);
                t.vertexUV(x + 0, (float)y + h + yo, (float)(z + 1) - r, u1, v0);
                t.vertexUV(x + 0, (float)(y + 0) + yo, z + 1 - 0, u1, v1);
                t.vertexUV(x + 1, (float)(y + 0) + yo, z + 1 - 0, u0, v1);
                t.vertexUV(x + 1, (float)y + h + yo, (float)(z + 1) - r, u0, v0);
            }
            if (Tile.fire.canBurn(this.level, x, y + 1, z)) {
                double x0 = (double)x + 0.5 + 0.5;
                double x1 = (double)x + 0.5 - 0.5;
                double z0 = (double)z + 0.5 + 0.5;
                double z1 = (double)z + 0.5 - 0.5;
                double x0_ = (double)x + 0.5 - 0.5;
                double x1_ = (double)x + 0.5 + 0.5;
                double z0_ = (double)z + 0.5 - 0.5;
                double z1_ = (double)z + 0.5 + 0.5;
                u0 = (float)xt / 256.0f;
                u1 = ((float)xt + 15.99f) / 256.0f;
                v0 = (float)yt / 256.0f;
                v1 = ((float)yt + 15.99f) / 256.0f;
                h = -0.2f;
                if ((x + ++y + z & 1) == 0) {
                    t.vertexUV(x0_, (float)y + h, z + 0, u1, v0);
                    t.vertexUV(x0, y + 0, z + 0, u1, v1);
                    t.vertexUV(x0, y + 0, z + 1, u0, v1);
                    t.vertexUV(x0_, (float)y + h, z + 1, u0, v0);
                    u0 = (float)xt / 256.0f;
                    u1 = ((float)xt + 15.99f) / 256.0f;
                    v0 = (float)(yt + 16) / 256.0f;
                    v1 = ((float)yt + 15.99f + 16.0f) / 256.0f;
                    t.vertexUV(x1_, (float)y + h, z + 1, u1, v0);
                    t.vertexUV(x1, y + 0, z + 1, u1, v1);
                    t.vertexUV(x1, y + 0, z + 0, u0, v1);
                    t.vertexUV(x1_, (float)y + h, z + 0, u0, v0);
                } else {
                    t.vertexUV(x + 0, (float)y + h, z1_, u1, v0);
                    t.vertexUV(x + 0, y + 0, z1, u1, v1);
                    t.vertexUV(x + 1, y + 0, z1, u0, v1);
                    t.vertexUV(x + 1, (float)y + h, z1_, u0, v0);
                    u0 = (float)xt / 256.0f;
                    u1 = ((float)xt + 15.99f) / 256.0f;
                    v0 = (float)(yt + 16) / 256.0f;
                    v1 = ((float)yt + 15.99f + 16.0f) / 256.0f;
                    t.vertexUV(x + 1, (float)y + h, z0_, u1, v0);
                    t.vertexUV(x + 1, y + 0, z0, u1, v1);
                    t.vertexUV(x + 0, y + 0, z0, u0, v1);
                    t.vertexUV(x + 0, (float)y + h, z0_, u0, v0);
                }
            }
        }
        return true;
    }

    public boolean tesselateDustInWorld(Tile tt, int x, int y, int z) {
        boolean s;
        Tesselator t = Tesselator.instance;
        int tex = tt.getTexture(1, this.level.getData(x, y, z));
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        float br = tt.getBrightness(this.level, x, y, z);
        t.color(br, br, br);
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = (float)xt / 256.0f;
        double u1 = ((float)xt + 15.99f) / 256.0f;
        double v0 = (float)yt / 256.0f;
        double v1 = ((float)yt + 15.99f) / 256.0f;
        float o = 0.0f;
        float r = 0.03125f;
        boolean w = RedStoneDustTile.shouldConnectTo(this.level, x - 1, y, z) || !this.level.isSolidTile(x - 1, y, z) && RedStoneDustTile.shouldConnectTo(this.level, x - 1, y - 1, z);
        boolean e = RedStoneDustTile.shouldConnectTo(this.level, x + 1, y, z) || !this.level.isSolidTile(x + 1, y, z) && RedStoneDustTile.shouldConnectTo(this.level, x + 1, y - 1, z);
        boolean n = RedStoneDustTile.shouldConnectTo(this.level, x, y, z - 1) || !this.level.isSolidTile(x, y, z - 1) && RedStoneDustTile.shouldConnectTo(this.level, x, y - 1, z - 1);
        boolean bl = s = RedStoneDustTile.shouldConnectTo(this.level, x, y, z + 1) || !this.level.isSolidTile(x, y, z + 1) && RedStoneDustTile.shouldConnectTo(this.level, x, y - 1, z + 1);
        if (!this.level.isSolidTile(x, y + 1, z)) {
            if (this.level.isSolidTile(x - 1, y, z) && RedStoneDustTile.shouldConnectTo(this.level, x - 1, y + 1, z)) {
                w = true;
            }
            if (this.level.isSolidTile(x + 1, y, z) && RedStoneDustTile.shouldConnectTo(this.level, x + 1, y + 1, z)) {
                e = true;
            }
            if (this.level.isSolidTile(x, y, z - 1) && RedStoneDustTile.shouldConnectTo(this.level, x, y + 1, z - 1)) {
                n = true;
            }
            if (this.level.isSolidTile(x, y, z + 1) && RedStoneDustTile.shouldConnectTo(this.level, x, y + 1, z + 1)) {
                s = true;
            }
        }
        float d = 0.3125f;
        float x0 = x + 0;
        float x1 = x + 1;
        float z0 = z + 0;
        float z1 = z + 1;
        int pic = 0;
        if ((w || e) && !n && !s) {
            pic = 1;
        }
        if ((n || s) && !e && !w) {
            pic = 2;
        }
        if (pic != 0) {
            u0 = (float)(xt + 16) / 256.0f;
            u1 = ((float)(xt + 16) + 15.99f) / 256.0f;
            v0 = (float)yt / 256.0f;
            v1 = ((float)yt + 15.99f) / 256.0f;
        }
        if (pic == 0) {
            if (e || n || s || w) {
                if (!w) {
                    x0 += d;
                }
                if (!w) {
                    u0 += (double)(d / 16.0f);
                }
                if (!e) {
                    x1 -= d;
                }
                if (!e) {
                    u1 -= (double)(d / 16.0f);
                }
                if (!n) {
                    z0 += d;
                }
                if (!n) {
                    v0 += (double)(d / 16.0f);
                }
                if (!s) {
                    z1 -= d;
                }
                if (!s) {
                    v1 -= (double)(d / 16.0f);
                }
            }
            t.vertexUV(x1 + o, (float)y + r, z1 + o, u1, v1);
            t.vertexUV(x1 + o, (float)y + r, z0 - o, u1, v0);
            t.vertexUV(x0 - o, (float)y + r, z0 - o, u0, v0);
            t.vertexUV(x0 - o, (float)y + r, z1 + o, u0, v1);
        }
        if (pic == 1) {
            t.vertexUV(x1 + o, (float)y + r, z1 + o, u1, v1);
            t.vertexUV(x1 + o, (float)y + r, z0 - o, u1, v0);
            t.vertexUV(x0 - o, (float)y + r, z0 - o, u0, v0);
            t.vertexUV(x0 - o, (float)y + r, z1 + o, u0, v1);
        }
        if (pic == 2) {
            t.vertexUV(x1 + o, (float)y + r, z1 + o, u1, v1);
            t.vertexUV(x1 + o, (float)y + r, z0 - o, u0, v1);
            t.vertexUV(x0 - o, (float)y + r, z0 - o, u0, v0);
            t.vertexUV(x0 - o, (float)y + r, z1 + o, u1, v0);
        }
        u0 = (float)(xt + 16) / 256.0f;
        u1 = ((float)(xt + 16) + 15.99f) / 256.0f;
        v0 = (float)yt / 256.0f;
        v1 = ((float)yt + 15.99f) / 256.0f;
        if (!this.level.isSolidTile(x, y + 1, z)) {
            if (this.level.isSolidTile(x - 1, y, z) && this.level.getTile(x - 1, y + 1, z) == Tile.redStoneDust.id) {
                t.vertexUV((float)x + r, (float)(y + 1) + o, (float)(z + 1) + o, u1, v0);
                t.vertexUV((float)x + r, (float)(y + 0) - o, (float)(z + 1) + o, u0, v0);
                t.vertexUV((float)x + r, (float)(y + 0) - o, (float)(z + 0) - o, u0, v1);
                t.vertexUV((float)x + r, (float)(y + 1) + o, (float)(z + 0) - o, u1, v1);
            }
            if (this.level.isSolidTile(x + 1, y, z) && this.level.getTile(x + 1, y + 1, z) == Tile.redStoneDust.id) {
                t.vertexUV((float)(x + 1) - r, (float)(y + 0) - o, (float)(z + 1) + o, u0, v1);
                t.vertexUV((float)(x + 1) - r, (float)(y + 1) + o, (float)(z + 1) + o, u1, v1);
                t.vertexUV((float)(x + 1) - r, (float)(y + 1) + o, (float)(z + 0) - o, u1, v0);
                t.vertexUV((float)(x + 1) - r, (float)(y + 0) - o, (float)(z + 0) - o, u0, v0);
            }
            if (this.level.isSolidTile(x, y, z - 1) && this.level.getTile(x, y + 1, z - 1) == Tile.redStoneDust.id) {
                t.vertexUV((float)(x + 1) + o, (float)(y + 0) - o, (float)z + r, u0, v1);
                t.vertexUV((float)(x + 1) + o, (float)(y + 1) + o, (float)z + r, u1, v1);
                t.vertexUV((float)(x + 0) - o, (float)(y + 1) + o, (float)z + r, u1, v0);
                t.vertexUV((float)(x + 0) - o, (float)(y + 0) - o, (float)z + r, u0, v0);
            }
            if (this.level.isSolidTile(x, y, z + 1) && this.level.getTile(x, y + 1, z + 1) == Tile.redStoneDust.id) {
                t.vertexUV((float)(x + 1) + o, (float)(y + 1) + o, (float)(z + 1) - r, u1, v0);
                t.vertexUV((float)(x + 1) + o, (float)(y + 0) - o, (float)(z + 1) - r, u0, v0);
                t.vertexUV((float)(x + 0) - o, (float)(y + 0) - o, (float)(z + 1) - r, u0, v1);
                t.vertexUV((float)(x + 0) - o, (float)(y + 1) + o, (float)(z + 1) - r, u1, v1);
            }
        }
        return true;
    }

    public boolean tesselateRailInWorld(Tile tt, int x, int y, int z) {
        Tesselator t = Tesselator.instance;
        int data = this.level.getData(x, y, z);
        int tex = tt.getTexture(0, data);
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        float br = tt.getBrightness(this.level, x, y, z);
        t.color(br, br, br);
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = (float)xt / 256.0f;
        double u1 = ((float)xt + 15.99f) / 256.0f;
        double v0 = (float)yt / 256.0f;
        double v1 = ((float)yt + 15.99f) / 256.0f;
        float r = 0.0625f;
        float x0 = x + 1;
        float x1 = x + 1;
        float x2 = x + 0;
        float x3 = x + 0;
        float z0 = z + 0;
        float z1 = z + 1;
        float z2 = z + 1;
        float z3 = z + 0;
        float y0 = (float)y + r;
        float y1 = (float)y + r;
        float y2 = (float)y + r;
        float y3 = (float)y + r;
        if (data == 1 || data == 2 || data == 3 || data == 7) {
            x0 = x3 = (float)(x + 1);
            x1 = x2 = (float)(x + 0);
            z0 = z1 = (float)(z + 1);
            z2 = z3 = (float)(z + 0);
        } else if (data == 8) {
            x0 = x1 = (float)(x + 0);
            x2 = x3 = (float)(x + 1);
            z0 = z3 = (float)(z + 1);
            z1 = z2 = (float)(z + 0);
        } else if (data == 9) {
            x0 = x3 = (float)(x + 0);
            x1 = x2 = (float)(x + 1);
            z0 = z1 = (float)(z + 0);
            z2 = z3 = (float)(z + 1);
        }
        if (data == 2 || data == 4) {
            y0 += 1.0f;
            y3 += 1.0f;
        } else if (data == 3 || data == 5) {
            y1 += 1.0f;
            y2 += 1.0f;
        }
        t.vertexUV(x0, y0, z0, u1, v0);
        t.vertexUV(x1, y1, z1, u1, v1);
        t.vertexUV(x2, y2, z2, u0, v1);
        t.vertexUV(x3, y3, z3, u0, v0);
        t.vertexUV(x3, y3, z3, u0, v0);
        t.vertexUV(x2, y2, z2, u0, v1);
        t.vertexUV(x1, y1, z1, u1, v1);
        t.vertexUV(x0, y0, z0, u1, v0);
        return true;
    }

    public boolean tesselateLadderInWorld(Tile tt, int x, int y, int z) {
        Tesselator t = Tesselator.instance;
        int tex = tt.getTexture(0);
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        float br = tt.getBrightness(this.level, x, y, z);
        t.color(br, br, br);
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = (float)xt / 256.0f;
        double u1 = ((float)xt + 15.99f) / 256.0f;
        double v0 = (float)yt / 256.0f;
        double v1 = ((float)yt + 15.99f) / 256.0f;
        int face = this.level.getData(x, y, z);
        float o = 0.0f;
        float r = 0.05f;
        if (face == 5) {
            t.vertexUV((float)x + r, (float)(y + 1) + o, (float)(z + 1) + o, u0, v0);
            t.vertexUV((float)x + r, (float)(y + 0) - o, (float)(z + 1) + o, u0, v1);
            t.vertexUV((float)x + r, (float)(y + 0) - o, (float)(z + 0) - o, u1, v1);
            t.vertexUV((float)x + r, (float)(y + 1) + o, (float)(z + 0) - o, u1, v0);
        }
        if (face == 4) {
            t.vertexUV((float)(x + 1) - r, (float)(y + 0) - o, (float)(z + 1) + o, u1, v1);
            t.vertexUV((float)(x + 1) - r, (float)(y + 1) + o, (float)(z + 1) + o, u1, v0);
            t.vertexUV((float)(x + 1) - r, (float)(y + 1) + o, (float)(z + 0) - o, u0, v0);
            t.vertexUV((float)(x + 1) - r, (float)(y + 0) - o, (float)(z + 0) - o, u0, v1);
        }
        if (face == 3) {
            t.vertexUV((float)(x + 1) + o, (float)(y + 0) - o, (float)z + r, u1, v1);
            t.vertexUV((float)(x + 1) + o, (float)(y + 1) + o, (float)z + r, u1, v0);
            t.vertexUV((float)(x + 0) - o, (float)(y + 1) + o, (float)z + r, u0, v0);
            t.vertexUV((float)(x + 0) - o, (float)(y + 0) - o, (float)z + r, u0, v1);
        }
        if (face == 2) {
            t.vertexUV((float)(x + 1) + o, (float)(y + 1) + o, (float)(z + 1) - r, u0, v0);
            t.vertexUV((float)(x + 1) + o, (float)(y + 0) - o, (float)(z + 1) - r, u0, v1);
            t.vertexUV((float)(x + 0) - o, (float)(y + 0) - o, (float)(z + 1) - r, u1, v1);
            t.vertexUV((float)(x + 0) - o, (float)(y + 1) + o, (float)(z + 1) - r, u1, v0);
        }
        return true;
    }

    public boolean tesselateCrossInWorld(Tile tt, int x, int y, int z) {
        Tesselator t = Tesselator.instance;
        float br = tt.getBrightness(this.level, x, y, z);
        t.color(br, br, br);
        this.tesselateCrossTexture(tt, this.level.getData(x, y, z), x, y, z);
        return true;
    }

    public boolean tesselateRowInWorld(Tile tt, int x, int y, int z) {
        Tesselator t = Tesselator.instance;
        float br = tt.getBrightness(this.level, x, y, z);
        t.color(br, br, br);
        this.tesselateRowTexture(tt, this.level.getData(x, y, z), x, (float)y - 0.0625f, z);
        return true;
    }

    public void tesselateTorch(Tile tt, double x, double y, double z, double xxa, double zza) {
        Tesselator t = Tesselator.instance;
        int tex = tt.getTexture(0);
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        float u0 = (float)xt / 256.0f;
        float u1 = ((float)xt + 15.99f) / 256.0f;
        float v0 = (float)yt / 256.0f;
        float v1 = ((float)yt + 15.99f) / 256.0f;
        double uc0 = (double)u0 + 0.02734375;
        double vc0 = (double)v0 + 0.0234375;
        double uc1 = (double)u0 + 0.03515625;
        double vc1 = (double)v0 + 0.03125;
        double x0 = (x += 0.5) - 0.5;
        double x1 = x + 0.5;
        double z0 = (z += 0.5) - 0.5;
        double z1 = z + 0.5;
        double r = 0.0625;
        double h = 0.625;
        t.vertexUV(x + xxa * (1.0 - h) - r, y + h, z + zza * (1.0 - h) - r, uc0, vc0);
        t.vertexUV(x + xxa * (1.0 - h) - r, y + h, z + zza * (1.0 - h) + r, uc0, vc1);
        t.vertexUV(x + xxa * (1.0 - h) + r, y + h, z + zza * (1.0 - h) + r, uc1, vc1);
        t.vertexUV(x + xxa * (1.0 - h) + r, y + h, z + zza * (1.0 - h) - r, uc1, vc0);
        t.vertexUV(x - r, y + 1.0, z0, u0, v0);
        t.vertexUV(x - r + xxa, y + 0.0, z0 + zza, u0, v1);
        t.vertexUV(x - r + xxa, y + 0.0, z1 + zza, u1, v1);
        t.vertexUV(x - r, y + 1.0, z1, u1, v0);
        t.vertexUV(x + r, y + 1.0, z1, u0, v0);
        t.vertexUV(x + xxa + r, y + 0.0, z1 + zza, u0, v1);
        t.vertexUV(x + xxa + r, y + 0.0, z0 + zza, u1, v1);
        t.vertexUV(x + r, y + 1.0, z0, u1, v0);
        t.vertexUV(x0, y + 1.0, z + r, u0, v0);
        t.vertexUV(x0 + xxa, y + 0.0, z + r + zza, u0, v1);
        t.vertexUV(x1 + xxa, y + 0.0, z + r + zza, u1, v1);
        t.vertexUV(x1, y + 1.0, z + r, u1, v0);
        t.vertexUV(x1, y + 1.0, z - r, u0, v0);
        t.vertexUV(x1 + xxa, y + 0.0, z - r + zza, u0, v1);
        t.vertexUV(x0 + xxa, y + 0.0, z - r + zza, u1, v1);
        t.vertexUV(x0, y + 1.0, z - r, u1, v0);
    }

    public void tesselateCrossTexture(Tile tt, int data, double x, double y, double z) {
        Tesselator t = Tesselator.instance;
        int tex = tt.getTexture(0, data);
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = (float)xt / 256.0f;
        double u1 = ((float)xt + 15.99f) / 256.0f;
        double v0 = (float)yt / 256.0f;
        double v1 = ((float)yt + 15.99f) / 256.0f;
        double x0 = x + 0.5 - (double)0.45f;
        double x1 = x + 0.5 + (double)0.45f;
        double z0 = z + 0.5 - (double)0.45f;
        double z1 = z + 0.5 + (double)0.45f;
        t.vertexUV(x0, y + 1.0, z0, u0, v0);
        t.vertexUV(x0, y + 0.0, z0, u0, v1);
        t.vertexUV(x1, y + 0.0, z1, u1, v1);
        t.vertexUV(x1, y + 1.0, z1, u1, v0);
        t.vertexUV(x1, y + 1.0, z1, u0, v0);
        t.vertexUV(x1, y + 0.0, z1, u0, v1);
        t.vertexUV(x0, y + 0.0, z0, u1, v1);
        t.vertexUV(x0, y + 1.0, z0, u1, v0);
        t.vertexUV(x0, y + 1.0, z1, u0, v0);
        t.vertexUV(x0, y + 0.0, z1, u0, v1);
        t.vertexUV(x1, y + 0.0, z0, u1, v1);
        t.vertexUV(x1, y + 1.0, z0, u1, v0);
        t.vertexUV(x1, y + 1.0, z0, u0, v0);
        t.vertexUV(x1, y + 0.0, z0, u0, v1);
        t.vertexUV(x0, y + 0.0, z1, u1, v1);
        t.vertexUV(x0, y + 1.0, z1, u1, v0);
    }

    public void tesselateRowTexture(Tile tt, int data, double x, double y, double z) {
        Tesselator t = Tesselator.instance;
        int tex = tt.getTexture(0, data);
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = (float)xt / 256.0f;
        double u1 = ((float)xt + 15.99f) / 256.0f;
        double v0 = (float)yt / 256.0f;
        double v1 = ((float)yt + 15.99f) / 256.0f;
        double x0 = x + 0.5 - 0.25;
        double x1 = x + 0.5 + 0.25;
        double z0 = z + 0.5 - 0.5;
        double z1 = z + 0.5 + 0.5;
        t.vertexUV(x0, y + 1.0, z0, u0, v0);
        t.vertexUV(x0, y + 0.0, z0, u0, v1);
        t.vertexUV(x0, y + 0.0, z1, u1, v1);
        t.vertexUV(x0, y + 1.0, z1, u1, v0);
        t.vertexUV(x0, y + 1.0, z1, u0, v0);
        t.vertexUV(x0, y + 0.0, z1, u0, v1);
        t.vertexUV(x0, y + 0.0, z0, u1, v1);
        t.vertexUV(x0, y + 1.0, z0, u1, v0);
        t.vertexUV(x1, y + 1.0, z1, u0, v0);
        t.vertexUV(x1, y + 0.0, z1, u0, v1);
        t.vertexUV(x1, y + 0.0, z0, u1, v1);
        t.vertexUV(x1, y + 1.0, z0, u1, v0);
        t.vertexUV(x1, y + 1.0, z0, u0, v0);
        t.vertexUV(x1, y + 0.0, z0, u0, v1);
        t.vertexUV(x1, y + 0.0, z1, u1, v1);
        t.vertexUV(x1, y + 1.0, z1, u1, v0);
        x0 = x + 0.5 - 0.5;
        x1 = x + 0.5 + 0.5;
        z0 = z + 0.5 - 0.25;
        z1 = z + 0.5 + 0.25;
        t.vertexUV(x0, y + 1.0, z0, u0, v0);
        t.vertexUV(x0, y + 0.0, z0, u0, v1);
        t.vertexUV(x1, y + 0.0, z0, u1, v1);
        t.vertexUV(x1, y + 1.0, z0, u1, v0);
        t.vertexUV(x1, y + 1.0, z0, u0, v0);
        t.vertexUV(x1, y + 0.0, z0, u0, v1);
        t.vertexUV(x0, y + 0.0, z0, u1, v1);
        t.vertexUV(x0, y + 1.0, z0, u1, v0);
        t.vertexUV(x1, y + 1.0, z1, u0, v0);
        t.vertexUV(x1, y + 0.0, z1, u0, v1);
        t.vertexUV(x0, y + 0.0, z1, u1, v1);
        t.vertexUV(x0, y + 1.0, z1, u1, v0);
        t.vertexUV(x0, y + 1.0, z1, u0, v0);
        t.vertexUV(x0, y + 0.0, z1, u0, v1);
        t.vertexUV(x1, y + 0.0, z1, u1, v1);
        t.vertexUV(x1, y + 1.0, z1, u1, v0);
    }

    public boolean tesselateWaterInWorld(Tile tt, int x, int y, int z) {
        Tesselator t = Tesselator.instance;
        boolean up = tt.shouldRenderFace(this.level, x, y + 1, z, 1);
        boolean down = tt.shouldRenderFace(this.level, x, y - 1, z, 0);
        boolean[] dirs = new boolean[]{tt.shouldRenderFace(this.level, x, y, z - 1, 2), tt.shouldRenderFace(this.level, x, y, z + 1, 3), tt.shouldRenderFace(this.level, x - 1, y, z, 4), tt.shouldRenderFace(this.level, x + 1, y, z, 5)};
        if (!(up || down || dirs[0] || dirs[1] || dirs[2] || dirs[3])) {
            return false;
        }
        boolean changed = false;
        float c10 = 0.5f;
        float c11 = 1.0f;
        float c2 = 0.8f;
        float c3 = 0.6f;
        double yo0 = 0.0;
        double yo1 = 1.0;
        Material m = tt.material;
        int data = this.level.getData(x, y, z);
        float h0 = this.getWaterHeight(x, y, z, m);
        float h1 = this.getWaterHeight(x, y, z + 1, m);
        float h2 = this.getWaterHeight(x + 1, y, z + 1, m);
        float h3 = this.getWaterHeight(x + 1, y, z, m);
        if (this.noCulling || up) {
            changed = true;
            int tex = tt.getTexture(1, data);
            float angle = (float)LiquidTile.getSlopeAngle(this.level, x, y, z, m);
            if (angle > -999.0f) {
                tex = tt.getTexture(2, data);
            }
            int xt = (tex & 0xF) << 4;
            int yt = tex & 0xF0;
            double uc = ((double)xt + 8.0) / 256.0;
            double vc = ((double)yt + 8.0) / 256.0;
            if (angle < -999.0f) {
                angle = 0.0f;
            } else {
                uc = (float)(xt + 16) / 256.0f;
                vc = (float)(yt + 16) / 256.0f;
            }
            float s = Mth.sin(angle) * 8.0f / 256.0f;
            float c = Mth.cos(angle) * 8.0f / 256.0f;
            float br = tt.getBrightness(this.level, x, y, z);
            t.color(c11 * br, c11 * br, c11 * br);
            t.vertexUV(x + 0, (float)y + h0, z + 0, uc - (double)c - (double)s, vc - (double)c + (double)s);
            t.vertexUV(x + 0, (float)y + h1, z + 1, uc - (double)c + (double)s, vc + (double)c + (double)s);
            t.vertexUV(x + 1, (float)y + h2, z + 1, uc + (double)c + (double)s, vc + (double)c - (double)s);
            t.vertexUV(x + 1, (float)y + h3, z + 0, uc + (double)c - (double)s, vc - (double)c - (double)s);
        }
        if (this.noCulling || down) {
            float br = tt.getBrightness(this.level, x, y - 1, z);
            t.color(c10 * br, c10 * br, c10 * br);
            this.renderFaceUp(tt, x, y, z, tt.getTexture(0));
            changed = true;
        }
        int face = 0;
        while (face < 4) {
            int xt = x;
            int yt = y;
            int zt = z;
            if (face == 0) {
                --zt;
            }
            if (face == 1) {
                ++zt;
            }
            if (face == 2) {
                --xt;
            }
            if (face == 3) {
                ++xt;
            }
            int tex = tt.getTexture(face + 2, data);
            int xTex = (tex & 0xF) << 4;
            int yTex = tex & 0xF0;
            if (this.noCulling || dirs[face]) {
                float z1;
                float z0;
                float x1;
                float x0;
                float hh1;
                float hh0;
                if (face == 0) {
                    hh0 = h0;
                    hh1 = h3;
                    x0 = x;
                    x1 = x + 1;
                    z0 = z;
                    z1 = z;
                } else if (face == 1) {
                    hh0 = h2;
                    hh1 = h1;
                    x0 = x + 1;
                    x1 = x;
                    z0 = z + 1;
                    z1 = z + 1;
                } else if (face == 2) {
                    hh0 = h1;
                    hh1 = h0;
                    x0 = x;
                    x1 = x;
                    z0 = z + 1;
                    z1 = z;
                } else {
                    hh0 = h3;
                    hh1 = h2;
                    x0 = x + 1;
                    x1 = x + 1;
                    z0 = z;
                    z1 = z + 1;
                }
                changed = true;
                double u0 = (float)(xTex + 0) / 256.0f;
                double u1 = ((double)(xTex + 16) - 0.01) / 256.0;
                double v01 = ((float)yTex + (1.0f - hh0) * 16.0f) / 256.0f;
                double v02 = ((float)yTex + (1.0f - hh1) * 16.0f) / 256.0f;
                double v1 = ((double)(yTex + 16) - 0.01) / 256.0;
                float br = tt.getBrightness(this.level, xt, yt, zt);
                br = face < 2 ? (br *= c2) : (br *= c3);
                t.color(c11 * br, c11 * br, c11 * br);
                t.vertexUV(x0, (float)y + hh0, z0, u0, v01);
                t.vertexUV(x1, (float)y + hh1, z1, u1, v02);
                t.vertexUV(x1, y + 0, z1, u1, v1);
                t.vertexUV(x0, y + 0, z0, u0, v1);
            }
            ++face;
        }
        tt.yy0 = yo0;
        tt.yy1 = yo1;
        return changed;
    }

    private float getWaterHeight(int x, int y, int z, Material m) {
        int count = 0;
        float h = 0.0f;
        int i = 0;
        while (i < 4) {
            int xx = x - (i & 1);
            int yy = y;
            int zz = z - (i >> 1 & 1);
            if (this.level.getMaterial(xx, yy + 1, zz) == m) {
                return 1.0f;
            }
            Material tm = this.level.getMaterial(xx, yy, zz);
            if (tm == m) {
                int d = this.level.getData(xx, yy, zz);
                if (d >= 8 || d == 0) {
                    h += LiquidTile.getHeight(d) * 10.0f;
                    count += 10;
                }
                h += LiquidTile.getHeight(d);
                ++count;
            } else if (!tm.isSolid()) {
                h += 1.0f;
                ++count;
            }
            ++i;
        }
        return 1.0f - h / (float)count;
    }

    public void renderBlock(Tile tt, Level level, int x, int y, int z) {
        float c10 = 0.5f;
        float c11 = 1.0f;
        float c2 = 0.8f;
        float c3 = 0.6f;
        Tesselator t = Tesselator.instance;
        t.begin();
        float center = tt.getBrightness(level, x, y, z);
        float br = tt.getBrightness(level, x, y - 1, z);
        if (br < center) {
            br = center;
        }
        t.color(c10 * br, c10 * br, c10 * br);
        this.renderFaceUp(tt, -0.5, -0.5, -0.5, tt.getTexture(0));
        br = tt.getBrightness(level, x, y + 1, z);
        if (br < center) {
            br = center;
        }
        t.color(c11 * br, c11 * br, c11 * br);
        this.renderFaceDown(tt, -0.5, -0.5, -0.5, tt.getTexture(1));
        br = tt.getBrightness(level, x, y, z - 1);
        if (br < center) {
            br = center;
        }
        t.color(c2 * br, c2 * br, c2 * br);
        this.renderNorth(tt, -0.5, -0.5, -0.5, tt.getTexture(2));
        br = tt.getBrightness(level, x, y, z + 1);
        if (br < center) {
            br = center;
        }
        t.color(c2 * br, c2 * br, c2 * br);
        this.renderSouth(tt, -0.5, -0.5, -0.5, tt.getTexture(3));
        br = tt.getBrightness(level, x - 1, y, z);
        if (br < center) {
            br = center;
        }
        t.color(c3 * br, c3 * br, c3 * br);
        this.renderWest(tt, -0.5, -0.5, -0.5, tt.getTexture(4));
        br = tt.getBrightness(level, x + 1, y, z);
        if (br < center) {
            br = center;
        }
        t.color(c3 * br, c3 * br, c3 * br);
        this.renderEast(tt, -0.5, -0.5, -0.5, tt.getTexture(5));
        t.end();
    }

    public boolean tesselateBlockInWorld(Tile tt, int x, int y, int z) {
        int col = tt.getColor(this.level, x, y, z);
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        return this.tesselateBlockInWorld(tt, x, y, z, r, g, b);
    }

    public boolean tesselateBlockInWorld(Tile tt, int x, int y, int z, float r, float g, float b) {
        float br;
        Tesselator t = Tesselator.instance;
        boolean changed = false;
        float c10 = 0.5f;
        float c11 = 1.0f;
        float c2 = 0.8f;
        float c3 = 0.6f;
        float r11 = c11 * r;
        float g11 = c11 * g;
        float b11 = c11 * b;
        if (tt == Tile.grass) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        }
        float r10 = c10 * r;
        float r2 = c2 * r;
        float r3 = c3 * r;
        float g10 = c10 * g;
        float g2 = c2 * g;
        float g3 = c3 * g;
        float b10 = c10 * b;
        float b2 = c2 * b;
        float b3 = c3 * b;
        float centerBrightness = tt.getBrightness(this.level, x, y, z);
        if (this.noCulling || tt.shouldRenderFace(this.level, x, y - 1, z, 0)) {
            br = tt.getBrightness(this.level, x, y - 1, z);
            t.color(r10 * br, g10 * br, b10 * br);
            this.renderFaceUp(tt, x, y, z, tt.getTexture(this.level, x, y, z, 0));
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x, y + 1, z, 1)) {
            br = tt.getBrightness(this.level, x, y + 1, z);
            if (tt.yy1 != 1.0 && !tt.material.isLiquid()) {
                br = centerBrightness;
            }
            t.color(r11 * br, g11 * br, b11 * br);
            this.renderFaceDown(tt, x, y, z, tt.getTexture(this.level, x, y, z, 1));
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x, y, z - 1, 2)) {
            br = tt.getBrightness(this.level, x, y, z - 1);
            if (tt.zz0 > 0.0) {
                br = centerBrightness;
            }
            t.color(r2 * br, g2 * br, b2 * br);
            this.renderNorth(tt, x, y, z, tt.getTexture(this.level, x, y, z, 2));
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x, y, z + 1, 3)) {
            br = tt.getBrightness(this.level, x, y, z + 1);
            if (tt.zz1 < 1.0) {
                br = centerBrightness;
            }
            t.color(r2 * br, g2 * br, b2 * br);
            this.renderSouth(tt, x, y, z, tt.getTexture(this.level, x, y, z, 3));
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x - 1, y, z, 4)) {
            br = tt.getBrightness(this.level, x - 1, y, z);
            if (tt.xx0 > 0.0) {
                br = centerBrightness;
            }
            t.color(r3 * br, g3 * br, b3 * br);
            this.renderWest(tt, x, y, z, tt.getTexture(this.level, x, y, z, 4));
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x + 1, y, z, 5)) {
            br = tt.getBrightness(this.level, x + 1, y, z);
            if (tt.xx1 < 1.0) {
                br = centerBrightness;
            }
            t.color(r3 * br, g3 * br, b3 * br);
            this.renderEast(tt, x, y, z, tt.getTexture(this.level, x, y, z, 5));
            changed = true;
        }
        return changed;
    }

    public boolean tesselateCactusInWorld(Tile tt, int x, int y, int z) {
        int col = tt.getColor(this.level, x, y, z);
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        return this.tesselateCactusInWorld(tt, x, y, z, r, g, b);
    }

    public boolean tesselateCactusInWorld(Tile tt, int x, int y, int z, float r, float g, float b) {
        float br;
        Tesselator t = Tesselator.instance;
        boolean changed = false;
        float c10 = 0.5f;
        float c11 = 1.0f;
        float c2 = 0.8f;
        float c3 = 0.6f;
        float r10 = c10 * r;
        float r11 = c11 * r;
        float r2 = c2 * r;
        float r3 = c3 * r;
        float g10 = c10 * g;
        float g11 = c11 * g;
        float g2 = c2 * g;
        float g3 = c3 * g;
        float b10 = c10 * b;
        float b11 = c11 * b;
        float b2 = c2 * b;
        float b3 = c3 * b;
        float s = 0.0625f;
        float centerBrightness = tt.getBrightness(this.level, x, y, z);
        if (this.noCulling || tt.shouldRenderFace(this.level, x, y - 1, z, 0)) {
            br = tt.getBrightness(this.level, x, y - 1, z);
            t.color(r10 * br, g10 * br, b10 * br);
            this.renderFaceUp(tt, x, y, z, tt.getTexture(this.level, x, y, z, 0));
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x, y + 1, z, 1)) {
            br = tt.getBrightness(this.level, x, y + 1, z);
            if (tt.yy1 != 1.0 && !tt.material.isLiquid()) {
                br = centerBrightness;
            }
            t.color(r11 * br, g11 * br, b11 * br);
            this.renderFaceDown(tt, x, y, z, tt.getTexture(this.level, x, y, z, 1));
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x, y, z - 1, 2)) {
            br = tt.getBrightness(this.level, x, y, z - 1);
            if (tt.zz0 > 0.0) {
                br = centerBrightness;
            }
            t.color(r2 * br, g2 * br, b2 * br);
            t.addOffset(0.0f, 0.0f, s);
            this.renderNorth(tt, x, y, z, tt.getTexture(this.level, x, y, z, 2));
            t.addOffset(0.0f, 0.0f, -s);
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x, y, z + 1, 3)) {
            br = tt.getBrightness(this.level, x, y, z + 1);
            if (tt.zz1 < 1.0) {
                br = centerBrightness;
            }
            t.color(r2 * br, g2 * br, b2 * br);
            t.addOffset(0.0f, 0.0f, -s);
            this.renderSouth(tt, x, y, z, tt.getTexture(this.level, x, y, z, 3));
            t.addOffset(0.0f, 0.0f, s);
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x - 1, y, z, 4)) {
            br = tt.getBrightness(this.level, x - 1, y, z);
            if (tt.xx0 > 0.0) {
                br = centerBrightness;
            }
            t.color(r3 * br, g3 * br, b3 * br);
            t.addOffset(s, 0.0f, 0.0f);
            this.renderWest(tt, x, y, z, tt.getTexture(this.level, x, y, z, 4));
            t.addOffset(-s, 0.0f, 0.0f);
            changed = true;
        }
        if (this.noCulling || tt.shouldRenderFace(this.level, x + 1, y, z, 5)) {
            br = tt.getBrightness(this.level, x + 1, y, z);
            if (tt.xx1 < 1.0) {
                br = centerBrightness;
            }
            t.color(r3 * br, g3 * br, b3 * br);
            t.addOffset(-s, 0.0f, 0.0f);
            this.renderEast(tt, x, y, z, tt.getTexture(this.level, x, y, z, 5));
            t.addOffset(s, 0.0f, 0.0f);
            changed = true;
        }
        return changed;
    }

    public boolean tesselateFenceInWorld(Tile tt, int x, int y, int z) {
        float z1;
        boolean d;
        boolean changed = false;
        float a = 0.375f;
        float b = 0.625f;
        tt.setShape(a, 0.0f, a, b, 1.0f, b);
        this.tesselateBlockInWorld(tt, x, y, z);
        boolean vertical = false;
        boolean horizontal = false;
        if (this.level.getTile(x - 1, y, z) == tt.id || this.level.getTile(x + 1, y, z) == tt.id) {
            vertical = true;
        }
        if (this.level.getTile(x, y, z - 1) == tt.id || this.level.getTile(x, y, z + 1) == tt.id) {
            horizontal = true;
        }
        boolean l = this.level.getTile(x - 1, y, z) == tt.id;
        boolean r = this.level.getTile(x + 1, y, z) == tt.id;
        boolean u = this.level.getTile(x, y, z - 1) == tt.id;
        boolean bl = d = this.level.getTile(x, y, z + 1) == tt.id;
        if (!vertical && !horizontal) {
            vertical = true;
        }
        a = 0.4375f;
        b = 0.5625f;
        float h0 = 0.75f;
        float h1 = 0.9375f;
        float x0 = l ? 0.0f : a;
        float x1 = r ? 1.0f : b;
        float z0 = u ? 0.0f : a;
        float f = z1 = d ? 1.0f : b;
        if (vertical) {
            tt.setShape(x0, h0, a, x1, h1, b);
            this.tesselateBlockInWorld(tt, x, y, z);
        }
        if (horizontal) {
            tt.setShape(a, h0, z0, b, h1, z1);
            this.tesselateBlockInWorld(tt, x, y, z);
        }
        h0 = 0.375f;
        h1 = 0.5625f;
        if (vertical) {
            tt.setShape(x0, h0, a, x1, h1, b);
            this.tesselateBlockInWorld(tt, x, y, z);
        }
        if (horizontal) {
            tt.setShape(a, h0, z0, b, h1, z1);
            this.tesselateBlockInWorld(tt, x, y, z);
        }
        tt.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return changed;
    }

    public boolean tesselateStairsInWorld(Tile tt, int x, int y, int z) {
        boolean changed = false;
        int dir = this.level.getData(x, y, z);
        if (dir == 0) {
            tt.setShape(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            this.tesselateBlockInWorld(tt, x, y, z);
            tt.setShape(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            this.tesselateBlockInWorld(tt, x, y, z);
        } else if (dir == 1) {
            tt.setShape(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            this.tesselateBlockInWorld(tt, x, y, z);
            tt.setShape(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            this.tesselateBlockInWorld(tt, x, y, z);
        } else if (dir == 2) {
            tt.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            this.tesselateBlockInWorld(tt, x, y, z);
            tt.setShape(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            this.tesselateBlockInWorld(tt, x, y, z);
        } else if (dir == 3) {
            tt.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            this.tesselateBlockInWorld(tt, x, y, z);
            tt.setShape(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            this.tesselateBlockInWorld(tt, x, y, z);
        }
        tt.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return changed;
    }

    public boolean tesselateDoorInWorld(Tile tt, int x, int y, int z) {
        Tesselator t = Tesselator.instance;
        DoorTile dt = (DoorTile)tt;
        boolean changed = false;
        float c10 = 0.5f;
        float c11 = 1.0f;
        float c2 = 0.8f;
        float c3 = 0.6f;
        float centerBrightness = tt.getBrightness(this.level, x, y, z);
        float br = tt.getBrightness(this.level, x, y - 1, z);
        if (dt.yy0 > 0.0) {
            br = centerBrightness;
        }
        if (Tile.lightEmission[tt.id] > 0) {
            br = 1.0f;
        }
        t.color(c10 * br, c10 * br, c10 * br);
        this.renderFaceUp(tt, x, y, z, tt.getTexture(this.level, x, y, z, 0));
        changed = true;
        br = tt.getBrightness(this.level, x, y + 1, z);
        if (dt.yy1 < 1.0) {
            br = centerBrightness;
        }
        if (Tile.lightEmission[tt.id] > 0) {
            br = 1.0f;
        }
        t.color(c11 * br, c11 * br, c11 * br);
        this.renderFaceDown(tt, x, y, z, tt.getTexture(this.level, x, y, z, 1));
        changed = true;
        br = tt.getBrightness(this.level, x, y, z - 1);
        if (dt.zz0 > 0.0) {
            br = centerBrightness;
        }
        if (Tile.lightEmission[tt.id] > 0) {
            br = 1.0f;
        }
        t.color(c2 * br, c2 * br, c2 * br);
        int tex = tt.getTexture(this.level, x, y, z, 2);
        if (tex < 0) {
            this.xFlipTexture = true;
            tex = -tex;
        }
        this.renderNorth(tt, x, y, z, tex);
        changed = true;
        this.xFlipTexture = false;
        br = tt.getBrightness(this.level, x, y, z + 1);
        if (dt.zz1 < 1.0) {
            br = centerBrightness;
        }
        if (Tile.lightEmission[tt.id] > 0) {
            br = 1.0f;
        }
        t.color(c2 * br, c2 * br, c2 * br);
        tex = tt.getTexture(this.level, x, y, z, 3);
        if (tex < 0) {
            this.xFlipTexture = true;
            tex = -tex;
        }
        this.renderSouth(tt, x, y, z, tex);
        changed = true;
        this.xFlipTexture = false;
        br = tt.getBrightness(this.level, x - 1, y, z);
        if (dt.xx0 > 0.0) {
            br = centerBrightness;
        }
        if (Tile.lightEmission[tt.id] > 0) {
            br = 1.0f;
        }
        t.color(c3 * br, c3 * br, c3 * br);
        tex = tt.getTexture(this.level, x, y, z, 4);
        if (tex < 0) {
            this.xFlipTexture = true;
            tex = -tex;
        }
        this.renderWest(tt, x, y, z, tex);
        changed = true;
        this.xFlipTexture = false;
        br = tt.getBrightness(this.level, x + 1, y, z);
        if (dt.xx1 < 1.0) {
            br = centerBrightness;
        }
        if (Tile.lightEmission[tt.id] > 0) {
            br = 1.0f;
        }
        t.color(c3 * br, c3 * br, c3 * br);
        tex = tt.getTexture(this.level, x, y, z, 5);
        if (tex < 0) {
            this.xFlipTexture = true;
            tex = -tex;
        }
        this.renderEast(tt, x, y, z, tex);
        changed = true;
        this.xFlipTexture = false;
        return changed;
    }

    public void renderFaceUp(Tile tt, double x, double y, double z, int tex) {
        Tesselator t = Tesselator.instance;
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = ((double)xt + tt.xx0 * 16.0) / 256.0;
        double u1 = ((double)xt + tt.xx1 * 16.0 - 0.01) / 256.0;
        double v0 = ((double)yt + tt.zz0 * 16.0) / 256.0;
        double v1 = ((double)yt + tt.zz1 * 16.0 - 0.01) / 256.0;
        if (tt.xx0 < 0.0 || tt.xx1 > 1.0) {
            u0 = ((float)xt + 0.0f) / 256.0f;
            u1 = ((float)xt + 15.99f) / 256.0f;
        }
        if (tt.zz0 < 0.0 || tt.zz1 > 1.0) {
            v0 = ((float)yt + 0.0f) / 256.0f;
            v1 = ((float)yt + 15.99f) / 256.0f;
        }
        double x0 = x + tt.xx0;
        double x1 = x + tt.xx1;
        double y0 = y + tt.yy0;
        double z0 = z + tt.zz0;
        double z1 = z + tt.zz1;
        t.vertexUV(x0, y0, z1, u0, v1);
        t.vertexUV(x0, y0, z0, u0, v0);
        t.vertexUV(x1, y0, z0, u1, v0);
        t.vertexUV(x1, y0, z1, u1, v1);
    }

    public void renderFaceDown(Tile tt, double x, double y, double z, int tex) {
        Tesselator t = Tesselator.instance;
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = ((double)xt + tt.xx0 * 16.0) / 256.0;
        double u1 = ((double)xt + tt.xx1 * 16.0 - 0.01) / 256.0;
        double v0 = ((double)yt + tt.zz0 * 16.0) / 256.0;
        double v1 = ((double)yt + tt.zz1 * 16.0 - 0.01) / 256.0;
        if (tt.xx0 < 0.0 || tt.xx1 > 1.0) {
            u0 = ((float)xt + 0.0f) / 256.0f;
            u1 = ((float)xt + 15.99f) / 256.0f;
        }
        if (tt.zz0 < 0.0 || tt.zz1 > 1.0) {
            v0 = ((float)yt + 0.0f) / 256.0f;
            v1 = ((float)yt + 15.99f) / 256.0f;
        }
        double x0 = x + tt.xx0;
        double x1 = x + tt.xx1;
        double y1 = y + tt.yy1;
        double z0 = z + tt.zz0;
        double z1 = z + tt.zz1;
        t.vertexUV(x1, y1, z1, u1, v1);
        t.vertexUV(x1, y1, z0, u1, v0);
        t.vertexUV(x0, y1, z0, u0, v0);
        t.vertexUV(x0, y1, z1, u0, v1);
    }

    public void renderNorth(Tile tt, double x, double y, double z, int tex) {
        Tesselator t = Tesselator.instance;
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = ((double)xt + tt.xx0 * 16.0) / 256.0;
        double u1 = ((double)xt + tt.xx1 * 16.0 - 0.01) / 256.0;
        double v0 = ((double)yt + tt.yy0 * 16.0) / 256.0;
        double v1 = ((double)yt + tt.yy1 * 16.0 - 0.01) / 256.0;
        if (this.xFlipTexture) {
            double tmp = u0;
            u0 = u1;
            u1 = tmp;
        }
        if (tt.xx0 < 0.0 || tt.xx1 > 1.0) {
            u0 = ((float)xt + 0.0f) / 256.0f;
            u1 = ((float)xt + 15.99f) / 256.0f;
        }
        if (tt.yy0 < 0.0 || tt.yy1 > 1.0) {
            v0 = ((float)yt + 0.0f) / 256.0f;
            v1 = ((float)yt + 15.99f) / 256.0f;
        }
        double x0 = x + tt.xx0;
        double x1 = x + tt.xx1;
        double y0 = y + tt.yy0;
        double y1 = y + tt.yy1;
        double z0 = z + tt.zz0;
        t.vertexUV(x0, y1, z0, u1, v0);
        t.vertexUV(x1, y1, z0, u0, v0);
        t.vertexUV(x1, y0, z0, u0, v1);
        t.vertexUV(x0, y0, z0, u1, v1);
    }

    public void renderSouth(Tile tt, double x, double y, double z, int tex) {
        Tesselator t = Tesselator.instance;
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = ((double)xt + tt.xx0 * 16.0) / 256.0;
        double u1 = ((double)xt + tt.xx1 * 16.0 - 0.01) / 256.0;
        double v0 = ((double)yt + tt.yy0 * 16.0) / 256.0;
        double v1 = ((double)yt + tt.yy1 * 16.0 - 0.01) / 256.0;
        if (this.xFlipTexture) {
            double tmp = u0;
            u0 = u1;
            u1 = tmp;
        }
        if (tt.xx0 < 0.0 || tt.xx1 > 1.0) {
            u0 = ((float)xt + 0.0f) / 256.0f;
            u1 = ((float)xt + 15.99f) / 256.0f;
        }
        if (tt.yy0 < 0.0 || tt.yy1 > 1.0) {
            v0 = ((float)yt + 0.0f) / 256.0f;
            v1 = ((float)yt + 15.99f) / 256.0f;
        }
        double x0 = x + tt.xx0;
        double x1 = x + tt.xx1;
        double y0 = y + tt.yy0;
        double y1 = y + tt.yy1;
        double z1 = z + tt.zz1;
        t.vertexUV(x0, y1, z1, u0, v0);
        t.vertexUV(x0, y0, z1, u0, v1);
        t.vertexUV(x1, y0, z1, u1, v1);
        t.vertexUV(x1, y1, z1, u1, v0);
    }

    public void renderWest(Tile tt, double x, double y, double z, int tex) {
        Tesselator t = Tesselator.instance;
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = ((double)xt + tt.zz0 * 16.0) / 256.0;
        double u1 = ((double)xt + tt.zz1 * 16.0 - 0.01) / 256.0;
        double v0 = ((double)yt + tt.yy0 * 16.0) / 256.0;
        double v1 = ((double)yt + tt.yy1 * 16.0 - 0.01) / 256.0;
        if (this.xFlipTexture) {
            double tmp = u0;
            u0 = u1;
            u1 = tmp;
        }
        if (tt.zz0 < 0.0 || tt.zz1 > 1.0) {
            u0 = ((float)xt + 0.0f) / 256.0f;
            u1 = ((float)xt + 15.99f) / 256.0f;
        }
        if (tt.yy0 < 0.0 || tt.yy1 > 1.0) {
            v0 = ((float)yt + 0.0f) / 256.0f;
            v1 = ((float)yt + 15.99f) / 256.0f;
        }
        double x0 = x + tt.xx0;
        double y0 = y + tt.yy0;
        double y1 = y + tt.yy1;
        double z0 = z + tt.zz0;
        double z1 = z + tt.zz1;
        t.vertexUV(x0, y1, z1, u1, v0);
        t.vertexUV(x0, y1, z0, u0, v0);
        t.vertexUV(x0, y0, z0, u0, v1);
        t.vertexUV(x0, y0, z1, u1, v1);
    }

    public void renderEast(Tile tt, double x, double y, double z, int tex) {
        Tesselator t = Tesselator.instance;
        if (this.fixedTexture >= 0) {
            tex = this.fixedTexture;
        }
        int xt = (tex & 0xF) << 4;
        int yt = tex & 0xF0;
        double u0 = ((double)xt + tt.zz0 * 16.0) / 256.0;
        double u1 = ((double)xt + tt.zz1 * 16.0 - 0.01) / 256.0;
        double v0 = ((double)yt + tt.yy0 * 16.0) / 256.0;
        double v1 = ((double)yt + tt.yy1 * 16.0 - 0.01) / 256.0;
        if (this.xFlipTexture) {
            double tmp = u0;
            u0 = u1;
            u1 = tmp;
        }
        if (tt.zz0 < 0.0 || tt.zz1 > 1.0) {
            u0 = ((float)xt + 0.0f) / 256.0f;
            u1 = ((float)xt + 15.99f) / 256.0f;
        }
        if (tt.yy0 < 0.0 || tt.yy1 > 1.0) {
            v0 = ((float)yt + 0.0f) / 256.0f;
            v1 = ((float)yt + 15.99f) / 256.0f;
        }
        double x1 = x + tt.xx1;
        double y0 = y + tt.yy0;
        double y1 = y + tt.yy1;
        double z0 = z + tt.zz0;
        double z1 = z + tt.zz1;
        t.vertexUV(x1, y0, z1, u0, v1);
        t.vertexUV(x1, y0, z0, u1, v1);
        t.vertexUV(x1, y1, z0, u1, v0);
        t.vertexUV(x1, y1, z1, u0, v0);
    }

    public void renderCube(Tile tile, float alpha) {
        int shape = tile.getRenderShape();
        Tesselator t = Tesselator.instance;
        if (shape == 0) {
            tile.updateDefaultShape();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float c10 = 0.5f;
            float c11 = 1.0f;
            float c2 = 0.8f;
            float c3 = 0.6f;
            t.begin();
            t.color(c11, c11, c11, alpha);
            this.renderFaceUp(tile, 0.0, 0.0, 0.0, tile.getTexture(0));
            t.color(c10, c10, c10, alpha);
            this.renderFaceDown(tile, 0.0, 0.0, 0.0, tile.getTexture(1));
            t.color(c2, c2, c2, alpha);
            this.renderNorth(tile, 0.0, 0.0, 0.0, tile.getTexture(2));
            this.renderSouth(tile, 0.0, 0.0, 0.0, tile.getTexture(3));
            t.color(c3, c3, c3, alpha);
            this.renderWest(tile, 0.0, 0.0, 0.0, tile.getTexture(4));
            this.renderEast(tile, 0.0, 0.0, 0.0, tile.getTexture(5));
            t.end();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public void renderTile(Tile tile, int data) {
        Tesselator t = Tesselator.instance;
        int shape = tile.getRenderShape();
        if (shape == 0) {
            tile.updateDefaultShape();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            t.begin();
            t.normal(0.0f, -1.0f, 0.0f);
            this.renderFaceUp(tile, 0.0, 0.0, 0.0, tile.getTexture(0, data));
            t.end();
            t.begin();
            t.normal(0.0f, 1.0f, 0.0f);
            this.renderFaceDown(tile, 0.0, 0.0, 0.0, tile.getTexture(1, data));
            t.end();
            t.begin();
            t.normal(0.0f, 0.0f, -1.0f);
            this.renderNorth(tile, 0.0, 0.0, 0.0, tile.getTexture(2, data));
            t.end();
            t.begin();
            t.normal(0.0f, 0.0f, 1.0f);
            this.renderSouth(tile, 0.0, 0.0, 0.0, tile.getTexture(3, data));
            t.end();
            t.begin();
            t.normal(-1.0f, 0.0f, 0.0f);
            this.renderWest(tile, 0.0, 0.0, 0.0, tile.getTexture(4, data));
            t.end();
            t.begin();
            t.normal(1.0f, 0.0f, 0.0f);
            this.renderEast(tile, 0.0, 0.0, 0.0, tile.getTexture(5, data));
            t.end();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (shape == 1) {
            t.begin();
            t.normal(0.0f, -1.0f, 0.0f);
            this.tesselateCrossTexture(tile, data, -0.5, -0.5, -0.5);
            t.end();
        } else if (shape == 13) {
            tile.updateDefaultShape();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float s = 0.0625f;
            t.begin();
            t.normal(0.0f, -1.0f, 0.0f);
            this.renderFaceUp(tile, 0.0, 0.0, 0.0, tile.getTexture(0));
            t.end();
            t.begin();
            t.normal(0.0f, 1.0f, 0.0f);
            this.renderFaceDown(tile, 0.0, 0.0, 0.0, tile.getTexture(1));
            t.end();
            t.begin();
            t.normal(0.0f, 0.0f, -1.0f);
            t.addOffset(0.0f, 0.0f, s);
            this.renderNorth(tile, 0.0, 0.0, 0.0, tile.getTexture(2));
            t.addOffset(0.0f, 0.0f, -s);
            t.end();
            t.begin();
            t.normal(0.0f, 0.0f, 1.0f);
            t.addOffset(0.0f, 0.0f, -s);
            this.renderSouth(tile, 0.0, 0.0, 0.0, tile.getTexture(3));
            t.addOffset(0.0f, 0.0f, s);
            t.end();
            t.begin();
            t.normal(-1.0f, 0.0f, 0.0f);
            t.addOffset(s, 0.0f, 0.0f);
            this.renderWest(tile, 0.0, 0.0, 0.0, tile.getTexture(4));
            t.addOffset(-s, 0.0f, 0.0f);
            t.end();
            t.begin();
            t.normal(1.0f, 0.0f, 0.0f);
            t.addOffset(-s, 0.0f, 0.0f);
            this.renderEast(tile, 0.0, 0.0, 0.0, tile.getTexture(5));
            t.addOffset(s, 0.0f, 0.0f);
            t.end();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (shape == 6) {
            t.begin();
            t.normal(0.0f, -1.0f, 0.0f);
            this.tesselateRowTexture(tile, data, -0.5, -0.5, -0.5);
            t.end();
        } else if (shape == 2) {
            t.begin();
            t.normal(0.0f, -1.0f, 0.0f);
            this.tesselateTorch(tile, -0.5, -0.5, -0.5, 0.0, 0.0);
            t.end();
        } else if (shape == 10) {
            int i = 0;
            while (i < 2) {
                if (i == 0) {
                    tile.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                }
                if (i == 1) {
                    tile.setShape(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                t.begin();
                t.normal(0.0f, -1.0f, 0.0f);
                this.renderFaceUp(tile, 0.0, 0.0, 0.0, tile.getTexture(0));
                t.end();
                t.begin();
                t.normal(0.0f, 1.0f, 0.0f);
                this.renderFaceDown(tile, 0.0, 0.0, 0.0, tile.getTexture(1));
                t.end();
                t.begin();
                t.normal(0.0f, 0.0f, -1.0f);
                this.renderNorth(tile, 0.0, 0.0, 0.0, tile.getTexture(2));
                t.end();
                t.begin();
                t.normal(0.0f, 0.0f, 1.0f);
                this.renderSouth(tile, 0.0, 0.0, 0.0, tile.getTexture(3));
                t.end();
                t.begin();
                t.normal(-1.0f, 0.0f, 0.0f);
                this.renderWest(tile, 0.0, 0.0, 0.0, tile.getTexture(4));
                t.end();
                t.begin();
                t.normal(1.0f, 0.0f, 0.0f);
                this.renderEast(tile, 0.0, 0.0, 0.0, tile.getTexture(5));
                t.end();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                ++i;
            }
        } else if (shape == 11) {
            int i = 0;
            while (i < 4) {
                float w = 0.125f;
                if (i == 0) {
                    tile.setShape(0.5f - w, 0.0f, 0.0f, 0.5f + w, 1.0f, w * 2.0f);
                }
                if (i == 1) {
                    tile.setShape(0.5f - w, 0.0f, 1.0f - w * 2.0f, 0.5f + w, 1.0f, 1.0f);
                }
                w = 0.0625f;
                if (i == 2) {
                    tile.setShape(0.5f - w, 1.0f - w * 3.0f, -w * 2.0f, 0.5f + w, 1.0f - w, 1.0f + w * 2.0f);
                }
                if (i == 3) {
                    tile.setShape(0.5f - w, 0.5f - w * 3.0f, -w * 2.0f, 0.5f + w, 0.5f - w, 1.0f + w * 2.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                t.begin();
                t.normal(0.0f, -1.0f, 0.0f);
                this.renderFaceUp(tile, 0.0, 0.0, 0.0, tile.getTexture(0));
                t.end();
                t.begin();
                t.normal(0.0f, 1.0f, 0.0f);
                this.renderFaceDown(tile, 0.0, 0.0, 0.0, tile.getTexture(1));
                t.end();
                t.begin();
                t.normal(0.0f, 0.0f, -1.0f);
                this.renderNorth(tile, 0.0, 0.0, 0.0, tile.getTexture(2));
                t.end();
                t.begin();
                t.normal(0.0f, 0.0f, 1.0f);
                this.renderSouth(tile, 0.0, 0.0, 0.0, tile.getTexture(3));
                t.end();
                t.begin();
                t.normal(-1.0f, 0.0f, 0.0f);
                this.renderWest(tile, 0.0, 0.0, 0.0, tile.getTexture(4));
                t.end();
                t.begin();
                t.normal(1.0f, 0.0f, 0.0f);
                this.renderEast(tile, 0.0, 0.0, 0.0, tile.getTexture(5));
                t.end();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                ++i;
            }
            tile.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static boolean canRender(int renderShape) {
        if (renderShape == 0) {
            return true;
        }
        if (renderShape == 13) {
            return true;
        }
        if (renderShape == 10) {
            return true;
        }
        return renderShape == 11;
    }
}

