/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.MemoryTracker;
import net.minecraft.client.Options;
import net.minecraft.client.renderer.HttpTexture;
import net.minecraft.client.renderer.HttpTextureProcessor;
import net.minecraft.client.renderer.ptexture.DynamicTexture;
import net.minecraft.client.skins.TexturePack;
import net.minecraft.client.skins.TexturePackRepository;
import org.lwjgl.opengl.GL11;

public class Textures {
    public static boolean MIPMAP = false;
    private HashMap<String, Integer> idMap = new HashMap();
    private HashMap<Integer, BufferedImage> loadedImages = new HashMap();
    private IntBuffer ib = MemoryTracker.createIntBuffer(1);
    private ByteBuffer pixels = MemoryTracker.createByteBuffer(0x100000);
    private List<DynamicTexture> dynamicTextures = new ArrayList<DynamicTexture>();
    private Map<String, HttpTexture> httpTextures = new HashMap<String, HttpTexture>();
    private Options options;
    private boolean clamp = false;
    private boolean blur = false;
    private TexturePackRepository skins;

    public Textures(TexturePackRepository skins, Options options) {
        this.skins = skins;
        this.options = options;
    }

    public int loadTexture(String resourceName) {
        TexturePack skin = this.skins.selected;
        Integer id = this.idMap.get(resourceName);
        if (id != null) {
            return id;
        }
        try {
            this.ib.clear();
            MemoryTracker.genTextures(this.ib);
            int id2 = this.ib.get(0);
            if (resourceName.startsWith("##")) {
                this.loadTexture(this.makeStrip(this.readImage(skin.getResource(resourceName.substring(2)))), id2);
            } else if (resourceName.startsWith("%clamp%")) {
                this.clamp = true;
                this.loadTexture(this.readImage(skin.getResource(resourceName.substring(7))), id2);
                this.clamp = false;
            } else if (resourceName.startsWith("%blur%")) {
                this.blur = true;
                this.loadTexture(this.readImage(skin.getResource(resourceName.substring(6))), id2);
                this.blur = false;
            } else {
                this.loadTexture(this.readImage(skin.getResource(resourceName)), id2);
            }
            this.idMap.put(resourceName, id2);
            return id2;
        }
        catch (IOException e) {
            throw new RuntimeException("!!");
        }
    }

    private BufferedImage makeStrip(BufferedImage source) {
        int cols = source.getWidth() / 16;
        BufferedImage out = new BufferedImage(16, source.getHeight() * cols, 2);
        Graphics g = out.getGraphics();
        int i = 0;
        while (i < cols) {
            g.drawImage(source, -i * 16, i * source.getHeight(), null);
            ++i;
        }
        g.dispose();
        return out;
    }

    public int getTexture(BufferedImage img) {
        this.ib.clear();
        MemoryTracker.genTextures(this.ib);
        int id = this.ib.get(0);
        this.loadTexture(img, id);
        this.loadedImages.put(id, img);
        return id;
    }

    public void loadTexture(BufferedImage img, int id) {
        GL11.glBindTexture((int)3553, (int)id);
        if (MIPMAP) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.blur) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (this.clamp) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int w = img.getWidth();
        int h = img.getHeight();
        int[] rawPixels = new int[w * h];
        byte[] newPixels = new byte[w * h * 4];
        img.getRGB(0, 0, w, h, rawPixels, 0, w);
        int i = 0;
        while (i < rawPixels.length) {
            int a = rawPixels[i] >> 24 & 0xFF;
            int r = rawPixels[i] >> 16 & 0xFF;
            int g = rawPixels[i] >> 8 & 0xFF;
            int b = rawPixels[i] & 0xFF;
            if (this.options != null && this.options.anaglyph3d) {
                int rr = (r * 30 + g * 59 + b * 11) / 100;
                int gg = (r * 30 + g * 70) / 100;
                int bb = (r * 30 + b * 70) / 100;
                r = rr;
                g = gg;
                b = bb;
            }
            newPixels[i * 4 + 0] = (byte)r;
            newPixels[i * 4 + 1] = (byte)g;
            newPixels[i * 4 + 2] = (byte)b;
            newPixels[i * 4 + 3] = (byte)a;
            ++i;
        }
        this.pixels.clear();
        this.pixels.put(newPixels);
        this.pixels.position(0).limit(newPixels.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w, (int)h, (int)0, (int)6408, (int)5121, (ByteBuffer)this.pixels);
        if (MIPMAP) {
            int level = 1;
            while (level <= 4) {
                int ow = w >> level - 1;
                int ww = w >> level;
                int hh = h >> level;
                int x = 0;
                while (x < ww) {
                    int y = 0;
                    while (y < hh) {
                        int c0 = this.pixels.getInt((x * 2 + 0 + (y * 2 + 0) * ow) * 4);
                        int c1 = this.pixels.getInt((x * 2 + 1 + (y * 2 + 0) * ow) * 4);
                        int c2 = this.pixels.getInt((x * 2 + 1 + (y * 2 + 1) * ow) * 4);
                        int c3 = this.pixels.getInt((x * 2 + 0 + (y * 2 + 1) * ow) * 4);
                        int col = this.crispBlend(this.crispBlend(c0, c1), this.crispBlend(c2, c3));
                        this.pixels.putInt((x + y * ww) * 4, col);
                        ++y;
                    }
                    ++x;
                }
                GL11.glTexImage2D((int)3553, (int)level, (int)6408, (int)ww, (int)hh, (int)0, (int)6408, (int)5121, (ByteBuffer)this.pixels);
                ++level;
            }
        }
    }

    public void releaseTexture(int id) {
        this.loadedImages.remove(id);
        this.ib.clear();
        this.ib.put(id);
        this.ib.flip();
        GL11.glDeleteTextures((IntBuffer)this.ib);
    }

    public int loadHttpTexture(String url, String backup) {
        HttpTexture texture = this.httpTextures.get(url);
        if (texture != null && texture.loadedImage != null && !texture.isLoaded) {
            if (texture.id < 0) {
                texture.id = this.getTexture(texture.loadedImage);
            } else {
                this.loadTexture(texture.loadedImage, texture.id);
            }
            texture.isLoaded = true;
        }
        if (texture == null || texture.id < 0) {
            if (backup == null) {
                return -1;
            }
            return this.loadTexture(backup);
        }
        return texture.id;
    }

    public HttpTexture addHttpTexture(String url, HttpTextureProcessor processor) {
        HttpTexture texture = this.httpTextures.get(url);
        if (texture == null) {
            this.httpTextures.put(url, new HttpTexture(url, processor));
        } else {
            ++texture.count;
        }
        return texture;
    }

    public void removeHttpTexture(String url) {
        HttpTexture texture = this.httpTextures.get(url);
        if (texture != null) {
            --texture.count;
            if (texture.count == 0) {
                if (texture.id >= 0) {
                    this.releaseTexture(texture.id);
                }
                this.httpTextures.remove(url);
            }
        }
    }

    public void addDynamicTexture(DynamicTexture dynamicTexture) {
        this.dynamicTextures.add(dynamicTexture);
        dynamicTexture.tick();
    }

    public void tick() {
        DynamicTexture dynamicTexture;
        int i = 0;
        while (i < this.dynamicTextures.size()) {
            dynamicTexture = this.dynamicTextures.get(i);
            dynamicTexture.anaglyph3d = this.options.anaglyph3d;
            dynamicTexture.tick();
            this.pixels.clear();
            this.pixels.put(dynamicTexture.pixels);
            this.pixels.position(0).limit(dynamicTexture.pixels.length);
            dynamicTexture.bindTexture(this);
            int xx = 0;
            while (xx < dynamicTexture.replicate) {
                int yy = 0;
                while (yy < dynamicTexture.replicate) {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)(dynamicTexture.tex % 16 * 16 + xx * 16), (int)(dynamicTexture.tex / 16 * 16 + yy * 16), (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.pixels);
                    if (MIPMAP) {
                        int level = 1;
                        while (level <= 4) {
                            int os = 16 >> level - 1;
                            int s = 16 >> level;
                            int x = 0;
                            while (x < s) {
                                int y = 0;
                                while (y < s) {
                                    int c0 = this.pixels.getInt((x * 2 + 0 + (y * 2 + 0) * os) * 4);
                                    int c1 = this.pixels.getInt((x * 2 + 1 + (y * 2 + 0) * os) * 4);
                                    int c2 = this.pixels.getInt((x * 2 + 1 + (y * 2 + 1) * os) * 4);
                                    int c3 = this.pixels.getInt((x * 2 + 0 + (y * 2 + 1) * os) * 4);
                                    int col = this.smoothBlend(this.smoothBlend(c0, c1), this.smoothBlend(c2, c3));
                                    this.pixels.putInt((x + y * s) * 4, col);
                                    ++y;
                                }
                                ++x;
                            }
                            GL11.glTexSubImage2D((int)3553, (int)level, (int)(dynamicTexture.tex % 16 * s), (int)(dynamicTexture.tex / 16 * s), (int)s, (int)s, (int)6408, (int)5121, (ByteBuffer)this.pixels);
                            ++level;
                        }
                    }
                    ++yy;
                }
                ++xx;
            }
            ++i;
        }
        i = 0;
        while (i < this.dynamicTextures.size()) {
            dynamicTexture = this.dynamicTextures.get(i);
            if (dynamicTexture.copyTo > 0) {
                this.pixels.clear();
                this.pixels.put(dynamicTexture.pixels);
                this.pixels.position(0).limit(dynamicTexture.pixels.length);
                GL11.glBindTexture((int)3553, (int)dynamicTexture.copyTo);
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.pixels);
                if (MIPMAP) {
                    int level = 1;
                    while (level <= 4) {
                        int os = 16 >> level - 1;
                        int s = 16 >> level;
                        int x = 0;
                        while (x < s) {
                            int y = 0;
                            while (y < s) {
                                int c0 = this.pixels.getInt((x * 2 + 0 + (y * 2 + 0) * os) * 4);
                                int c1 = this.pixels.getInt((x * 2 + 1 + (y * 2 + 0) * os) * 4);
                                int c2 = this.pixels.getInt((x * 2 + 1 + (y * 2 + 1) * os) * 4);
                                int c3 = this.pixels.getInt((x * 2 + 0 + (y * 2 + 1) * os) * 4);
                                int col = this.smoothBlend(this.smoothBlend(c0, c1), this.smoothBlend(c2, c3));
                                this.pixels.putInt((x + y * s) * 4, col);
                                ++y;
                            }
                            ++x;
                        }
                        GL11.glTexSubImage2D((int)3553, (int)level, (int)0, (int)0, (int)s, (int)s, (int)6408, (int)5121, (ByteBuffer)this.pixels);
                        ++level;
                    }
                }
            }
            ++i;
        }
    }

    private int smoothBlend(int c0, int c1) {
        int a0 = (c0 & 0xFF000000) >> 24 & 0xFF;
        int a1 = (c1 & 0xFF000000) >> 24 & 0xFF;
        return (a0 + a1 >> 1 << 24) + ((c0 & 0xFEFEFE) + (c1 & 0xFEFEFE) >> 1);
    }

    private int crispBlend(int c0, int c1) {
        int a0 = (c0 & 0xFF000000) >> 24 & 0xFF;
        int a1 = (c1 & 0xFF000000) >> 24 & 0xFF;
        int a = 255;
        if (a0 + a1 == 0) {
            a0 = 1;
            a1 = 1;
            a = 0;
        }
        int r0 = (c0 >> 16 & 0xFF) * a0;
        int g0 = (c0 >> 8 & 0xFF) * a0;
        int b0 = (c0 & 0xFF) * a0;
        int r1 = (c1 >> 16 & 0xFF) * a1;
        int g1 = (c1 >> 8 & 0xFF) * a1;
        int b1 = (c1 & 0xFF) * a1;
        int r = (r0 + r1) / (a0 + a1);
        int g = (g0 + g1) / (a0 + a1);
        int b = (b0 + b1) / (a0 + a1);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public void reloadAll() {
        BufferedImage image;
        TexturePack skin = this.skins.selected;
        Iterator<Object> iterator = this.loadedImages.keySet().iterator();
        while (iterator.hasNext()) {
            int id = iterator.next();
            image = this.loadedImages.get(id);
            this.loadTexture(image, id);
        }
        for (HttpTexture httpTexture : this.httpTextures.values()) {
            httpTexture.isLoaded = false;
        }
        for (String name : this.idMap.keySet()) {
            try {
                if (name.startsWith("##")) {
                    image = this.makeStrip(this.readImage(skin.getResource(name.substring(2))));
                } else if (name.startsWith("%clamp%")) {
                    this.clamp = true;
                    image = this.readImage(skin.getResource(name.substring(7)));
                } else if (name.startsWith("%blur%")) {
                    this.blur = true;
                    image = this.readImage(skin.getResource(name.substring(6)));
                } else {
                    image = this.readImage(skin.getResource(name));
                }
                int id = this.idMap.get(name);
                this.loadTexture(image, id);
                this.blur = false;
                this.clamp = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private BufferedImage readImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public void bind(int id) {
        if (id < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)id);
    }
}

