/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.minecraft.client.renderer.HttpTextureProcessor;

public class MobSkinTextureProcessor
implements HttpTextureProcessor {
    private int[] pixels;
    private int width;
    private int height;

    @Override
    public BufferedImage process(BufferedImage in) {
        int pix;
        int y;
        if (in == null) {
            return null;
        }
        this.width = 64;
        this.height = 32;
        BufferedImage out = new BufferedImage(this.width, this.height, 2);
        Graphics g = out.getGraphics();
        g.drawImage(in, 0, 0, null);
        g.dispose();
        this.pixels = ((DataBufferInt)out.getRaster().getDataBuffer()).getData();
        this.setNoAlpha(0, 0, 32, 16);
        this.setForceAlpha(32, 0, 64, 32);
        this.setNoAlpha(0, 16, 64, 32);
        boolean hasAlpha = false;
        int x = 32;
        while (x < 64) {
            y = 0;
            while (y < 16) {
                pix = this.pixels[x + y * 64];
                if ((pix >> 24 & 0xFF) < 128) {
                    hasAlpha = true;
                }
                ++y;
            }
            ++x;
        }
        if (!hasAlpha) {
            x = 32;
            while (x < 64) {
                y = 0;
                while (y < 16) {
                    pix = this.pixels[x + y * 64];
                    if ((pix >> 24 & 0xFF) < 128) {
                        hasAlpha = true;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return out;
    }

    private void setForceAlpha(int x0, int y0, int x1, int y1) {
        if (this.hasAlpha(x0, y0, x1, y1)) {
            return;
        }
        int x = x0;
        while (x < x1) {
            int y = y0;
            while (y < y1) {
                int n = x + y * this.width;
                this.pixels[n] = this.pixels[n] & 0xFFFFFF;
                ++y;
            }
            ++x;
        }
    }

    private void setNoAlpha(int x0, int y0, int x1, int y1) {
        int x = x0;
        while (x < x1) {
            int y = y0;
            while (y < y1) {
                int n = x + y * this.width;
                this.pixels[n] = this.pixels[n] | 0xFF000000;
                ++y;
            }
            ++x;
        }
    }

    private boolean hasAlpha(int x0, int y0, int x1, int y1) {
        int x = x0;
        while (x < x1) {
            int y = y0;
            while (y < y1) {
                int pix = this.pixels[x + y * this.width];
                if ((pix >> 24 & 0xFF) < 128) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }
}

