/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.MemoryTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.ExplodeParticle;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.LavaParticle;
import net.minecraft.client.particle.NoteParticle;
import net.minecraft.client.particle.PortalParticle;
import net.minecraft.client.particle.RedDustParticle;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Chunk;
import net.minecraft.client.renderer.DirtyChunkSorter;
import net.minecraft.client.renderer.DistanceChunkSorter;
import net.minecraft.client.renderer.MobSkinTextureProcessor;
import net.minecraft.client.renderer.OffsettedRenderList;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.Textures;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.culling.Culler;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelListener;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.TileEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class LevelRenderer
implements LevelListener {
    public static final int CHUNK_SIZE = 16;
    public static final int MAX_VISIBLE_REBUILDS_PER_FRAME = 3;
    public static final int MAX_INVISIBLE_REBUILDS_PER_FRAME = 1;
    public List<TileEntity> renderableTileEntities = new ArrayList<TileEntity>();
    private Level level;
    private Textures textures;
    private List<Chunk> dirtyChunks = new ArrayList<Chunk>();
    private Chunk[] sortedChunks;
    private Chunk[] chunks;
    private int xChunks;
    private int yChunks;
    private int zChunks;
    private int chunkLists;
    private Minecraft mc;
    private TileRenderer tileRenderer;
    private IntBuffer occlusionCheckIds;
    private boolean occlusionCheck = false;
    private int ticks = 0;
    private int starList;
    private int skyList;
    private int darkList;
    private int xMinChunk;
    private int yMinChunk;
    private int zMinChunk;
    private int xMaxChunk;
    private int yMaxChunk;
    private int zMaxChunk;
    private int lastViewDistance = -1;
    private int noEntityRenderFrames = 2;
    private int totalEntities;
    private int renderedEntities;
    private int culledEntities;
    int[] toRender = new int[50000];
    IntBuffer resultBuffer = MemoryTracker.createIntBuffer(64);
    private int totalChunks;
    private int offscreenChunks;
    private int occludedChunks;
    private int renderedChunks;
    private int emptyChunks;
    private int chunkFixOffs;
    private List<Chunk> renderChunks = new ArrayList<Chunk>();
    private OffsettedRenderList[] renderLists = new OffsettedRenderList[]{new OffsettedRenderList(), new OffsettedRenderList(), new OffsettedRenderList(), new OffsettedRenderList()};
    int frame = 0;
    int repeatList = MemoryTracker.genLists(1);
    double xOld = -9999.0;
    double yOld = -9999.0;
    double zOld = -9999.0;
    public float destroyProgress;
    int cullStep = 0;

    public LevelRenderer(Minecraft mc, Textures textures) {
        int zz;
        this.mc = mc;
        this.textures = textures;
        int maxChunksWidth = 64;
        this.chunkLists = MemoryTracker.genLists(maxChunksWidth * maxChunksWidth * maxChunksWidth * 3);
        this.occlusionCheck = mc.getOpenGLCapabilities().hasOcclusionChecks();
        if (this.occlusionCheck) {
            this.resultBuffer.clear();
            this.occlusionCheckIds = MemoryTracker.createIntBuffer(maxChunksWidth * maxChunksWidth * maxChunksWidth);
            this.occlusionCheckIds.clear();
            this.occlusionCheckIds.position(0);
            this.occlusionCheckIds.limit(maxChunksWidth * maxChunksWidth * maxChunksWidth);
            ARBOcclusionQuery.glGenQueriesARB((IntBuffer)this.occlusionCheckIds);
        }
        this.starList = MemoryTracker.genLists(3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tesselator t = Tesselator.instance;
        this.skyList = this.starList + 1;
        GL11.glNewList((int)this.skyList, (int)4864);
        int s = 64;
        int d = 256 / s + 2;
        float yy = 16.0f;
        int xx = -s * d;
        while (xx <= s * d) {
            zz = -s * d;
            while (zz <= s * d) {
                t.begin();
                t.vertex(xx + 0, yy, zz + 0);
                t.vertex(xx + s, yy, zz + 0);
                t.vertex(xx + s, yy, zz + s);
                t.vertex(xx + 0, yy, zz + s);
                t.end();
                zz += s;
            }
            xx += s;
        }
        GL11.glEndList();
        this.darkList = this.starList + 2;
        GL11.glNewList((int)this.darkList, (int)4864);
        yy = -16.0f;
        t.begin();
        xx = -s * d;
        while (xx <= s * d) {
            zz = -s * d;
            while (zz <= s * d) {
                t.vertex(xx + s, yy, zz + 0);
                t.vertex(xx + 0, yy, zz + 0);
                t.vertex(xx + 0, yy, zz + s);
                t.vertex(xx + s, yy, zz + s);
                zz += s;
            }
            xx += s;
        }
        t.end();
        GL11.glEndList();
    }

    private void renderStars() {
        Random random = new Random(10842L);
        Tesselator t = Tesselator.instance;
        t.begin();
        int i = 0;
        while (i < 1500) {
            double x = random.nextFloat() * 2.0f - 1.0f;
            double y = random.nextFloat() * 2.0f - 1.0f;
            double z = random.nextFloat() * 2.0f - 1.0f;
            double ss = 0.25f + random.nextFloat() * 0.25f;
            double d = x * x + y * y + z * z;
            if (d < 1.0 && d > 0.01) {
                d = 1.0 / Math.sqrt(d);
                double xp = (x *= d) * 100.0;
                double yp = (y *= d) * 100.0;
                double zp = (z *= d) * 100.0;
                double yRot = Math.atan2(x, z);
                double ySin = Math.sin(yRot);
                double yCos = Math.cos(yRot);
                double xRot = Math.atan2(Math.sqrt(x * x + z * z), y);
                double xSin = Math.sin(xRot);
                double xCos = Math.cos(xRot);
                double zRot = random.nextDouble() * Math.PI * 2.0;
                double zSin = Math.sin(zRot);
                double zCos = Math.cos(zRot);
                int c = 0;
                while (c < 4) {
                    double __zo;
                    double ___xo = 0.0;
                    double ___yo = (double)((c & 2) - 1) * ss;
                    double ___zo = (double)((c + 1 & 2) - 1) * ss;
                    double __xo = ___xo;
                    double __yo = ___yo * zCos - ___zo * zSin;
                    double _zo = __zo = ___zo * zCos + ___yo * zSin;
                    double _yo = __yo * xSin + __xo * xCos;
                    double _xo = __xo * xSin - __yo * xCos;
                    double xo = _xo * ySin - _zo * yCos;
                    double yo = _yo;
                    double zo = _zo * ySin + _xo * yCos;
                    t.vertex(xp + xo, yp + yo, zp + zo);
                    ++c;
                }
            }
            ++i;
        }
        t.end();
    }

    public void setLevel(Level level) {
        if (this.level != null) {
            this.level.removeListener(this);
        }
        this.xOld = -9999.0;
        this.yOld = -9999.0;
        this.zOld = -9999.0;
        EntityRenderDispatcher.instance.setLevel(level);
        this.level = level;
        this.tileRenderer = new TileRenderer(level);
        if (level != null) {
            level.addListener(this);
            this.allChanged();
        }
    }

    @Override
    public void allChanged() {
        LocalPlayer player;
        int dist;
        Tile.leaves.setFancy(this.mc.options.fancyGraphics);
        this.lastViewDistance = this.mc.options.viewDistance;
        if (this.chunks != null) {
            int i = 0;
            while (i < this.chunks.length) {
                this.chunks[i].delete();
                ++i;
            }
        }
        if ((dist = 64 << 3 - this.lastViewDistance) > 400) {
            dist = 400;
        }
        this.xChunks = dist / 16 + 1;
        this.yChunks = 8;
        this.zChunks = dist / 16 + 1;
        this.chunks = new Chunk[this.xChunks * this.yChunks * this.zChunks];
        this.sortedChunks = new Chunk[this.xChunks * this.yChunks * this.zChunks];
        int id = 0;
        int count = 0;
        this.xMinChunk = 0;
        this.yMinChunk = 0;
        this.zMinChunk = 0;
        this.xMaxChunk = this.xChunks;
        this.yMaxChunk = this.yChunks;
        this.zMaxChunk = this.zChunks;
        int i = 0;
        while (i < this.dirtyChunks.size()) {
            this.dirtyChunks.get((int)i).dirty = false;
            ++i;
        }
        this.dirtyChunks.clear();
        this.renderableTileEntities.clear();
        int x = 0;
        while (x < this.xChunks) {
            int y = 0;
            while (y < this.yChunks) {
                int z = 0;
                while (z < this.zChunks) {
                    this.chunks[(z * this.yChunks + y) * this.xChunks + x] = new Chunk(this.level, this.renderableTileEntities, x * 16, y * 16, z * 16, 16, this.chunkLists + id);
                    if (this.occlusionCheck) {
                        this.chunks[(z * this.yChunks + y) * this.xChunks + x].occlusion_id = this.occlusionCheckIds.get(count);
                    }
                    this.chunks[(z * this.yChunks + y) * this.xChunks + x].occlusion_querying = false;
                    this.chunks[(z * this.yChunks + y) * this.xChunks + x].occlusion_visible = true;
                    this.chunks[(z * this.yChunks + y) * this.xChunks + x].visible = true;
                    this.chunks[(z * this.yChunks + y) * this.xChunks + x].id = count++;
                    this.chunks[(z * this.yChunks + y) * this.xChunks + x].setDirty();
                    this.sortedChunks[(z * this.yChunks + y) * this.xChunks + x] = this.chunks[(z * this.yChunks + y) * this.xChunks + x];
                    this.dirtyChunks.add(this.chunks[(z * this.yChunks + y) * this.xChunks + x]);
                    id += 3;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (this.level != null && (player = this.mc.player) != null) {
            this.resortChunks(Mth.floor(player.x), Mth.floor(player.y), Mth.floor(player.z));
            Arrays.sort(this.sortedChunks, new DistanceChunkSorter(player));
        }
        this.noEntityRenderFrames = 2;
    }

    public void renderEntities(Vec3 cam, Culler culler, float a) {
        if (this.noEntityRenderFrames > 0) {
            --this.noEntityRenderFrames;
            return;
        }
        TileEntityRenderDispatcher.instance.prepare(this.level, this.textures, this.mc.font, this.mc.player, a);
        EntityRenderDispatcher.instance.prepare(this.level, this.textures, this.mc.font, this.mc.player, this.mc.options, a);
        this.totalEntities = 0;
        this.renderedEntities = 0;
        this.culledEntities = 0;
        LocalPlayer player = this.mc.player;
        EntityRenderDispatcher.xOff = player.xOld + (player.x - player.xOld) * (double)a;
        EntityRenderDispatcher.yOff = player.yOld + (player.y - player.yOld) * (double)a;
        EntityRenderDispatcher.zOff = player.zOld + (player.z - player.zOld) * (double)a;
        TileEntityRenderDispatcher.xOff = player.xOld + (player.x - player.xOld) * (double)a;
        TileEntityRenderDispatcher.yOff = player.yOld + (player.y - player.yOld) * (double)a;
        TileEntityRenderDispatcher.zOff = player.zOld + (player.z - player.zOld) * (double)a;
        List<Entity> entities = this.level.getAllEntities();
        this.totalEntities = entities.size();
        int i = 0;
        while (i < entities.size()) {
            Entity entity = entities.get(i);
            if (entity.shouldRender(cam) && culler.isVisible(entity.bb) && (entity != this.mc.player || this.mc.options.thirdPersonView) && this.level.hasChunkAt(Mth.floor(entity.x), Mth.floor(entity.y), Mth.floor(entity.z))) {
                ++this.renderedEntities;
                EntityRenderDispatcher.instance.render(entity, a);
            }
            ++i;
        }
        i = 0;
        while (i < this.renderableTileEntities.size()) {
            TileEntityRenderDispatcher.instance.render(this.renderableTileEntities.get(i), a);
            ++i;
        }
    }

    public String gatherStats1() {
        return "C: " + this.renderedChunks + "/" + this.totalChunks + ". F: " + this.offscreenChunks + ", O: " + this.occludedChunks + ", E: " + this.emptyChunks;
    }

    public String gatherStats2() {
        return "E: " + this.renderedEntities + "/" + this.totalEntities + ". B: " + this.culledEntities + ", I: " + (this.totalEntities - this.culledEntities - this.renderedEntities);
    }

    private void resortChunks(int xc, int yc, int zc) {
        xc -= 8;
        yc -= 8;
        zc -= 8;
        this.xMinChunk = Integer.MAX_VALUE;
        this.yMinChunk = Integer.MAX_VALUE;
        this.zMinChunk = Integer.MAX_VALUE;
        this.xMaxChunk = Integer.MIN_VALUE;
        this.yMaxChunk = Integer.MIN_VALUE;
        this.zMaxChunk = Integer.MIN_VALUE;
        int s2 = this.xChunks * 16;
        int s1 = s2 / 2;
        int x = 0;
        while (x < this.xChunks) {
            int xx = x * 16;
            int xOff = xx + s1 - xc;
            if (xOff < 0) {
                xOff -= s2 - 1;
            }
            if ((xx -= (xOff /= s2) * s2) < this.xMinChunk) {
                this.xMinChunk = xx;
            }
            if (xx > this.xMaxChunk) {
                this.xMaxChunk = xx;
            }
            int z = 0;
            while (z < this.zChunks) {
                int zz = z * 16;
                int zOff = zz + s1 - zc;
                if (zOff < 0) {
                    zOff -= s2 - 1;
                }
                if ((zz -= (zOff /= s2) * s2) < this.zMinChunk) {
                    this.zMinChunk = zz;
                }
                if (zz > this.zMaxChunk) {
                    this.zMaxChunk = zz;
                }
                int y = 0;
                while (y < this.yChunks) {
                    int yy = y * 16;
                    if (yy < this.yMinChunk) {
                        this.yMinChunk = yy;
                    }
                    if (yy > this.yMaxChunk) {
                        this.yMaxChunk = yy;
                    }
                    Chunk chunk = this.chunks[(z * this.yChunks + y) * this.xChunks + x];
                    boolean wasDirty = chunk.dirty;
                    chunk.setPos(xx, yy, zz);
                    if (!wasDirty && chunk.dirty) {
                        this.dirtyChunks.add(chunk);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    public int render(Player player, int layer, double alpha) {
        int i = 0;
        while (i < 10) {
            this.chunkFixOffs = (this.chunkFixOffs + 1) % this.chunks.length;
            Chunk c = this.chunks[this.chunkFixOffs];
            if (c.dirty && !this.dirtyChunks.contains(c)) {
                this.dirtyChunks.add(c);
            }
            ++i;
        }
        if (this.mc.options.viewDistance != this.lastViewDistance) {
            this.allChanged();
        }
        if (layer == 0) {
            this.totalChunks = 0;
            this.offscreenChunks = 0;
            this.occludedChunks = 0;
            this.renderedChunks = 0;
            this.emptyChunks = 0;
        }
        double xOff = player.xOld + (player.x - player.xOld) * alpha;
        double yOff = player.yOld + (player.y - player.yOld) * alpha;
        double zOff = player.zOld + (player.z - player.zOld) * alpha;
        double xd = player.x - this.xOld;
        double yd = player.y - this.yOld;
        double zd = player.z - this.zOld;
        if (xd * xd + yd * yd + zd * zd > 16.0) {
            this.xOld = player.x;
            this.yOld = player.y;
            this.zOld = player.z;
            this.resortChunks(Mth.floor(player.x), Mth.floor(player.y), Mth.floor(player.z));
            Arrays.sort(this.sortedChunks, new DistanceChunkSorter(player));
        }
        int count = 0;
        if (this.occlusionCheck && !this.mc.options.anaglyph3d && layer == 0) {
            int from = 0;
            int to = 16;
            this.checkQueryResults(from, to);
            int i2 = from;
            while (i2 < to) {
                this.sortedChunks[i2].occlusion_visible = true;
                ++i2;
            }
            count += this.renderChunks(from, to, layer, alpha);
            do {
                from = to;
                if ((to *= 2) > this.sortedChunks.length) {
                    to = this.sortedChunks.length;
                }
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2912);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glDepthMask((boolean)false);
                this.checkQueryResults(from, to);
                GL11.glPushMatrix();
                float xo = 0.0f;
                float yo = 0.0f;
                float zo = 0.0f;
                int i3 = from;
                while (i3 < to) {
                    if (this.sortedChunks[i3].isEmpty()) {
                        this.sortedChunks[i3].visible = false;
                    } else {
                        float dist;
                        int frequency;
                        if (!this.sortedChunks[i3].visible) {
                            this.sortedChunks[i3].occlusion_visible = true;
                        }
                        if (this.sortedChunks[i3].visible && !this.sortedChunks[i3].occlusion_querying && this.ticks % (frequency = (int)(1.0f + (dist = Mth.sqrt(this.sortedChunks[i3].distanceToSqr(player))) / 128.0f)) == i3 % frequency) {
                            Chunk chunk = this.sortedChunks[i3];
                            float xt = (float)((double)chunk.xRender - xOff);
                            float yt = (float)((double)chunk.yRender - yOff);
                            float zt = (float)((double)chunk.zRender - zOff);
                            float xdd = xt - xo;
                            float ydd = yt - yo;
                            float zdd = zt - zo;
                            if (xdd != 0.0f || ydd != 0.0f || zdd != 0.0f) {
                                GL11.glTranslatef((float)xdd, (float)ydd, (float)zdd);
                                xo += xdd;
                                yo += ydd;
                                zo += zdd;
                            }
                            ARBOcclusionQuery.glBeginQueryARB((int)35092, (int)this.sortedChunks[i3].occlusion_id);
                            this.sortedChunks[i3].renderBB();
                            ARBOcclusionQuery.glEndQueryARB((int)35092);
                            this.sortedChunks[i3].occlusion_querying = true;
                        }
                    }
                    ++i3;
                }
                GL11.glPopMatrix();
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2912);
                count += this.renderChunks(from, to, layer, alpha);
            } while (to < this.sortedChunks.length);
        } else {
            count += this.renderChunks(0, this.sortedChunks.length, layer, alpha);
        }
        return count;
    }

    private void checkQueryResults(int from, int to) {
        int i = from;
        while (i < to) {
            if (this.sortedChunks[i].occlusion_querying) {
                this.resultBuffer.clear();
                ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedChunks[i].occlusion_id, (int)34919, (IntBuffer)this.resultBuffer);
                if (this.resultBuffer.get(0) != 0) {
                    this.sortedChunks[i].occlusion_querying = false;
                    this.resultBuffer.clear();
                    ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedChunks[i].occlusion_id, (int)34918, (IntBuffer)this.resultBuffer);
                    this.sortedChunks[i].occlusion_visible = this.resultBuffer.get(0) != 0;
                }
            }
            ++i;
        }
    }

    private int renderChunks(int from, int to, int layer, double alpha) {
        this.renderChunks.clear();
        int count = 0;
        int i = from;
        while (i < to) {
            int list;
            if (layer == 0) {
                ++this.totalChunks;
                if (this.sortedChunks[i].empty[layer]) {
                    ++this.emptyChunks;
                } else if (!this.sortedChunks[i].visible) {
                    ++this.offscreenChunks;
                } else if (this.occlusionCheck && !this.sortedChunks[i].occlusion_visible) {
                    ++this.occludedChunks;
                } else {
                    ++this.renderedChunks;
                }
            }
            if (!this.sortedChunks[i].empty[layer] && this.sortedChunks[i].visible && this.sortedChunks[i].occlusion_visible && (list = this.sortedChunks[i].getList(layer)) >= 0) {
                this.renderChunks.add(this.sortedChunks[i]);
                ++count;
            }
            ++i;
        }
        LocalPlayer player = this.mc.player;
        double xOff = player.xOld + (player.x - player.xOld) * alpha;
        double yOff = player.yOld + (player.y - player.yOld) * alpha;
        double zOff = player.zOld + (player.z - player.zOld) * alpha;
        int lists = 0;
        int l = 0;
        while (l < this.renderLists.length) {
            this.renderLists[l].clear();
            ++l;
        }
        int i2 = 0;
        while (i2 < this.renderChunks.size()) {
            Chunk chunk = this.renderChunks.get(i2);
            int list = -1;
            int l2 = 0;
            while (l2 < lists) {
                if (this.renderLists[l2].isAt(chunk.xRender, chunk.yRender, chunk.zRender)) {
                    list = l2;
                }
                ++l2;
            }
            if (list < 0) {
                list = lists++;
                this.renderLists[list].init(chunk.xRender, chunk.yRender, chunk.zRender, xOff, yOff, zOff);
            }
            this.renderLists[list].add(chunk.getList(layer));
            ++i2;
        }
        this.renderSameAsLast(layer, alpha);
        return count;
    }

    public void renderSameAsLast(int layer, double alpha) {
        int i = 0;
        while (i < this.renderLists.length) {
            this.renderLists[i].render();
            ++i;
        }
    }

    public void tick() {
        ++this.ticks;
    }

    public void renderSky(float alpha) {
        if (this.mc.level.dimension.foggy) {
            return;
        }
        GL11.glDisable((int)3553);
        Vec3 sc = this.level.getSkyColor(this.mc.player, alpha);
        float sr = (float)sc.x;
        float sg = (float)sc.y;
        float sb = (float)sc.z;
        if (this.mc.options.anaglyph3d) {
            float srr = (sr * 30.0f + sg * 59.0f + sb * 11.0f) / 100.0f;
            float sgg = (sr * 30.0f + sg * 70.0f) / 100.0f;
            float sbb = (sr * 30.0f + sb * 70.0f) / 100.0f;
            sr = srr;
            sg = sgg;
            sb = sbb;
        }
        GL11.glColor3f((float)sr, (float)sg, (float)sb);
        Tesselator t = Tesselator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)sr, (float)sg, (float)sb);
        GL11.glCallList((int)this.skyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float[] c = this.level.dimension.getSunriseColor(this.level.getTimeOfDay(alpha), alpha);
        if (c != null) {
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float now = this.level.getTimeOfDay(alpha);
            GL11.glRotatef((float)(now > 0.5f ? 180 : 0), (float)0.0f, (float)0.0f, (float)1.0f);
            t.begin(6);
            t.color(c[0], c[1], c[2], c[3]);
            t.vertex(0.0, 100.0, 0.0);
            int steps = 16;
            t.color(c[0], c[1], c[2], 0.0f);
            int i = 0;
            while (i <= steps) {
                float a = (float)i * (float)Math.PI * 2.0f / (float)steps;
                float sin = Mth.sin(a);
                float cos = Mth.cos(a);
                t.vertex(sin * 120.0f, cos * 120.0f, -cos * 40.0f * c[3]);
                ++i;
            }
            t.end();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glPushMatrix();
        float xp = 0.0f;
        float yp = 0.0f;
        float zp = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)xp, (float)yp, (float)zp);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(this.level.getTimeOfDay(alpha) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float ss = 30.0f;
        GL11.glBindTexture((int)3553, (int)this.textures.loadTexture("/terrain/sun.png"));
        t.begin();
        t.vertexUV(-ss, 100.0, -ss, 0.0, 0.0);
        t.vertexUV(ss, 100.0, -ss, 1.0, 0.0);
        t.vertexUV(ss, 100.0, ss, 1.0, 1.0);
        t.vertexUV(-ss, 100.0, ss, 0.0, 1.0);
        t.end();
        ss = 20.0f;
        GL11.glBindTexture((int)3553, (int)this.textures.loadTexture("/terrain/moon.png"));
        t.begin();
        t.vertexUV(-ss, -100.0, ss, 1.0, 1.0);
        t.vertexUV(ss, -100.0, ss, 0.0, 1.0);
        t.vertexUV(ss, -100.0, -ss, 0.0, 0.0);
        t.vertexUV(-ss, -100.0, -ss, 1.0, 0.0);
        t.end();
        GL11.glDisable((int)3553);
        float br = this.level.getStarBrightness(alpha);
        if (br > 0.0f) {
            GL11.glColor4f((float)br, (float)br, (float)br, (float)br);
            GL11.glCallList((int)this.starList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glColor3f((float)(sr * 0.2f + 0.04f), (float)(sg * 0.2f + 0.04f), (float)(sb * 0.6f + 0.1f));
        GL11.glDisable((int)3553);
        GL11.glCallList((int)this.darkList);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void renderClouds(float alpha) {
        if (this.mc.level.dimension.foggy) {
            return;
        }
        if (this.mc.options.fancyGraphics) {
            this.renderAdvancedClouds(alpha);
            return;
        }
        GL11.glDisable((int)2884);
        float yOffs = (float)(this.mc.player.yOld + (this.mc.player.y - this.mc.player.yOld) * (double)alpha);
        int s = 32;
        int d = 256 / s;
        Tesselator t = Tesselator.instance;
        GL11.glBindTexture((int)3553, (int)this.textures.loadTexture("/environment/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3 cc = this.level.getCloudColor(alpha);
        float cr = (float)cc.x;
        float cg = (float)cc.y;
        float cb = (float)cc.z;
        if (this.mc.options.anaglyph3d) {
            float crr = (cr * 30.0f + cg * 59.0f + cb * 11.0f) / 100.0f;
            float cgg = (cr * 30.0f + cg * 70.0f) / 100.0f;
            float cbb = (cr * 30.0f + cb * 70.0f) / 100.0f;
            cr = crr;
            cg = cgg;
            cb = cbb;
        }
        float scale = 4.8828125E-4f;
        double xo = this.mc.player.xo + (this.mc.player.x - this.mc.player.xo) * (double)alpha + (double)(((float)this.ticks + alpha) * 0.03f);
        double zo = this.mc.player.zo + (this.mc.player.z - this.mc.player.zo) * (double)alpha;
        int xOffs = Mth.floor(xo / 2048.0);
        int zOffs = Mth.floor(zo / 2048.0);
        float yy = 120.0f - yOffs + 0.33f;
        float uo = (float)((xo -= (double)(xOffs * 2048)) * (double)scale);
        float vo = (float)((zo -= (double)(zOffs * 2048)) * (double)scale);
        t.begin();
        t.color(cr, cg, cb, 0.8f);
        int xx = -s * d;
        while (xx < s * d) {
            int zz = -s * d;
            while (zz < s * d) {
                t.vertexUV(xx + 0, yy, zz + s, (float)(xx + 0) * scale + uo, (float)(zz + s) * scale + vo);
                t.vertexUV(xx + s, yy, zz + s, (float)(xx + s) * scale + uo, (float)(zz + s) * scale + vo);
                t.vertexUV(xx + s, yy, zz + 0, (float)(xx + s) * scale + uo, (float)(zz + 0) * scale + vo);
                t.vertexUV(xx + 0, yy, zz + 0, (float)(xx + 0) * scale + uo, (float)(zz + 0) * scale + vo);
                zz += s;
            }
            xx += s;
        }
        t.end();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public void renderAdvancedClouds(float alpha) {
        GL11.glDisable((int)2884);
        float yOffs = (float)(this.mc.player.yOld + (this.mc.player.y - this.mc.player.yOld) * (double)alpha);
        Tesselator t = Tesselator.instance;
        float ss = 12.0f;
        float h = 4.0f;
        double xo = (this.mc.player.xo + (this.mc.player.x - this.mc.player.xo) * (double)alpha + (double)(((float)this.ticks + alpha) * 0.03f)) / (double)ss;
        double zo = (this.mc.player.zo + (this.mc.player.z - this.mc.player.zo) * (double)alpha) / (double)ss + (double)0.33f;
        float yy = 108.0f - yOffs + 0.33f;
        int xOffs = Mth.floor(xo / 2048.0);
        int zOffs = Mth.floor(zo / 2048.0);
        xo -= (double)(xOffs * 2048);
        zo -= (double)(zOffs * 2048);
        GL11.glBindTexture((int)3553, (int)this.textures.loadTexture("/environment/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3 cc = this.level.getCloudColor(alpha);
        float cr = (float)cc.x;
        float cg = (float)cc.y;
        float cb = (float)cc.z;
        if (this.mc.options.anaglyph3d) {
            float crr = (cr * 30.0f + cg * 59.0f + cb * 11.0f) / 100.0f;
            float cgg = (cr * 30.0f + cg * 70.0f) / 100.0f;
            float cbb = (cr * 30.0f + cb * 70.0f) / 100.0f;
            cr = crr;
            cg = cgg;
            cb = cbb;
        }
        float uo = (float)(xo * 0.0);
        float vo = (float)(zo * 0.0);
        float scale = 0.00390625f;
        uo = (float)Mth.floor(xo) * scale;
        vo = (float)Mth.floor(zo) * scale;
        float xoffs = (float)(xo - (double)Mth.floor(xo));
        float zoffs = (float)(zo - (double)Mth.floor(zo));
        int D = 8;
        int radius = 3;
        float e = 9.765625E-4f;
        GL11.glScalef((float)ss, (float)1.0f, (float)ss);
        int pass = 0;
        while (pass < 2) {
            if (pass == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            int xPos = -radius + 1;
            while (xPos <= radius) {
                int zPos = -radius + 1;
                while (zPos <= radius) {
                    int i;
                    t.begin();
                    float xx = xPos * D;
                    float zz = zPos * D;
                    float xp = xx - xoffs;
                    float zp = zz - zoffs;
                    if (yy > -h - 1.0f) {
                        t.color(cr * 0.7f, cg * 0.7f, cb * 0.7f, 0.8f);
                        t.normal(0.0f, -1.0f, 0.0f);
                        t.vertexUV(xp + 0.0f, yy + 0.0f, zp + (float)D, (xx + 0.0f) * scale + uo, (zz + (float)D) * scale + vo);
                        t.vertexUV(xp + (float)D, yy + 0.0f, zp + (float)D, (xx + (float)D) * scale + uo, (zz + (float)D) * scale + vo);
                        t.vertexUV(xp + (float)D, yy + 0.0f, zp + 0.0f, (xx + (float)D) * scale + uo, (zz + 0.0f) * scale + vo);
                        t.vertexUV(xp + 0.0f, yy + 0.0f, zp + 0.0f, (xx + 0.0f) * scale + uo, (zz + 0.0f) * scale + vo);
                    }
                    if (yy <= h + 1.0f) {
                        t.color(cr, cg, cb, 0.8f);
                        t.normal(0.0f, 1.0f, 0.0f);
                        t.vertexUV(xp + 0.0f, yy + h - e, zp + (float)D, (xx + 0.0f) * scale + uo, (zz + (float)D) * scale + vo);
                        t.vertexUV(xp + (float)D, yy + h - e, zp + (float)D, (xx + (float)D) * scale + uo, (zz + (float)D) * scale + vo);
                        t.vertexUV(xp + (float)D, yy + h - e, zp + 0.0f, (xx + (float)D) * scale + uo, (zz + 0.0f) * scale + vo);
                        t.vertexUV(xp + 0.0f, yy + h - e, zp + 0.0f, (xx + 0.0f) * scale + uo, (zz + 0.0f) * scale + vo);
                    }
                    t.color(cr * 0.9f, cg * 0.9f, cb * 0.9f, 0.8f);
                    if (xPos > -1) {
                        t.normal(-1.0f, 0.0f, 0.0f);
                        i = 0;
                        while (i < D) {
                            t.vertexUV(xp + (float)i + 0.0f, yy + 0.0f, zp + (float)D, (xx + (float)i + 0.5f) * scale + uo, (zz + (float)D) * scale + vo);
                            t.vertexUV(xp + (float)i + 0.0f, yy + h, zp + (float)D, (xx + (float)i + 0.5f) * scale + uo, (zz + (float)D) * scale + vo);
                            t.vertexUV(xp + (float)i + 0.0f, yy + h, zp + 0.0f, (xx + (float)i + 0.5f) * scale + uo, (zz + 0.0f) * scale + vo);
                            t.vertexUV(xp + (float)i + 0.0f, yy + 0.0f, zp + 0.0f, (xx + (float)i + 0.5f) * scale + uo, (zz + 0.0f) * scale + vo);
                            ++i;
                        }
                    }
                    if (xPos <= 1) {
                        t.normal(1.0f, 0.0f, 0.0f);
                        i = 0;
                        while (i < D) {
                            t.vertexUV(xp + (float)i + 1.0f - e, yy + 0.0f, zp + (float)D, (xx + (float)i + 0.5f) * scale + uo, (zz + (float)D) * scale + vo);
                            t.vertexUV(xp + (float)i + 1.0f - e, yy + h, zp + (float)D, (xx + (float)i + 0.5f) * scale + uo, (zz + (float)D) * scale + vo);
                            t.vertexUV(xp + (float)i + 1.0f - e, yy + h, zp + 0.0f, (xx + (float)i + 0.5f) * scale + uo, (zz + 0.0f) * scale + vo);
                            t.vertexUV(xp + (float)i + 1.0f - e, yy + 0.0f, zp + 0.0f, (xx + (float)i + 0.5f) * scale + uo, (zz + 0.0f) * scale + vo);
                            ++i;
                        }
                    }
                    t.color(cr * 0.8f, cg * 0.8f, cb * 0.8f, 0.8f);
                    if (zPos > -1) {
                        t.normal(0.0f, 0.0f, -1.0f);
                        i = 0;
                        while (i < D) {
                            t.vertexUV(xp + 0.0f, yy + h, zp + (float)i + 0.0f, (xx + 0.0f) * scale + uo, (zz + (float)i + 0.5f) * scale + vo);
                            t.vertexUV(xp + (float)D, yy + h, zp + (float)i + 0.0f, (xx + (float)D) * scale + uo, (zz + (float)i + 0.5f) * scale + vo);
                            t.vertexUV(xp + (float)D, yy + 0.0f, zp + (float)i + 0.0f, (xx + (float)D) * scale + uo, (zz + (float)i + 0.5f) * scale + vo);
                            t.vertexUV(xp + 0.0f, yy + 0.0f, zp + (float)i + 0.0f, (xx + 0.0f) * scale + uo, (zz + (float)i + 0.5f) * scale + vo);
                            ++i;
                        }
                    }
                    if (zPos <= 1) {
                        t.normal(0.0f, 0.0f, 1.0f);
                        i = 0;
                        while (i < D) {
                            t.vertexUV(xp + 0.0f, yy + h, zp + (float)i + 1.0f - e, (xx + 0.0f) * scale + uo, (zz + (float)i + 0.5f) * scale + vo);
                            t.vertexUV(xp + (float)D, yy + h, zp + (float)i + 1.0f - e, (xx + (float)D) * scale + uo, (zz + (float)i + 0.5f) * scale + vo);
                            t.vertexUV(xp + (float)D, yy + 0.0f, zp + (float)i + 1.0f - e, (xx + (float)D) * scale + uo, (zz + (float)i + 0.5f) * scale + vo);
                            t.vertexUV(xp + 0.0f, yy + 0.0f, zp + (float)i + 1.0f - e, (xx + 0.0f) * scale + uo, (zz + (float)i + 0.5f) * scale + vo);
                            ++i;
                        }
                    }
                    t.end();
                    ++zPos;
                }
                ++xPos;
            }
            ++pass;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public boolean updateDirtyChunks(Player player, boolean force) {
        Chunk chunk;
        block25: {
            boolean slow = false;
            if (!slow) break block25;
            Collections.sort(this.dirtyChunks, new DirtyChunkSorter(player));
            int s = this.dirtyChunks.size() - 1;
            int amount = this.dirtyChunks.size();
            int i = 0;
            while (i < amount) {
                block28: {
                    Chunk chunk2;
                    block27: {
                        block26: {
                            chunk2 = this.dirtyChunks.get(s - i);
                            if (force) break block26;
                            if (chunk2.distanceToSqr(player) > 1024.0f && (chunk2.visible ? i >= 3 : i >= 1)) {
                                return false;
                            }
                            break block27;
                        }
                        if (!chunk2.visible) break block28;
                    }
                    chunk2.rebuild();
                    this.dirtyChunks.remove(chunk2);
                    chunk2.dirty = false;
                }
                ++i;
            }
            return this.dirtyChunks.size() == 0;
        }
        DirtyChunkSorter dirtyChunkSorter = new DirtyChunkSorter(player);
        Chunk[] toAdd = new Chunk[3];
        ArrayList<Chunk> nearChunks = null;
        int pendingChunkSize = this.dirtyChunks.size();
        int pendingChunkRemoved = 0;
        int i = 0;
        while (i < pendingChunkSize) {
            block31: {
                block30: {
                    block29: {
                        chunk = this.dirtyChunks.get(i);
                        if (force) break block29;
                        if (!(chunk.distanceToSqr(player) > 1024.0f)) break block30;
                        int index = 0;
                        while (index < 3) {
                            if (toAdd[index] != null && dirtyChunkSorter.compare(toAdd[index], chunk) > 0) break;
                            ++index;
                        }
                        if (--index > 0) {
                            int x = index;
                            while (--x != 0) {
                                toAdd[x - 1] = toAdd[x];
                            }
                            toAdd[index] = chunk;
                        }
                        break block31;
                    }
                    if (!chunk.visible) break block31;
                }
                if (nearChunks == null) {
                    nearChunks = new ArrayList<Chunk>();
                }
                ++pendingChunkRemoved;
                nearChunks.add(chunk);
                this.dirtyChunks.set(i, null);
            }
            ++i;
        }
        if (nearChunks != null) {
            if (nearChunks.size() > 1) {
                Collections.sort(nearChunks, dirtyChunkSorter);
            }
            i = nearChunks.size() - 1;
            while (i >= 0) {
                chunk = (Chunk)nearChunks.get(i);
                chunk.rebuild();
                chunk.dirty = false;
                --i;
            }
        }
        int secondaryRemoved = 0;
        int i2 = 2;
        while (i2 >= 0) {
            Chunk chunk3 = toAdd[i2];
            if (chunk3 != null) {
                if (!chunk3.visible && i2 != 2) {
                    toAdd[i2] = null;
                    toAdd[0] = null;
                    break;
                }
                toAdd[i2].rebuild();
                toAdd[i2].dirty = false;
                ++secondaryRemoved;
            }
            --i2;
        }
        int cursor = 0;
        int target = 0;
        int arraySize = this.dirtyChunks.size();
        while (cursor != arraySize) {
            Chunk chunk4 = this.dirtyChunks.get(cursor);
            if (chunk4 != null && chunk4 != toAdd[0] && chunk4 != toAdd[1] && chunk4 != toAdd[2]) {
                if (target != cursor) {
                    this.dirtyChunks.set(target, chunk4);
                }
                ++target;
            }
            ++cursor;
        }
        while (--cursor >= target) {
            this.dirtyChunks.remove(cursor);
        }
        return pendingChunkSize == pendingChunkRemoved + secondaryRemoved;
    }

    public void renderHit(Player player, HitResult h, int mode, ItemInstance inventoryItem, float a) {
        Tesselator t = Tesselator.instance;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((Mth.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f));
        if (mode == 0) {
            if (this.destroyProgress > 0.0f) {
                GL11.glBlendFunc((int)774, (int)768);
                int id = this.textures.loadTexture("/terrain.png");
                GL11.glBindTexture((int)3553, (int)id);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GL11.glPushMatrix();
                int tileId = this.level.getTile(h.x, h.y, h.z);
                Tile tile = tileId > 0 ? Tile.tiles[tileId] : null;
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
                GL11.glEnable((int)32823);
                t.begin();
                double xo = player.xOld + (player.x - player.xOld) * (double)a;
                double yo = player.yOld + (player.y - player.yOld) * (double)a;
                double zo = player.zOld + (player.z - player.zOld) * (double)a;
                t.offset(-xo, -yo, -zo);
                t.noColor();
                if (tile == null) {
                    tile = Tile.rock;
                }
                this.tileRenderer.tesselateInWorld(tile, h.x, h.y, h.z, 240 + (int)(this.destroyProgress * 10.0f));
                t.end();
                t.offset(0.0, 0.0, 0.0);
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3008);
                GL11.glDepthMask((boolean)true);
                GL11.glPopMatrix();
            }
        } else if (inventoryItem != null) {
            GL11.glBlendFunc((int)770, (int)771);
            float br = Mth.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.8f;
            GL11.glColor4f((float)br, (float)br, (float)br, (float)(Mth.sin((float)System.currentTimeMillis() / 200.0f) * 0.2f + 0.5f));
            int id = this.textures.loadTexture("/terrain.png");
            GL11.glBindTexture((int)3553, (int)id);
            int x = h.x;
            int y = h.y;
            int z = h.z;
            if (h.f == 0) {
                --y;
            }
            if (h.f == 1) {
                ++y;
            }
            if (h.f == 2) {
                --z;
            }
            if (h.f == 3) {
                ++z;
            }
            if (h.f == 4) {
                --x;
            }
            if (h.f == 5) {
                ++x;
            }
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    public void renderHitOutline(Player player, HitResult h, int mode, ItemInstance inventoryItem, float a) {
        if (mode == 0 && h.type == HitResult.Type.TILE) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float ss = 0.002f;
            int tileId = this.level.getTile(h.x, h.y, h.z);
            if (tileId > 0) {
                Tile.tiles[tileId].updateShape(this.level, h.x, h.y, h.z);
                double xo = player.xOld + (player.x - player.xOld) * (double)a;
                double yo = player.yOld + (player.y - player.yOld) * (double)a;
                double zo = player.zOld + (player.z - player.zOld) * (double)a;
                this.render(Tile.tiles[tileId].getTileAABB(this.level, h.x, h.y, h.z).grow(ss, ss, ss).cloneMove(-xo, -yo, -zo));
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    private void render(AABB b) {
        Tesselator t = Tesselator.instance;
        t.begin(3);
        t.vertex(b.x0, b.y0, b.z0);
        t.vertex(b.x1, b.y0, b.z0);
        t.vertex(b.x1, b.y0, b.z1);
        t.vertex(b.x0, b.y0, b.z1);
        t.vertex(b.x0, b.y0, b.z0);
        t.end();
        t.begin(3);
        t.vertex(b.x0, b.y1, b.z0);
        t.vertex(b.x1, b.y1, b.z0);
        t.vertex(b.x1, b.y1, b.z1);
        t.vertex(b.x0, b.y1, b.z1);
        t.vertex(b.x0, b.y1, b.z0);
        t.end();
        t.begin(1);
        t.vertex(b.x0, b.y0, b.z0);
        t.vertex(b.x0, b.y1, b.z0);
        t.vertex(b.x1, b.y0, b.z0);
        t.vertex(b.x1, b.y1, b.z0);
        t.vertex(b.x1, b.y0, b.z1);
        t.vertex(b.x1, b.y1, b.z1);
        t.vertex(b.x0, b.y0, b.z1);
        t.vertex(b.x0, b.y1, b.z1);
        t.end();
    }

    public void setDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        int _x0 = Mth.intFloorDiv(x0, 16);
        int _y0 = Mth.intFloorDiv(y0, 16);
        int _z0 = Mth.intFloorDiv(z0, 16);
        int _x1 = Mth.intFloorDiv(x1, 16);
        int _y1 = Mth.intFloorDiv(y1, 16);
        int _z1 = Mth.intFloorDiv(z1, 16);
        int x = _x0;
        while (x <= _x1) {
            int xx = x % this.xChunks;
            if (xx < 0) {
                xx += this.xChunks;
            }
            int y = _y0;
            while (y <= _y1) {
                int yy = y % this.yChunks;
                if (yy < 0) {
                    yy += this.yChunks;
                }
                int z = _z0;
                while (z <= _z1) {
                    int zz = z % this.zChunks;
                    if (zz < 0) {
                        zz += this.zChunks;
                    }
                    int p = (zz * this.yChunks + yy) * this.xChunks + xx;
                    Chunk chunk = this.chunks[p];
                    if (!chunk.dirty) {
                        this.dirtyChunks.add(chunk);
                        chunk.setDirty();
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void tileChanged(int x, int y, int z) {
        this.setDirty(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
    }

    @Override
    public void setTilesDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        this.setDirty(x0 - 1, y0 - 1, z0 - 1, x1 + 1, y1 + 1, z1 + 1);
    }

    public void cull(Culler culler, float a) {
        int i = 0;
        while (i < this.chunks.length) {
            if (!(this.chunks[i].isEmpty() || this.chunks[i].visible && (i + this.cullStep & 0xF) != 0)) {
                this.chunks[i].cull(culler);
            }
            ++i;
        }
        ++this.cullStep;
    }

    @Override
    public void playStreamingMusic(String name, int x, int y, int z) {
        if (name != null) {
            this.mc.gui.setNowPlaying("C418 - " + name);
        }
        this.mc.soundEngine.playStreaming(name, x, y, z, 1.0f, 1.0f);
    }

    @Override
    public void playSound(String name, double x, double y, double z, float volume, float pitch) {
        float dd = 16.0f;
        if (volume > 1.0f) {
            dd *= volume;
        }
        if (this.mc.player.distanceToSqr(x, y, z) < (double)(dd * dd)) {
            this.mc.soundEngine.play(name, (float)x, (float)y, (float)z, volume, pitch);
        }
    }

    @Override
    public void addParticle(String name, double x, double y, double z, double xa, double ya, double za) {
        double xd = this.mc.player.x - x;
        double yd = this.mc.player.y - y;
        double zd = this.mc.player.z - z;
        double particleDistance = 16.0;
        if (xd * xd + yd * yd + zd * zd > particleDistance * particleDistance) {
            return;
        }
        if (name == "bubble") {
            this.mc.particleEngine.add(new BubbleParticle(this.level, x, y, z, xa, ya, za));
        } else if (name == "smoke") {
            this.mc.particleEngine.add(new SmokeParticle(this.level, x, y, z, xa, ya, za));
        } else if (name == "note") {
            this.mc.particleEngine.add(new NoteParticle(this.level, x, y, z, xa, ya, za));
        } else if (name == "portal") {
            this.mc.particleEngine.add(new PortalParticle(this.level, x, y, z, xa, ya, za));
        } else if (name == "explode") {
            this.mc.particleEngine.add(new ExplodeParticle(this.level, x, y, z, xa, ya, za));
        } else if (name == "flame") {
            this.mc.particleEngine.add(new FlameParticle(this.level, x, y, z, xa, ya, za));
        } else if (name == "lava") {
            this.mc.particleEngine.add(new LavaParticle(this.level, x, y, z));
        } else if (name == "splash") {
            this.mc.particleEngine.add(new SplashParticle(this.level, x, y, z, xa, ya, za));
        } else if (name == "largesmoke") {
            this.mc.particleEngine.add(new SmokeParticle(this.level, x, y, z, xa, ya, za, 2.5f));
        } else if (name == "reddust") {
            this.mc.particleEngine.add(new RedDustParticle(this.level, x, y, z));
        } else if (name == "snowballpoof") {
            this.mc.particleEngine.add(new BreakingItemParticle(this.level, x, y, z, Item.snowBall));
        } else if (name == "slime") {
            this.mc.particleEngine.add(new BreakingItemParticle(this.level, x, y, z, Item.slimeBall));
        }
    }

    @Override
    public void playMusic(String name, double x, double y, double z, float songOffset) {
    }

    @Override
    public void entityAdded(Entity entity) {
        entity.prepareCustomTextures();
        if (entity.customTextureUrl != null) {
            this.textures.addHttpTexture(entity.customTextureUrl, new MobSkinTextureProcessor());
        }
        if (entity.customTextureUrl2 != null) {
            this.textures.addHttpTexture(entity.customTextureUrl2, new MobSkinTextureProcessor());
        }
    }

    @Override
    public void entityRemoved(Entity entity) {
        if (entity.customTextureUrl != null) {
            this.textures.removeHttpTexture(entity.customTextureUrl);
        }
        if (entity.customTextureUrl2 != null) {
            this.textures.removeHttpTexture(entity.customTextureUrl2);
        }
    }

    @Override
    public void skyColorChanged() {
        int i = 0;
        while (i < this.chunks.length) {
            if (this.chunks[i].skyLit && !this.chunks[i].dirty) {
                this.dirtyChunks.add(this.chunks[i]);
                this.chunks[i].setDirty();
            }
            ++i;
        }
    }

    @Override
    public void tileEntityChanged(int x, int y, int z, TileEntity te) {
    }
}

