/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import net.minecraft.client.Lighting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class ItemInHandRenderer {
    private Minecraft mc;
    private ItemInstance selectedItem = null;
    private float height = 0.0f;
    private float oHeight = 0.0f;
    private TileRenderer tileRenderer = new TileRenderer();
    private int lastSlot = -1;

    public ItemInHandRenderer(Minecraft mc) {
        this.mc = mc;
    }

    public void renderItem(ItemInstance item) {
        GL11.glPushMatrix();
        if (item.id < 256 && TileRenderer.canRender(Tile.tiles[item.id].getRenderShape())) {
            GL11.glBindTexture((int)3553, (int)this.mc.textures.loadTexture("/terrain.png"));
            this.tileRenderer.renderTile(Tile.tiles[item.id], item.getAuxValue());
        } else {
            float yy;
            float vv;
            float xx;
            float uu;
            float p;
            if (item.id < 256) {
                GL11.glBindTexture((int)3553, (int)this.mc.textures.loadTexture("/terrain.png"));
            } else {
                GL11.glBindTexture((int)3553, (int)this.mc.textures.loadTexture("/gui/items.png"));
            }
            Tesselator t = Tesselator.instance;
            float u1 = ((float)(item.getIcon() % 16 * 16) + 0.0f) / 256.0f;
            float u0 = ((float)(item.getIcon() % 16 * 16) + 15.99f) / 256.0f;
            float v0 = ((float)(item.getIcon() / 16 * 16) + 0.0f) / 256.0f;
            float v1 = ((float)(item.getIcon() / 16 * 16) + 15.99f) / 256.0f;
            float r = 1.0f;
            float xo = 0.0f;
            float yo = 0.3f;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)(-xo), (float)(-yo), (float)0.0f);
            float s = 1.5f;
            GL11.glScalef((float)s, (float)s, (float)s);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            float dd = 0.0625f;
            t.begin();
            t.normal(0.0f, 0.0f, 1.0f);
            t.vertexUV(0.0, 0.0, 0.0, u0, v1);
            t.vertexUV(r, 0.0, 0.0, u1, v1);
            t.vertexUV(r, 1.0, 0.0, u1, v0);
            t.vertexUV(0.0, 1.0, 0.0, u0, v0);
            t.end();
            t.begin();
            t.normal(0.0f, 0.0f, -1.0f);
            t.vertexUV(0.0, 1.0, 0.0f - dd, u0, v0);
            t.vertexUV(r, 1.0, 0.0f - dd, u1, v0);
            t.vertexUV(r, 0.0, 0.0f - dd, u1, v1);
            t.vertexUV(0.0, 0.0, 0.0f - dd, u0, v1);
            t.end();
            t.begin();
            t.normal(-1.0f, 0.0f, 0.0f);
            int i = 0;
            while (i < 16) {
                p = (float)i / 16.0f;
                uu = u0 + (u1 - u0) * p - 0.001953125f;
                xx = r * p;
                t.vertexUV(xx, 0.0, 0.0f - dd, uu, v1);
                t.vertexUV(xx, 0.0, 0.0, uu, v1);
                t.vertexUV(xx, 1.0, 0.0, uu, v0);
                t.vertexUV(xx, 1.0, 0.0f - dd, uu, v0);
                ++i;
            }
            t.end();
            t.begin();
            t.normal(1.0f, 0.0f, 0.0f);
            i = 0;
            while (i < 16) {
                p = (float)i / 16.0f;
                uu = u0 + (u1 - u0) * p - 0.001953125f;
                xx = r * p + 0.0625f;
                t.vertexUV(xx, 1.0, 0.0f - dd, uu, v0);
                t.vertexUV(xx, 1.0, 0.0, uu, v0);
                t.vertexUV(xx, 0.0, 0.0, uu, v1);
                t.vertexUV(xx, 0.0, 0.0f - dd, uu, v1);
                ++i;
            }
            t.end();
            t.begin();
            t.normal(0.0f, 1.0f, 0.0f);
            i = 0;
            while (i < 16) {
                p = (float)i / 16.0f;
                vv = v1 + (v0 - v1) * p - 0.001953125f;
                yy = r * p + 0.0625f;
                t.vertexUV(0.0, yy, 0.0, u0, vv);
                t.vertexUV(r, yy, 0.0, u1, vv);
                t.vertexUV(r, yy, 0.0f - dd, u1, vv);
                t.vertexUV(0.0, yy, 0.0f - dd, u0, vv);
                ++i;
            }
            t.end();
            t.begin();
            t.normal(0.0f, -1.0f, 0.0f);
            i = 0;
            while (i < 16) {
                p = (float)i / 16.0f;
                vv = v1 + (v0 - v1) * p - 0.001953125f;
                yy = r * p;
                t.vertexUV(r, yy, 0.0, u1, vv);
                t.vertexUV(0.0, yy, 0.0, u0, vv);
                t.vertexUV(0.0, yy, 0.0f - dd, u0, vv);
                t.vertexUV(r, yy, 0.0f - dd, u1, vv);
                ++i;
            }
            t.end();
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    public void render(float a) {
        float h = this.oHeight + (this.height - this.oHeight) * a;
        LocalPlayer player = this.mc.player;
        GL11.glPushMatrix();
        GL11.glRotatef((float)(player.xRotO + (player.xRot - player.xRotO) * a), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(player.yRotO + (player.yRot - player.yRotO) * a), (float)0.0f, (float)1.0f, (float)0.0f);
        Lighting.turnOn();
        GL11.glPopMatrix();
        float br = this.mc.level.getBrightness(Mth.floor(player.x), Mth.floor(player.y), Mth.floor(player.z));
        GL11.glColor4f((float)br, (float)br, (float)br, (float)1.0f);
        ItemInstance item = this.selectedItem;
        if (player.fishing != null) {
            item = new ItemInstance(Item.stick);
        }
        if (item != null) {
            GL11.glPushMatrix();
            float d = 0.8f;
            float swing = player.getAttackAnim(a);
            float swing1 = Mth.sin(swing * (float)Math.PI);
            float swing2 = Mth.sin(Mth.sqrt(swing) * (float)Math.PI);
            GL11.glTranslatef((float)(-swing2 * 0.4f), (float)(Mth.sin(Mth.sqrt(swing) * (float)Math.PI * 2.0f) * 0.2f), (float)(-swing1 * 0.2f));
            GL11.glTranslatef((float)(0.7f * d), (float)(-0.65f * d - (1.0f - h) * 0.6f), (float)(-0.9f * d));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32826);
            swing = player.getAttackAnim(a);
            float swing3 = Mth.sin(swing * swing * (float)Math.PI);
            swing2 = Mth.sin(Mth.sqrt(swing) * (float)Math.PI);
            GL11.glRotatef((float)(-swing3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-swing2 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-swing2 * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float ss = 0.4f;
            GL11.glScalef((float)ss, (float)ss, (float)ss);
            if (item.getItem().isMirroredArt()) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.renderItem(item);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            float d = 0.8f;
            float swing = player.getAttackAnim(a);
            float swing1 = Mth.sin(swing * (float)Math.PI);
            float swing2 = Mth.sin(Mth.sqrt(swing) * (float)Math.PI);
            GL11.glTranslatef((float)(-swing2 * 0.3f), (float)(Mth.sin(Mth.sqrt(swing) * (float)Math.PI * 2.0f) * 0.4f), (float)(-swing1 * 0.4f));
            GL11.glTranslatef((float)(0.8f * d), (float)(-0.75f * d - (1.0f - h) * 0.6f), (float)(-0.9f * d));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32826);
            swing = player.getAttackAnim(a);
            float swing3 = Mth.sin(swing * swing * (float)Math.PI);
            swing2 = Mth.sin(Mth.sqrt(swing) * (float)Math.PI);
            GL11.glRotatef((float)(swing2 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-swing3 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.textures.loadHttpTexture(this.mc.player.customTextureUrl, this.mc.player.getTexture()));
            GL11.glTranslatef((float)-1.0f, (float)3.6f, (float)3.5f);
            GL11.glRotatef((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)5.6f, (float)0.0f, (float)0.0f);
            EntityRenderer er = EntityRenderDispatcher.instance.getRenderer(this.mc.player);
            PlayerRenderer playerRenderer = (PlayerRenderer)er;
            float ss = 1.0f;
            GL11.glScalef((float)ss, (float)ss, (float)ss);
            playerRenderer.renderHand();
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)32826);
        Lighting.turnOff();
    }

    public void renderScreenEffect(float a) {
        int id;
        GL11.glDisable((int)3008);
        if (this.mc.player.isOnFire()) {
            id = this.mc.textures.loadTexture("/terrain.png");
            GL11.glBindTexture((int)3553, (int)id);
            this.renderFire(a);
        }
        if (this.mc.player.isInWall()) {
            int x = Mth.floor(this.mc.player.x);
            int y = Mth.floor(this.mc.player.y);
            int z = Mth.floor(this.mc.player.z);
            int id2 = this.mc.textures.loadTexture("/terrain.png");
            GL11.glBindTexture((int)3553, (int)id2);
            int tile = this.mc.level.getTile(x, y, z);
            if (Tile.tiles[tile] != null) {
                this.renderTex(a, Tile.tiles[tile].getTexture(2));
            }
        }
        if (this.mc.player.isUnderLiquid(Material.water)) {
            id = this.mc.textures.loadTexture("/misc/water.png");
            GL11.glBindTexture((int)3553, (int)id);
            this.renderWater(a);
        }
        GL11.glEnable((int)3008);
    }

    private void renderTex(float a, int tex) {
        Tesselator t = Tesselator.instance;
        float br = this.mc.player.getBrightness(a);
        br = 0.1f;
        GL11.glColor4f((float)br, (float)br, (float)br, (float)0.5f);
        GL11.glPushMatrix();
        float x0 = -1.0f;
        float x1 = 1.0f;
        float y0 = -1.0f;
        float y1 = 1.0f;
        float z0 = -0.5f;
        float r = 0.0078125f;
        float u0 = (float)(tex % 16) / 256.0f - r;
        float u1 = ((float)(tex % 16) + 15.99f) / 256.0f + r;
        float v0 = (float)(tex / 16) / 256.0f - r;
        float v1 = ((float)(tex / 16) + 15.99f) / 256.0f + r;
        t.begin();
        t.vertexUV(x0, y0, z0, u1, v1);
        t.vertexUV(x1, y0, z0, u0, v1);
        t.vertexUV(x1, y1, z0, u0, v0);
        t.vertexUV(x0, y1, z0, u1, v0);
        t.end();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderWater(float a) {
        Tesselator t = Tesselator.instance;
        float br = this.mc.player.getBrightness(a);
        GL11.glColor4f((float)br, (float)br, (float)br, (float)0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        float size = 4.0f;
        float x0 = -1.0f;
        float x1 = 1.0f;
        float y0 = -1.0f;
        float y1 = 1.0f;
        float z0 = -0.5f;
        float uo = -this.mc.player.yRot / 64.0f;
        float vo = this.mc.player.xRot / 64.0f;
        t.begin();
        t.vertexUV(x0, y0, z0, size + uo, size + vo);
        t.vertexUV(x1, y0, z0, 0.0f + uo, size + vo);
        t.vertexUV(x1, y1, z0, 0.0f + uo, 0.0f + vo);
        t.vertexUV(x0, y1, z0, size + uo, 0.0f + vo);
        t.end();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderFire(float a) {
        Tesselator t = Tesselator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float size = 1.0f;
        int i = 0;
        while (i < 2) {
            GL11.glPushMatrix();
            int tex = Tile.fire.tex + i * 16;
            int xt = (tex & 0xF) << 4;
            int yt = tex & 0xF0;
            float u0 = (float)xt / 256.0f;
            float u1 = ((float)xt + 15.99f) / 256.0f;
            float v0 = (float)yt / 256.0f;
            float v1 = ((float)yt + 15.99f) / 256.0f;
            float x0 = (0.0f - size) / 2.0f;
            float x1 = x0 + size;
            float y0 = 0.0f - size / 2.0f;
            float y1 = y0 + size;
            float z0 = -0.5f;
            GL11.glTranslatef((float)((float)(-(i * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            t.begin();
            t.vertexUV(x0, y0, z0, u1, v1);
            t.vertexUV(x1, y0, z0, u0, v1);
            t.vertexUV(x1, y1, z0, u0, v0);
            t.vertexUV(x0, y1, z0, u1, v0);
            t.end();
            GL11.glPopMatrix();
            ++i;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void tick() {
        float max;
        float tHeight;
        float dd;
        boolean matches;
        ItemInstance selected;
        this.oHeight = this.height;
        LocalPlayer player = this.mc.player;
        ItemInstance nextTile = selected = player.inventory.getSelected();
        boolean bl = matches = this.lastSlot == player.inventory.selected && nextTile == this.selectedItem;
        if (this.selectedItem == null && nextTile == null) {
            matches = true;
        }
        if (nextTile != null && this.selectedItem != null && nextTile != this.selectedItem && nextTile.id == this.selectedItem.id) {
            this.selectedItem = nextTile;
            matches = true;
        }
        if ((dd = (tHeight = (float)(matches ? 1 : 0)) - this.height) < -(max = 0.4f)) {
            dd = -max;
        }
        if (dd > max) {
            dd = max;
        }
        this.height += dd;
        if (this.height < 0.1f) {
            this.selectedItem = nextTile;
            this.lastSlot = player.inventory.selected;
        }
    }

    public void itemPlaced() {
        this.height = 0.0f;
    }

    public void itemUsed() {
        this.height = 0.0f;
    }
}

