/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.nio.FloatBuffer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Lighting;
import net.minecraft.client.MemoryTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gamemode.CreativeMode;
import net.minecraft.client.gui.ScreenSizeCalculator;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.FrustumCuller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkCache;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;
import util.Mth;

public class GameRenderer {
    private Minecraft mc;
    private float renderDistance = 0.0f;
    public ItemInHandRenderer itemInHandRenderer;
    private int tick;
    private Entity hovered = null;
    private double zoom = 1.0;
    private double zoom_x = 0.0;
    private double zoom_y = 0.0;
    private long lastActiveTime = System.currentTimeMillis();
    private Random random = new Random();
    volatile int xMod = 0;
    volatile int yMod = 0;
    FloatBuffer lb = MemoryTracker.createFloatBuffer(16);
    float fr;
    float fg;
    float fb;
    private float fogBrO;
    private float fogBr;

    public GameRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.itemInHandRenderer = new ItemInHandRenderer(minecraft);
    }

    public void tick() {
        this.fogBrO = this.fogBr;
        float f = this.mc.level.getBrightness(Mth.floor(this.mc.player.x), Mth.floor(this.mc.player.y), Mth.floor(this.mc.player.z));
        float f2 = (float)(3 - this.mc.options.viewDistance) / 3.0f;
        float f3 = f * (1.0f - f2) + f2;
        this.fogBr += (f3 - this.fogBr) * 0.1f;
        ++this.tick;
        this.itemInHandRenderer.tick();
        if (this.mc.isRaining) {
            this.tickRain();
        }
    }

    public void pick(float f) {
        if (this.mc.player == null) {
            return;
        }
        double d = this.mc.gameMode.getPickRange();
        this.mc.hitResult = this.mc.player.pick(d, f);
        double d2 = d;
        Vec3 vec3 = this.mc.player.getPos(f);
        if (this.mc.hitResult != null) {
            d2 = this.mc.hitResult.pos.distanceTo(vec3);
        }
        if (this.mc.gameMode instanceof CreativeMode) {
            d = 32.0;
            d2 = 32.0;
        } else {
            if (d2 > 3.0) {
                d2 = 3.0;
            }
            d = d2;
        }
        Vec3 vec32 = this.mc.player.getViewVector(f);
        Vec3 vec33 = vec3.add(vec32.x * d, vec32.y * d, vec32.z * d);
        this.hovered = null;
        float f2 = 1.0f;
        List<Entity> list = this.mc.level.getEntities(this.mc.player, this.mc.player.bb.expand(vec32.x * d, vec32.y * d, vec32.z * d).grow(f2, f2, f2));
        double d3 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d4;
            Entity entity = list.get(i);
            if (!entity.isPickable()) continue;
            float f3 = entity.getPickRadius();
            AABB aABB = entity.bb.grow(f3, f3, f3);
            HitResult hitResult = aABB.clip(vec3, vec33);
            if (aABB.contains(vec3)) {
                if (!(0.0 < d3) && d3 != 0.0) continue;
                this.hovered = entity;
                d3 = 0.0;
                continue;
            }
            if (hitResult == null || !((d4 = vec3.distanceTo(hitResult.pos)) < d3) && d3 != 0.0) continue;
            this.hovered = entity;
            d3 = d4;
        }
        if (this.hovered != null && !(this.mc.gameMode instanceof CreativeMode)) {
            this.mc.hitResult = new HitResult(this.hovered);
        }
    }

    private float getFov(float f) {
        LocalPlayer localPlayer = this.mc.player;
        float f2 = 70.0f;
        if (localPlayer.isUnderLiquid(Material.water)) {
            f2 = 60.0f;
        }
        if (localPlayer.health <= 0) {
            float f3 = (float)localPlayer.deathTime + f;
            f2 /= (1.0f - 500.0f / (f3 + 500.0f)) * 2.0f + 1.0f;
        }
        return f2;
    }

    private void bobHurt(float f) {
        float f2;
        LocalPlayer localPlayer = this.mc.player;
        float f3 = (float)localPlayer.hurtTime - f;
        if (localPlayer.health <= 0) {
            f2 = (float)localPlayer.deathTime + f;
            GL11.glRotatef((float)(40.0f - 8000.0f / (f2 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (f3 < 0.0f) {
            return;
        }
        f3 /= (float)localPlayer.hurtDuration;
        f3 = Mth.sin(f3 * f3 * f3 * f3 * (float)Math.PI);
        f2 = localPlayer.hurtDir;
        GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f3 * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void bobView(float f) {
        if (this.mc.options.thirdPersonView) {
            return;
        }
        LocalPlayer localPlayer = this.mc.player;
        float f2 = localPlayer.walkDist - localPlayer.walkDistO;
        float f3 = localPlayer.walkDist + f2 * f;
        float f4 = localPlayer.oBob + (localPlayer.bob - localPlayer.oBob) * f;
        float f5 = localPlayer.oTilt + (localPlayer.tilt - localPlayer.oTilt) * f;
        GL11.glTranslatef((float)(Mth.sin(f3 * (float)Math.PI) * f4 * 0.5f), (float)(-Math.abs(Mth.cos(f3 * (float)Math.PI) * f4)), (float)0.0f);
        GL11.glRotatef((float)(Mth.sin(f3 * (float)Math.PI) * f4 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(Math.abs(Mth.cos(f3 * (float)Math.PI + 0.2f) * f4) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)f5, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    private void moveCameraToPlayer(float f) {
        LocalPlayer localPlayer = this.mc.player;
        double d = localPlayer.xo + (localPlayer.x - localPlayer.xo) * (double)f;
        double d2 = localPlayer.yo + (localPlayer.y - localPlayer.yo) * (double)f;
        double d3 = localPlayer.zo + (localPlayer.z - localPlayer.zo) * (double)f;
        if (this.mc.options.thirdPersonView) {
            double d4 = 4.0;
            float f2 = localPlayer.yRot;
            float f3 = localPlayer.xRot;
            if (Keyboard.isKeyDown((int)59)) {
                f3 += 180.0f;
                d4 += 2.0;
            }
            double d5 = (double)(-Mth.sin(f2 / 180.0f * (float)Math.PI) * Mth.cos(f3 / 180.0f * (float)Math.PI)) * d4;
            double d6 = (double)(Mth.cos(f2 / 180.0f * (float)Math.PI) * Mth.cos(f3 / 180.0f * (float)Math.PI)) * d4;
            double d7 = (double)(-Mth.sin(f3 / 180.0f * (float)Math.PI)) * d4;
            for (int i = 0; i < 8; ++i) {
                double d8;
                HitResult hitResult;
                float f4 = (i & 1) * 2 - 1;
                float f5 = (i >> 1 & 1) * 2 - 1;
                float f6 = (i >> 2 & 1) * 2 - 1;
                if ((hitResult = this.mc.level.clip(Vec3.newTemp(d + (double)(f4 *= 0.1f), d2 + (double)(f5 *= 0.1f), d3 + (double)(f6 *= 0.1f)), Vec3.newTemp(d - d5 + (double)f4 + (double)f6, d2 - d7 + (double)f5, d3 - d6 + (double)f6))) == null || !((d8 = hitResult.pos.distanceTo(Vec3.newTemp(d, d2, d3))) < d4)) continue;
                d4 = d8;
            }
            if (Keyboard.isKeyDown((int)59)) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glRotatef((float)(localPlayer.xRot - f3), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(localPlayer.yRot - f2), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-d4)));
            GL11.glRotatef((float)(f2 - localPlayer.yRot), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(f3 - localPlayer.xRot), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.1f);
        }
        GL11.glRotatef((float)(localPlayer.xRotO + (localPlayer.xRot - localPlayer.xRotO) * f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(localPlayer.yRotO + (localPlayer.yRot - localPlayer.yRotO) * f + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void zoomRegion(double d, double d2, double d3) {
        this.zoom = d;
        this.zoom_x = d2;
        this.zoom_y = d3;
    }

    public void unZoomRegion() {
        this.zoom = 1.0;
    }

    private void setupCamera(float f, int n) {
        float f2;
        this.renderDistance = 256 >> this.mc.options.viewDistance;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float f3 = 0.07f;
        if (this.mc.options.anaglyph3d) {
            GL11.glTranslatef((float)((float)(-(n * 2 - 1)) * f3), (float)0.0f, (float)0.0f);
        }
        if (this.zoom != 1.0) {
            GL11.glTranslatef((float)((float)this.zoom_x), (float)((float)(-this.zoom_y)), (float)0.0f);
            GL11.glScaled((double)this.zoom, (double)this.zoom, (double)1.0);
            GLU.gluPerspective((float)this.getFov(f), (float)((float)this.mc.width / (float)this.mc.height), (float)0.05f, (float)this.renderDistance);
        } else {
            GLU.gluPerspective((float)this.getFov(f), (float)((float)this.mc.width / (float)this.mc.height), (float)0.05f, (float)this.renderDistance);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (this.mc.options.anaglyph3d) {
            GL11.glTranslatef((float)((float)(n * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        this.bobHurt(f);
        if (this.mc.options.bobView) {
            this.bobView(f);
        }
        if ((f2 = this.mc.player.oPortalTime + (this.mc.player.portalTime - this.mc.player.oPortalTime) * f) > 0.0f) {
            float f4 = 5.0f / (f2 * f2 + 5.0f) - f2 * 0.04f;
            f4 *= f4;
            GL11.glRotatef((float)(f2 * f2 * 1500.0f), (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)(1.0f / f4), (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)(-f2 * f2 * 1500.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        }
        this.moveCameraToPlayer(f);
    }

    private void renderItemInHand(float f, int n) {
        GL11.glLoadIdentity();
        if (this.mc.options.anaglyph3d) {
            GL11.glTranslatef((float)((float)(n * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        this.bobHurt(f);
        if (this.mc.options.bobView) {
            this.bobView(f);
        }
        if (!this.mc.options.thirdPersonView && !Keyboard.isKeyDown((int)59)) {
            this.itemInHandRenderer.render(f);
        }
        GL11.glPopMatrix();
        if (!this.mc.options.thirdPersonView) {
            this.itemInHandRenderer.renderScreenEffect(f);
            this.bobHurt(f);
        }
        if (this.mc.options.bobView) {
            this.bobView(f);
        }
    }

    public void render(float f) {
        int n;
        if (!Display.isActive()) {
            if (System.currentTimeMillis() - this.lastActiveTime > 500L) {
                // empty if block
            }
        } else {
            this.lastActiveTime = System.currentTimeMillis();
        }
        if (this.mc.mouseGrabbed) {
            this.mc.mouseHandler.poll();
            float f2 = this.mc.options.sensitivity * 0.6f + 0.2f;
            float f3 = f2 * f2 * f2 * 8.0f;
            float f4 = (float)this.mc.mouseHandler.xd * f3;
            float f5 = (float)this.mc.mouseHandler.yd * f3;
            n = 1;
            if (this.mc.options.invertYMouse) {
                n = -1;
            }
            this.mc.player.turn(f4, f5 * (float)n);
        }
        if (this.mc.noRender) {
            return;
        }
        ScreenSizeCalculator screenSizeCalculator = new ScreenSizeCalculator(this.mc.width, this.mc.height);
        int n2 = screenSizeCalculator.getWidth();
        int n3 = screenSizeCalculator.getHeight();
        int n4 = Mouse.getX() * n2 / this.mc.width;
        n = n3 - Mouse.getY() * n3 / this.mc.height - 1;
        if (this.mc.level != null) {
            this.renderLevel(f);
            if (!Keyboard.isKeyDown((int)59)) {
                this.mc.gui.render(f, this.mc.screen != null, n4, n);
            }
        } else {
            GL11.glViewport((int)0, (int)0, (int)this.mc.width, (int)this.mc.height);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            this.setupGuiScreen();
        }
        if (this.mc.screen != null) {
            GL11.glClear((int)256);
            this.mc.screen.render(n4, n, f);
        }
    }

    public void renderLevel(float f) {
        int n;
        this.pick(f);
        LocalPlayer localPlayer = this.mc.player;
        LevelRenderer levelRenderer = this.mc.levelRenderer;
        ParticleEngine particleEngine = this.mc.particleEngine;
        double d = localPlayer.xOld + (localPlayer.x - localPlayer.xOld) * (double)f;
        double d2 = localPlayer.yOld + (localPlayer.y - localPlayer.yOld) * (double)f;
        double d3 = localPlayer.zOld + (localPlayer.z - localPlayer.zOld) * (double)f;
        ChunkSource chunkSource = this.mc.level.getChunkSource();
        if (chunkSource instanceof ChunkCache) {
            ChunkCache chunkCache = (ChunkCache)chunkSource;
            int n2 = Mth.floor((int)d) >> 4;
            n = Mth.floor((int)d3) >> 4;
            chunkCache.centerOn(n2, n);
        }
        for (int i = 0; i < 2; ++i) {
            if (this.mc.options.anaglyph3d) {
                if (i == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                }
            }
            GL11.glViewport((int)0, (int)0, (int)this.mc.width, (int)this.mc.height);
            this.setupClearColor(f);
            GL11.glClear((int)16640);
            GL11.glEnable((int)2884);
            this.setupCamera(f, i);
            Frustum.getFrustum();
            if (this.mc.options.viewDistance < 2) {
                this.setupFog(-1);
                levelRenderer.renderSky(f);
            }
            GL11.glEnable((int)2912);
            this.setupFog(1);
            FrustumCuller frustumCuller = new FrustumCuller();
            frustumCuller.prepare(d, d2, d3);
            this.mc.levelRenderer.cull(frustumCuller, f);
            this.mc.levelRenderer.updateDirtyChunks(localPlayer, false);
            this.setupFog(0);
            GL11.glEnable((int)2912);
            GL11.glBindTexture((int)3553, (int)this.mc.textures.loadTexture("/terrain.png"));
            Lighting.turnOff();
            levelRenderer.render(localPlayer, 0, f);
            Lighting.turnOn();
            levelRenderer.renderEntities(localPlayer.getPos(f), frustumCuller, f);
            particleEngine.renderLit(localPlayer, f);
            Lighting.turnOff();
            this.setupFog(0);
            particleEngine.render(localPlayer, f);
            if (this.mc.hitResult != null && localPlayer.isUnderLiquid(Material.water)) {
                GL11.glDisable((int)3008);
                levelRenderer.renderHit(localPlayer, this.mc.hitResult, 0, localPlayer.inventory.getSelected(), f);
                levelRenderer.renderHitOutline(localPlayer, this.mc.hitResult, 0, localPlayer.inventory.getSelected(), f);
                GL11.glEnable((int)3008);
            }
            GL11.glBlendFunc((int)770, (int)771);
            this.setupFog(0);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glBindTexture((int)3553, (int)this.mc.textures.loadTexture("/terrain.png"));
            if (this.mc.options.fancyGraphics) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                n = levelRenderer.render(localPlayer, 1, f);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                if (this.mc.options.anaglyph3d) {
                    if (i == 0) {
                        GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                    } else {
                        GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                    }
                }
                if (n > 0) {
                    levelRenderer.renderSameAsLast(1, f);
                }
            } else {
                levelRenderer.render(localPlayer, 1, f);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            if (this.zoom == 1.0 && this.mc.hitResult != null && !localPlayer.isUnderLiquid(Material.water)) {
                GL11.glDisable((int)3008);
                levelRenderer.renderHit(localPlayer, this.mc.hitResult, 0, localPlayer.inventory.getSelected(), f);
                levelRenderer.renderHitOutline(localPlayer, this.mc.hitResult, 0, localPlayer.inventory.getSelected(), f);
                GL11.glEnable((int)3008);
            }
            GL11.glDisable((int)2912);
            if (this.hovered != null) {
                // empty if block
            }
            this.setupFog(0);
            GL11.glEnable((int)2912);
            levelRenderer.renderClouds(f);
            GL11.glDisable((int)2912);
            this.setupFog(1);
            if (this.zoom == 1.0) {
                GL11.glClear((int)256);
                this.renderItemInHand(f, i);
            }
            if (this.mc.options.anaglyph3d) continue;
            return;
        }
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    private void tickRain() {
        if (!this.mc.options.fancyGraphics) {
            return;
        }
        LocalPlayer localPlayer = this.mc.player;
        Level level = this.mc.level;
        int n = Mth.floor(localPlayer.x);
        int n2 = Mth.floor(localPlayer.y);
        int n3 = Mth.floor(localPlayer.z);
        int n4 = 16;
        for (int i = 0; i < 150; ++i) {
            int n5 = n + this.random.nextInt(n4) - this.random.nextInt(n4);
            int n6 = n3 + this.random.nextInt(n4) - this.random.nextInt(n4);
            int n7 = level.getLightDepth(n5, n6);
            int n8 = level.getTile(n5, n7 - 1, n6);
            if (n7 > n2 + n4 || n7 < n2 - n4) continue;
            float f = this.random.nextFloat();
            float f2 = this.random.nextFloat();
            if (n8 <= 0) continue;
            this.mc.particleEngine.add(new WaterDropParticle(level, (float)n5 + f, (double)((float)n7 + 0.1f) - Tile.tiles[n8].yy0, (float)n6 + f2));
        }
    }

    protected void renderSnow(float f) {
        LocalPlayer localPlayer = this.mc.player;
        Level level = this.mc.level;
        int n = Mth.floor(localPlayer.x);
        int n2 = Mth.floor(localPlayer.y);
        int n3 = Mth.floor(localPlayer.z);
        Tesselator tesselator = Tesselator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBindTexture((int)3553, (int)this.mc.textures.loadTexture("/environment/snow.png"));
        double d = localPlayer.xOld + (localPlayer.x - localPlayer.xOld) * (double)f;
        double d2 = localPlayer.yOld + (localPlayer.y - localPlayer.yOld) * (double)f;
        double d3 = localPlayer.zOld + (localPlayer.z - localPlayer.zOld) * (double)f;
        int n4 = 5;
        if (this.mc.options.fancyGraphics) {
            n4 = 10;
        }
        for (int i = n - n4; i <= n + n4; ++i) {
            for (int j = n3 - n4; j <= n3 + n4; ++j) {
                int n5 = level.getTopSolidBlock(i, j);
                if (n5 < 0) {
                    n5 = 0;
                }
                int n6 = n2 - n4;
                int n7 = n2 + n4;
                if (n6 < n5) {
                    n6 = n5;
                }
                if (n7 < n5) {
                    n7 = n5;
                }
                float f2 = 2.0f;
                if (n6 == n7) continue;
                this.random.setSeed(i * i * 3121 + i * 45238971 + j * j * 418711 + j * 13761);
                float f3 = (float)this.tick + f;
                float f4 = ((float)(this.tick & 0x1FF) + f) / 512.0f;
                float f5 = this.random.nextFloat() + f3 * 0.01f * (float)this.random.nextGaussian();
                float f6 = this.random.nextFloat() + f3 * (float)this.random.nextGaussian() * 0.001f;
                double d4 = (double)((float)i + 0.5f) - localPlayer.x;
                double d5 = (double)((float)j + 0.5f) - localPlayer.z;
                float f7 = Mth.sqrt(d4 * d4 + d5 * d5) / (float)n4;
                tesselator.begin();
                float f8 = level.getBrightness(i, 128, j);
                GL11.glColor4f((float)f8, (float)f8, (float)f8, (float)((1.0f - f7 * f7) * 0.7f));
                tesselator.offset(-d * 1.0, -d2 * 1.0, -d3 * 1.0);
                tesselator.vertexUV(i + 0, n6, j + 0, 0.0f * f2 + f5, (float)n6 * f2 / 8.0f + f4 * f2 + f6);
                tesselator.vertexUV(i + 1, n6, j + 1, 1.0f * f2 + f5, (float)n6 * f2 / 8.0f + f4 * f2 + f6);
                tesselator.vertexUV(i + 1, n7, j + 1, 1.0f * f2 + f5, (float)n7 * f2 / 8.0f + f4 * f2 + f6);
                tesselator.vertexUV(i + 0, n7, j + 0, 0.0f * f2 + f5, (float)n7 * f2 / 8.0f + f4 * f2 + f6);
                tesselator.vertexUV(i + 0, n6, j + 1, 0.0f * f2 + f5, (float)n6 * f2 / 8.0f + f4 * f2 + f6);
                tesselator.vertexUV(i + 1, n6, j + 0, 1.0f * f2 + f5, (float)n6 * f2 / 8.0f + f4 * f2 + f6);
                tesselator.vertexUV(i + 1, n7, j + 0, 1.0f * f2 + f5, (float)n7 * f2 / 8.0f + f4 * f2 + f6);
                tesselator.vertexUV(i + 0, n7, j + 1, 0.0f * f2 + f5, (float)n7 * f2 / 8.0f + f4 * f2 + f6);
                tesselator.offset(0.0, 0.0, 0.0);
                tesselator.end();
            }
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    protected void renderRain(float f) {
        LocalPlayer localPlayer = this.mc.player;
        Level level = this.mc.level;
        int n = Mth.floor(localPlayer.x);
        int n2 = Mth.floor(localPlayer.y);
        int n3 = Mth.floor(localPlayer.z);
        Tesselator tesselator = Tesselator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBindTexture((int)3553, (int)this.mc.textures.loadTexture("/environment/rain.png"));
        double d = localPlayer.xOld + (localPlayer.x - localPlayer.xOld) * (double)f;
        double d2 = localPlayer.yOld + (localPlayer.y - localPlayer.yOld) * (double)f;
        double d3 = localPlayer.zOld + (localPlayer.z - localPlayer.zOld) * (double)f;
        int n4 = 5;
        if (this.mc.options.fancyGraphics) {
            n4 = 10;
        }
        for (int i = n - n4; i <= n + n4; ++i) {
            for (int j = n3 - n4; j <= n3 + n4; ++j) {
                int n5 = level.getLightDepth(i, j);
                int n6 = n2 - n4;
                int n7 = n2 + n4;
                if (n6 < n5) {
                    n6 = n5;
                }
                if (n7 < n5) {
                    n7 = n5;
                }
                float f2 = 2.0f;
                if (n6 == n7) continue;
                float f3 = ((float)(this.tick + i * i * 3121 + i * 45238971 + j * j * 418711 + j * 13761 & 0x1F) + f) / 32.0f;
                double d4 = (double)((float)i + 0.5f) - localPlayer.x;
                double d5 = (double)((float)j + 0.5f) - localPlayer.z;
                float f4 = Mth.sqrt(d4 * d4 + d5 * d5) / (float)n4;
                tesselator.begin();
                float f5 = level.getBrightness(i, 128, j);
                GL11.glColor4f((float)f5, (float)f5, (float)f5, (float)((1.0f - f4 * f4) * 0.7f));
                tesselator.offset(-d * 1.0, -d2 * 1.0, -d3 * 1.0);
                tesselator.vertexUV(i + 0, n6, j + 0, 0.0f * f2, (float)n6 * f2 / 8.0f + f3 * f2);
                tesselator.vertexUV(i + 1, n6, j + 1, 1.0f * f2, (float)n6 * f2 / 8.0f + f3 * f2);
                tesselator.vertexUV(i + 1, n7, j + 1, 1.0f * f2, (float)n7 * f2 / 8.0f + f3 * f2);
                tesselator.vertexUV(i + 0, n7, j + 0, 0.0f * f2, (float)n7 * f2 / 8.0f + f3 * f2);
                tesselator.vertexUV(i + 0, n6, j + 1, 0.0f * f2, (float)n6 * f2 / 8.0f + f3 * f2);
                tesselator.vertexUV(i + 1, n6, j + 0, 1.0f * f2, (float)n6 * f2 / 8.0f + f3 * f2);
                tesselator.vertexUV(i + 1, n7, j + 0, 1.0f * f2, (float)n7 * f2 / 8.0f + f3 * f2);
                tesselator.vertexUV(i + 0, n7, j + 1, 0.0f * f2, (float)n7 * f2 / 8.0f + f3 * f2);
                tesselator.offset(0.0, 0.0, 0.0);
                tesselator.end();
            }
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    public void setupGuiScreen() {
        ScreenSizeCalculator screenSizeCalculator = new ScreenSizeCalculator(this.mc.width, this.mc.height);
        int n = screenSizeCalculator.getWidth();
        int n2 = screenSizeCalculator.getHeight();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)n, (double)n2, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private void setupClearColor(float f) {
        Level level = this.mc.level;
        LocalPlayer localPlayer = this.mc.player;
        float f2 = 1.0f / (float)(4 - this.mc.options.viewDistance);
        f2 = 1.0f - (float)Math.pow(f2, 0.25);
        Vec3 vec3 = level.getSkyColor(this.mc.player, f);
        float f3 = (float)vec3.x;
        float f4 = (float)vec3.y;
        float f5 = (float)vec3.z;
        Vec3 vec32 = level.getFogColor(f);
        this.fr = (float)vec32.x;
        this.fg = (float)vec32.y;
        this.fb = (float)vec32.z;
        this.fr += (f3 - this.fr) * f2;
        this.fg += (f4 - this.fg) * f2;
        this.fb += (f5 - this.fb) * f2;
        if (localPlayer.isUnderLiquid(Material.water)) {
            this.fr = 0.02f;
            this.fg = 0.02f;
            this.fb = 0.2f;
        } else if (localPlayer.isUnderLiquid(Material.lava)) {
            this.fr = 0.6f;
            this.fg = 0.1f;
            this.fb = 0.0f;
        }
        float f6 = this.fogBrO + (this.fogBr - this.fogBrO) * f;
        this.fr *= f6;
        this.fg *= f6;
        this.fb *= f6;
        if (this.mc.options.anaglyph3d) {
            float f7 = (this.fr * 30.0f + this.fg * 59.0f + this.fb * 11.0f) / 100.0f;
            float f8 = (this.fr * 30.0f + this.fg * 70.0f) / 100.0f;
            float f9 = (this.fr * 30.0f + this.fb * 70.0f) / 100.0f;
            this.fr = f7;
            this.fg = f8;
            this.fb = f9;
        }
        GL11.glClearColor((float)this.fr, (float)this.fg, (float)this.fb, (float)0.0f);
    }

    private void setupFog(int n) {
        LocalPlayer localPlayer = this.mc.player;
        GL11.glFog((int)2918, (FloatBuffer)this.getBuffer(this.fr, this.fg, this.fb, 1.0f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (localPlayer.isUnderLiquid(Material.water)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.1f);
            float f = 0.4f;
            float f2 = 0.4f;
            float f3 = 0.9f;
            if (this.mc.options.anaglyph3d) {
                float f4 = (f * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
                float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
                float f6 = (f * 30.0f + f3 * 70.0f) / 100.0f;
                f = f4;
                f2 = f5;
                f3 = f6;
            }
        } else if (localPlayer.isUnderLiquid(Material.lava)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)2.0f);
            float f = 0.4f;
            float f7 = 0.3f;
            float f8 = 0.3f;
            if (this.mc.options.anaglyph3d) {
                float f9 = (f * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                float f10 = (f * 30.0f + f7 * 70.0f) / 100.0f;
                float f11 = (f * 30.0f + f8 * 70.0f) / 100.0f;
                f = f9;
                f7 = f10;
                f8 = f11;
            }
        } else {
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)(this.renderDistance * 0.25f));
            GL11.glFogf((int)2916, (float)this.renderDistance);
            if (n < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(this.renderDistance * 0.8f));
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi((int)34138, (int)34139);
            }
            if (this.mc.level.dimension.foggy) {
                GL11.glFogf((int)2915, (float)0.0f);
            }
        }
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
    }

    private FloatBuffer getBuffer(float f, float f2, float f3, float f4) {
        this.lb.clear();
        this.lb.put(f).put(f2).put(f3).put(f4);
        this.lb.flip();
        return this.lb;
    }

    public void updateAllChunks() {
        this.mc.levelRenderer.updateDirtyChunks(this.mc.player, true);
    }
}

