/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.TileRenderer;
import net.minecraft.client.renderer.culling.Culler;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Region;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.TileEntity;
import net.minecraft.world.phys.AABB;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class Chunk {
    public Level level;
    private int lists = -1;
    private static Tesselator t = Tesselator.instance;
    public static int updates = 0;
    public int x;
    public int y;
    public int z;
    public int xs;
    public int ys;
    public int zs;
    public int xRender;
    public int yRender;
    public int zRender;
    public int xRenderOffs;
    public int yRenderOffs;
    public int zRenderOffs;
    public boolean visible = false;
    public boolean[] empty = new boolean[2];
    public int xm;
    public int ym;
    public int zm;
    public float radius;
    public boolean dirty;
    public AABB bb;
    public int id;
    public boolean occlusion_visible = true;
    public boolean occlusion_querying;
    public int occlusion_id;
    public boolean skyLit;
    private boolean compiled = false;
    public List<TileEntity> renderableTileEntities = new ArrayList<TileEntity>();
    private List<TileEntity> globalRenderableTileEntities;

    public Chunk(Level level, List<TileEntity> globalRenderableTileEntities, int x, int y, int z, int size, int lists) {
        this.level = level;
        this.globalRenderableTileEntities = globalRenderableTileEntities;
        this.ys = this.zs = size;
        this.xs = this.zs;
        this.radius = Mth.sqrt(this.xs * this.xs + this.ys * this.ys + this.zs * this.zs) / 2.0f;
        this.lists = lists;
        this.x = -999;
        this.setPos(x, y, z);
        this.dirty = false;
    }

    public void setPos(int x, int y, int z) {
        if (x == this.x && y == this.y && z == this.z) {
            return;
        }
        this.reset();
        this.x = x;
        this.y = y;
        this.z = z;
        this.xm = x + this.xs / 2;
        this.ym = y + this.ys / 2;
        this.zm = z + this.zs / 2;
        this.xRenderOffs = x & 0x3FF;
        this.yRenderOffs = y;
        this.zRenderOffs = z & 0x3FF;
        this.xRender = x - this.xRenderOffs;
        this.yRender = y - this.yRenderOffs;
        this.zRender = z - this.zRenderOffs;
        float g = 6.0f;
        this.bb = AABB.newPermanent((float)x - g, (float)y - g, (float)z - g, (float)(x + this.xs) + g, (float)(y + this.ys) + g, (float)(z + this.zs) + g);
        GL11.glNewList((int)(this.lists + 2), (int)4864);
        ItemRenderer.renderFlat(AABB.newTemp((float)this.xRenderOffs - g, (float)this.yRenderOffs - g, (float)this.zRenderOffs - g, (float)(this.xRenderOffs + this.xs) + g, (float)(this.yRenderOffs + this.ys) + g, (float)(this.zRenderOffs + this.zs) + g));
        GL11.glEndList();
        this.setDirty();
    }

    private void translateToPos() {
        GL11.glTranslatef((float)this.xRenderOffs, (float)this.yRenderOffs, (float)this.zRenderOffs);
    }

    public void rebuild() {
        if (!this.dirty) {
            return;
        }
        ++updates;
        int x0 = this.x;
        int y0 = this.y;
        int z0 = this.z;
        int x1 = this.x + this.xs;
        int y1 = this.y + this.ys;
        int z1 = this.z + this.zs;
        int l = 0;
        while (l < 2) {
            this.empty[l] = true;
            ++l;
        }
        LevelChunk.touchedSky = false;
        HashSet<TileEntity> oldTileEntities = new HashSet<TileEntity>();
        oldTileEntities.addAll(this.renderableTileEntities);
        this.renderableTileEntities.clear();
        int r = 1;
        Region region = new Region(this.level, x0 - r, y0 - r, z0 - r, x1 + r, y1 + r, z1 + r);
        TileRenderer tileRenderer = new TileRenderer(region);
        int l2 = 0;
        while (l2 < 2) {
            boolean renderNextLayer = false;
            boolean rendered = false;
            boolean started = false;
            int y = y0;
            while (y < y1) {
                int z = z0;
                while (z < z1) {
                    int x = x0;
                    while (x < x1) {
                        int tileId = region.getTile(x, y, z);
                        if (tileId > 0) {
                            Tile tile;
                            int renderLayer;
                            TileEntity et;
                            if (!started) {
                                started = true;
                                GL11.glNewList((int)(this.lists + l2), (int)4864);
                                GL11.glPushMatrix();
                                this.translateToPos();
                                float ss = 1.000001f;
                                GL11.glTranslatef((float)((float)(-this.zs) / 2.0f), (float)((float)(-this.ys) / 2.0f), (float)((float)(-this.zs) / 2.0f));
                                GL11.glScalef((float)ss, (float)ss, (float)ss);
                                GL11.glTranslatef((float)((float)this.zs / 2.0f), (float)((float)this.ys / 2.0f), (float)((float)this.zs / 2.0f));
                                t.begin();
                                t.offset(-this.x, -this.y, -this.z);
                            }
                            if (l2 == 0 && Tile.isEntityTile[tileId] && TileEntityRenderDispatcher.instance.hasRenderer(et = region.getTileEntity(x, y, z))) {
                                this.renderableTileEntities.add(et);
                            }
                            if ((renderLayer = (tile = Tile.tiles[tileId]).getRenderLayer()) != l2) {
                                renderNextLayer = true;
                            } else if (renderLayer == l2) {
                                rendered |= tileRenderer.tesselateInWorld(tile, x, y, z);
                            }
                        }
                        ++x;
                    }
                    ++z;
                }
                ++y;
            }
            if (started) {
                t.end();
                GL11.glPopMatrix();
                GL11.glEndList();
                t.offset(0.0, 0.0, 0.0);
            } else {
                rendered = false;
            }
            if (rendered) {
                this.empty[l2] = false;
            }
            if (!renderNextLayer) break;
            ++l2;
        }
        HashSet<TileEntity> newTileEntities = new HashSet<TileEntity>();
        newTileEntities.addAll(this.renderableTileEntities);
        newTileEntities.removeAll(oldTileEntities);
        this.globalRenderableTileEntities.addAll(newTileEntities);
        oldTileEntities.removeAll(this.renderableTileEntities);
        this.globalRenderableTileEntities.removeAll(oldTileEntities);
        this.skyLit = LevelChunk.touchedSky;
        this.compiled = true;
    }

    public float distanceToSqr(Entity player) {
        float xd = (float)(player.x - (double)this.xm);
        float yd = (float)(player.y - (double)this.ym);
        float zd = (float)(player.z - (double)this.zm);
        return xd * xd + yd * yd + zd * zd;
    }

    public float squishedDistanceToSqr(Entity player) {
        float xd = (float)(player.x - (double)this.xm);
        float yd = (float)(player.y - (double)this.ym) * 2.0f;
        float zd = (float)(player.z - (double)this.zm);
        return xd * xd + yd * yd + zd * zd;
    }

    public void reset() {
        int i = 0;
        while (i < 2) {
            this.empty[i] = true;
            ++i;
        }
        this.visible = false;
        this.compiled = false;
    }

    public void delete() {
        this.reset();
        this.level = null;
    }

    public int getList(int layer) {
        if (!this.visible) {
            return -1;
        }
        if (!this.empty[layer]) {
            return this.lists + layer;
        }
        return -1;
    }

    public int getAllLists(int[] displayLists, int p, int layer) {
        if (!this.visible) {
            return p;
        }
        if (!this.empty[layer]) {
            displayLists[p++] = this.lists + layer;
        }
        return p;
    }

    public void cull(Culler culler) {
        this.visible = culler.isVisible(this.bb);
    }

    public void renderBB() {
        GL11.glCallList((int)(this.lists + 2));
    }

    public boolean isEmpty() {
        if (!this.compiled) {
            return false;
        }
        return this.empty[0] && this.empty[1];
    }

    public void setDirty() {
        this.dirty = true;
    }
}

