/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import net.minecraft.client.player.Input;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import util.Mth;

public class RemotePlayer
extends Player {
    public Input input;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    float fallTime = 0.0f;

    public RemotePlayer(Level level, String name) {
        super(level);
        this.name = name;
        this.heightOffset = 0.0f;
        this.footSize = 0.0f;
        if (name != null && name.length() > 0) {
            this.customTextureUrl = "http://s3.amazonaws.com/MinecraftSkins/" + name + ".png";
            System.out.println("Loading texture " + this.customTextureUrl);
        }
        this.noPhysics = true;
        this.viewScale = 10.0;
    }

    @Override
    public boolean hurt(Entity source, int dmg) {
        return true;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.heightOffset = 0.0f;
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yRot;
        this.lxr = xRot;
        this.lSteps = steps;
    }

    @Override
    public void tick() {
        super.tick();
        this.walkAnimSpeedO = this.walkAnimSpeed;
        double xxd = this.x - this.xo;
        double zzd = this.z - this.zo;
        float wst = Mth.sqrt(xxd * xxd + zzd * zzd) * 4.0f;
        if (wst > 1.0f) {
            wst = 1.0f;
        }
        this.walkAnimSpeed += (wst - this.walkAnimSpeed) * 0.4f;
        this.walkAnimPos += this.walkAnimSpeed;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    @Override
    public void aiStep() {
        super.updateAi();
        if (this.lSteps > 0) {
            double xt = this.x + (this.lx - this.x) / (double)this.lSteps;
            double yt = this.y + (this.ly - this.y) / (double)this.lSteps;
            double zt = this.z + (this.lz - this.z) / (double)this.lSteps;
            double yrd = this.lyr - (double)this.yRot;
            while (yrd < -180.0) {
                yrd += 360.0;
            }
            while (yrd >= 180.0) {
                yrd -= 360.0;
            }
            this.yRot = (float)((double)this.yRot + yrd / (double)this.lSteps);
            this.xRot = (float)((double)this.xRot + (this.lxr - (double)this.xRot) / (double)this.lSteps);
            --this.lSteps;
            this.setPos(xt, yt, zt);
            this.setRot(this.yRot, this.xRot);
        }
        this.oBob = this.bob;
        float tBob = Mth.sqrt(this.xd * this.xd + this.zd * this.zd);
        float tTilt = (float)Math.atan(-this.yd * (double)0.2f) * 15.0f;
        if (tBob > 0.1f) {
            tBob = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            tBob = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            tTilt = 0.0f;
        }
        this.bob += (tBob - this.bob) * 0.4f;
        this.tilt += (tTilt - this.tilt) * 0.8f;
    }

    @Override
    public void setEquippedSlot(int slot, int itemId, int auxValue) {
        ItemInstance item = null;
        if (itemId >= 0) {
            item = new ItemInstance(itemId, 1, auxValue);
        }
        if (slot == 0) {
            this.inventory.items[this.inventory.selected] = item;
        } else {
            this.inventory.armor[slot - 1] = item;
        }
    }
}

