/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import net.minecraft.client.player.Input;
import net.minecraft.world.entity.player.Player;
import org.lwjgl.input.Controller;

public class ControllerInput
extends Input {
    private Controller controller;
    private boolean lReset = false;
    private boolean rReset = false;

    public ControllerInput(Controller controller) {
        this.controller = controller;
        controller.setXAxisDeadZone(0.15f);
        controller.setYAxisDeadZone(0.15f);
        controller.setRXAxisDeadZone(0.2f);
        controller.setRYAxisDeadZone(0.2f);
    }

    @Override
    public void releaseAllKeys() {
    }

    @Override
    public void tick(Player player) {
        this.controller.poll();
        this.xa = this.controller.getXAxisValue();
        this.ya = this.controller.getYAxisValue();
        if (!this.lReset) {
            if (this.xa * this.xa + this.ya * this.ya == 0.0f) {
                this.lReset = true;
            }
            this.ya = 0.0f;
            this.xa = 0.0f;
        }
        float turnSpeed = 50.0f;
        float tx = this.controller.getRXAxisValue();
        float ty = this.controller.getRYAxisValue();
        if (!this.rReset) {
            if (tx * tx + ty * ty == 0.0f) {
                this.rReset = true;
            }
            ty = 0.0f;
            tx = 0.0f;
        }
        player.interpolateTurn(tx * Math.abs(tx) * turnSpeed, ty * Math.abs(ty) * turnSpeed);
        this.jumping = this.controller.isButtonPressed(0);
    }
}

