/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.LiquidTile;
import util.Mth;

public class WaterDropParticle
extends Particle {
    public WaterDropParticle(Level level, double x, double y, double z) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= (double)0.3f;
        this.yd = (float)Math.random() * 0.2f + 0.1f;
        this.zd *= (double)0.3f;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.tex = 19 + this.random.nextInt(4);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        super.render(t, a, xa, ya, za, xa2, za2);
    }

    @Override
    public void tick() {
        double y0;
        Material m;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (this.onGround) {
            if (Math.random() < 0.5) {
                this.remove();
            }
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
        if (((m = this.level.getMaterial(Mth.floor(this.x), Mth.floor(this.y), Mth.floor(this.z))).isLiquid() || m.isSolid()) && this.y < (y0 = (double)((float)(Mth.floor(this.y) + 1) - LiquidTile.getHeight(this.level.getData(Mth.floor(this.x), Mth.floor(this.y), Mth.floor(this.z)))))) {
            this.remove();
        }
    }
}

