/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;

public class TerrainParticle
extends Particle {
    private Tile tile;

    public TerrainParticle(Level level, double x, double y, double z, double xa, double ya, double za, Tile tile) {
        super(level, x, y, z, xa, ya, za);
        this.tile = tile;
        this.tex = tile.tex;
        this.gravity = tile.gravity;
        this.bCol = 0.6f;
        this.gCol = 0.6f;
        this.rCol = 0.6f;
        this.size /= 2.0f;
    }

    public TerrainParticle init(int x, int y, int z) {
        if (this.tile == Tile.grass) {
            return this;
        }
        int col = this.tile.getColor(this.level, x, y, z);
        this.rCol *= (float)(col >> 16 & 0xFF) / 255.0f;
        this.gCol *= (float)(col >> 8 & 0xFF) / 255.0f;
        this.bCol *= (float)(col & 0xFF) / 255.0f;
        return this;
    }

    @Override
    public int getParticleTexture() {
        return 1;
    }

    @Override
    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        float u0 = ((float)(this.tex % 16) + this.uo / 4.0f) / 16.0f;
        float u1 = u0 + 0.015609375f;
        float v0 = ((float)(this.tex / 16) + this.vo / 4.0f) / 16.0f;
        float v1 = v0 + 0.015609375f;
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)a - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)a - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)a - zOff);
        float br = this.getBrightness(a);
        t.color(br * this.rCol, br * this.gCol, br * this.bCol);
        t.vertexUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u0, v1);
        t.vertexUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u0, v0);
        t.vertexUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u1, v0);
        t.vertexUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u1, v1);
    }
}

