/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.level.Level;

public class RedDustParticle
extends Particle {
    float oSize;

    public RedDustParticle(Level level, double x, double y, double z) {
        this(level, x, y, z, 1.0f);
    }

    public RedDustParticle(Level level, double x, double y, double z, float scale) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.rCol = (float)(Math.random() * (double)0.3f) + 0.7f;
        this.gCol = this.bCol = (float)(Math.random() * (double)0.1f);
        this.size *= 0.75f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime = (int)((float)this.lifetime * scale);
        this.noPhysics = false;
    }

    @Override
    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        float l = ((float)this.age + a) / (float)this.lifetime * 32.0f;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        this.size = this.oSize * l;
        super.render(t, a, xa, ya, za, xa2, za2);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.tex = 7 - this.age * 8 / this.lifetime;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= (double)0.96f;
        this.yd *= (double)0.96f;
        this.zd *= (double)0.96f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }
}

