/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.Textures;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;
import org.lwjgl.opengl.GL11;
import util.Mth;

public class ParticleEngine {
    public static final int MISC_TEXTURE = 0;
    public static final int TERRAIN_TEXTURE = 1;
    public static final int ITEM_TEXTURE = 2;
    public static final int ENTITY_PARTICLE_TEXTURE = 3;
    public static final int TEXTURE_COUNT = 4;
    protected Level level;
    private List<Particle>[] particles = new List[4];
    private Textures textures;
    private Random random = new Random();

    public ParticleEngine(Level level, Textures textures) {
        if (level != null) {
            this.level = level;
        }
        this.textures = textures;
        int i = 0;
        while (i < 4) {
            this.particles[i] = new ArrayList<Particle>();
            ++i;
        }
    }

    public void add(Particle p) {
        int t = p.getParticleTexture();
        this.particles[t].add(p);
    }

    public void tick() {
        int tt = 0;
        while (tt < 4) {
            int i = 0;
            while (i < this.particles[tt].size()) {
                Particle p = this.particles[tt].get(i);
                p.tick();
                if (p.removed) {
                    this.particles[tt].remove(i--);
                }
                ++i;
            }
            ++tt;
        }
    }

    public void render(Entity player, float a) {
        float xa = Mth.cos(player.yRot * (float)Math.PI / 180.0f);
        float za = Mth.sin(player.yRot * (float)Math.PI / 180.0f);
        float xa2 = -za * Mth.sin(player.xRot * (float)Math.PI / 180.0f);
        float za2 = xa * Mth.sin(player.xRot * (float)Math.PI / 180.0f);
        float ya = Mth.cos(player.xRot * (float)Math.PI / 180.0f);
        Particle.xOff = player.xOld + (player.x - player.xOld) * (double)a;
        Particle.yOff = player.yOld + (player.y - player.yOld) * (double)a;
        Particle.zOff = player.zOld + (player.z - player.zOld) * (double)a;
        int tt = 0;
        while (tt < 3) {
            if (this.particles[tt].size() != 0) {
                int id = 0;
                if (tt == 0) {
                    id = this.textures.loadTexture("/particles.png");
                }
                if (tt == 1) {
                    id = this.textures.loadTexture("/terrain.png");
                }
                if (tt == 2) {
                    id = this.textures.loadTexture("/gui/items.png");
                }
                GL11.glBindTexture((int)3553, (int)id);
                Tesselator t = Tesselator.instance;
                t.begin();
                int i = 0;
                while (i < this.particles[tt].size()) {
                    Particle p = this.particles[tt].get(i);
                    p.render(t, a, xa, ya, za, xa2, za2);
                    ++i;
                }
                t.end();
            }
            ++tt;
        }
    }

    public void renderLit(Entity player, float a) {
        int tt = 3;
        if (this.particles[tt].size() == 0) {
            return;
        }
        Tesselator t = Tesselator.instance;
        int i = 0;
        while (i < this.particles[tt].size()) {
            Particle p = this.particles[tt].get(i);
            p.render(t, a, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            ++i;
        }
    }

    public void setLevel(Level level) {
        this.level = level;
        int tt = 0;
        while (tt < 4) {
            this.particles[tt].clear();
            ++tt;
        }
    }

    public void destroy(int x, int y, int z) {
        int tid = this.level.getTile(x, y, z);
        if (tid == 0) {
            return;
        }
        Tile tile = Tile.tiles[tid];
        int SD = 4;
        int xx = 0;
        while (xx < SD) {
            int yy = 0;
            while (yy < SD) {
                int zz = 0;
                while (zz < SD) {
                    double xp = (double)x + ((double)xx + 0.5) / (double)SD;
                    double yp = (double)y + ((double)yy + 0.5) / (double)SD;
                    double zp = (double)z + ((double)zz + 0.5) / (double)SD;
                    this.add(new TerrainParticle(this.level, xp, yp, zp, xp - (double)x - 0.5, yp - (double)y - 0.5, zp - (double)z - 0.5, tile).init(x, y, z));
                    ++zz;
                }
                ++yy;
            }
            ++xx;
        }
    }

    public void crack(int x, int y, int z, int face) {
        int tid = this.level.getTile(x, y, z);
        if (tid == 0) {
            return;
        }
        Tile tile = Tile.tiles[tid];
        float r = 0.1f;
        double xp = (double)x + this.random.nextDouble() * (tile.xx1 - tile.xx0 - (double)(r * 2.0f)) + (double)r + tile.xx0;
        double yp = (double)y + this.random.nextDouble() * (tile.yy1 - tile.yy0 - (double)(r * 2.0f)) + (double)r + tile.yy0;
        double zp = (double)z + this.random.nextDouble() * (tile.zz1 - tile.zz0 - (double)(r * 2.0f)) + (double)r + tile.zz0;
        if (face == 0) {
            yp = (double)y + tile.yy0 - (double)r;
        }
        if (face == 1) {
            yp = (double)y + tile.yy1 + (double)r;
        }
        if (face == 2) {
            zp = (double)z + tile.zz0 - (double)r;
        }
        if (face == 3) {
            zp = (double)z + tile.zz1 + (double)r;
        }
        if (face == 4) {
            xp = (double)x + tile.xx0 - (double)r;
        }
        if (face == 5) {
            xp = (double)x + tile.xx1 + (double)r;
        }
        this.add(new TerrainParticle(this.level, xp, yp, zp, 0.0, 0.0, 0.0, tile).init(x, y, z).setPower(0.2f).scale(0.6f));
    }

    public String countParticles() {
        return "" + (this.particles[0].size() + this.particles[1].size() + this.particles[2].size());
    }
}

